/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisShiftResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetShiftResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HrisShiftResult> hrisShiftResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetShiftResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HrisShiftResult> hrisShiftResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisShiftResult = hrisShiftResult;
        this.headers = headers;
    }

    public HrisGetShiftResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HrisShiftResult> hrisShiftResult() {
        return this.hrisShiftResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetShiftResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetShiftResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetShiftResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetShiftResponse withHrisShiftResult(HrisShiftResult hrisShiftResult) {
        Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
        this.hrisShiftResult = Optional.ofNullable(hrisShiftResult);
        return this;
    }

    public HrisGetShiftResponse withHrisShiftResult(Optional<? extends HrisShiftResult> hrisShiftResult) {
        Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
        this.hrisShiftResult = hrisShiftResult;
        return this;
    }

    public HrisGetShiftResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetShiftResponse other = (HrisGetShiftResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisShiftResult, other.hrisShiftResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisShiftResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetShiftResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisShiftResult", this.hrisShiftResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HrisShiftResult> hrisShiftResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisShiftResult(HrisShiftResult hrisShiftResult) {
            Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
            this.hrisShiftResult = Optional.ofNullable(hrisShiftResult);
            return this;
        }

        public Builder hrisShiftResult(Optional<? extends HrisShiftResult> hrisShiftResult) {
            Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
            this.hrisShiftResult = hrisShiftResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetShiftResponse build() {
            return new HrisGetShiftResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisShiftResult, this.headers);
        }
    }
}

