/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AssessmentOrderValue {
    public static final AssessmentOrderValue ACTIVE = new AssessmentOrderValue("active");
    public static final AssessmentOrderValue ASSESSMENT = new AssessmentOrderValue("assessment");
    public static final AssessmentOrderValue BACKGROUND_CHECK = new AssessmentOrderValue("background_check");
    public static final AssessmentOrderValue CONVERTED = new AssessmentOrderValue("converted");
    public static final AssessmentOrderValue DECLINED_BY_CANDIDATE = new AssessmentOrderValue("declined_by_candidate");
    public static final AssessmentOrderValue HIRED = new AssessmentOrderValue("hired");
    public static final AssessmentOrderValue INTERVIEW = new AssessmentOrderValue("interview");
    public static final AssessmentOrderValue LEAD = new AssessmentOrderValue("lead");
    public static final AssessmentOrderValue OFFER = new AssessmentOrderValue("offer");
    public static final AssessmentOrderValue REFERENCE_CHECK = new AssessmentOrderValue("reference_check");
    public static final AssessmentOrderValue REJECTED = new AssessmentOrderValue("rejected");
    public static final AssessmentOrderValue REVIEW = new AssessmentOrderValue("review");
    public static final AssessmentOrderValue SCREEN = new AssessmentOrderValue("screen");
    public static final AssessmentOrderValue NEW = new AssessmentOrderValue("new");
    public static final AssessmentOrderValue ONBOARDING = new AssessmentOrderValue("onboarding");
    public static final AssessmentOrderValue CREATED = new AssessmentOrderValue("created");
    public static final AssessmentOrderValue ACCEPTED = new AssessmentOrderValue("accepted");
    public static final AssessmentOrderValue SHORT_LIST = new AssessmentOrderValue("short_list");
    public static final AssessmentOrderValue APPROVED = new AssessmentOrderValue("approved");
    public static final AssessmentOrderValue UNMAPPED_VALUE = new AssessmentOrderValue("unmapped_value");
    private static final Map<String, AssessmentOrderValue> values = AssessmentOrderValue.createValuesMap();
    private static final Map<String, AssessmentOrderValueEnum> enums = AssessmentOrderValue.createEnumsMap();
    private final String value;

    private AssessmentOrderValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssessmentOrderValue of(String value) {
        Class<AssessmentOrderValue> clazz = AssessmentOrderValue.class;
        synchronized (AssessmentOrderValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AssessmentOrderValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AssessmentOrderValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssessmentOrderValue other = (AssessmentOrderValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AssessmentOrderValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssessmentOrderValue[] values() {
        Class<AssessmentOrderValue> clazz = AssessmentOrderValue.class;
        synchronized (AssessmentOrderValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AssessmentOrderValue[0]);
        }
    }

    private static final Map<String, AssessmentOrderValue> createValuesMap() {
        LinkedHashMap<String, AssessmentOrderValue> map = new LinkedHashMap<String, AssessmentOrderValue>();
        map.put("active", ACTIVE);
        map.put("assessment", ASSESSMENT);
        map.put("background_check", BACKGROUND_CHECK);
        map.put("converted", CONVERTED);
        map.put("declined_by_candidate", DECLINED_BY_CANDIDATE);
        map.put("hired", HIRED);
        map.put("interview", INTERVIEW);
        map.put("lead", LEAD);
        map.put("offer", OFFER);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("rejected", REJECTED);
        map.put("review", REVIEW);
        map.put("screen", SCREEN);
        map.put("new", NEW);
        map.put("onboarding", ONBOARDING);
        map.put("created", CREATED);
        map.put("accepted", ACCEPTED);
        map.put("short_list", SHORT_LIST);
        map.put("approved", APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssessmentOrderValueEnum> createEnumsMap() {
        HashMap<String, AssessmentOrderValueEnum> map = new HashMap<String, AssessmentOrderValueEnum>();
        map.put("active", AssessmentOrderValueEnum.ACTIVE);
        map.put("assessment", AssessmentOrderValueEnum.ASSESSMENT);
        map.put("background_check", AssessmentOrderValueEnum.BACKGROUND_CHECK);
        map.put("converted", AssessmentOrderValueEnum.CONVERTED);
        map.put("declined_by_candidate", AssessmentOrderValueEnum.DECLINED_BY_CANDIDATE);
        map.put("hired", AssessmentOrderValueEnum.HIRED);
        map.put("interview", AssessmentOrderValueEnum.INTERVIEW);
        map.put("lead", AssessmentOrderValueEnum.LEAD);
        map.put("offer", AssessmentOrderValueEnum.OFFER);
        map.put("reference_check", AssessmentOrderValueEnum.REFERENCE_CHECK);
        map.put("rejected", AssessmentOrderValueEnum.REJECTED);
        map.put("review", AssessmentOrderValueEnum.REVIEW);
        map.put("screen", AssessmentOrderValueEnum.SCREEN);
        map.put("new", AssessmentOrderValueEnum.NEW);
        map.put("onboarding", AssessmentOrderValueEnum.ONBOARDING);
        map.put("created", AssessmentOrderValueEnum.CREATED);
        map.put("accepted", AssessmentOrderValueEnum.ACCEPTED);
        map.put("short_list", AssessmentOrderValueEnum.SHORT_LIST);
        map.put("approved", AssessmentOrderValueEnum.APPROVED);
        map.put("unmapped_value", AssessmentOrderValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AssessmentOrderValueEnum {
        ACTIVE("active"),
        ASSESSMENT("assessment"),
        BACKGROUND_CHECK("background_check"),
        CONVERTED("converted"),
        DECLINED_BY_CANDIDATE("declined_by_candidate"),
        HIRED("hired"),
        INTERVIEW("interview"),
        LEAD("lead"),
        OFFER("offer"),
        REFERENCE_CHECK("reference_check"),
        REJECTED("rejected"),
        REVIEW("review"),
        SCREEN("screen"),
        NEW("new"),
        ONBOARDING("onboarding"),
        CREATED("created"),
        ACCEPTED("accepted"),
        SHORT_LIST("short_list"),
        APPROVED("approved"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AssessmentOrderValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AssessmentOrderValue> {
        protected _Deserializer() {
            super(AssessmentOrderValue.class);
        }

        public AssessmentOrderValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AssessmentOrderValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AssessmentOrderValue> {
        protected _Serializer() {
            super(AssessmentOrderValue.class);
        }

        public void serialize(AssessmentOrderValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

