/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISTeamsResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HrisGetTeamGroupResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HRISTeamsResult> hrisTeamsResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetTeamGroupResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HRISTeamsResult> hrisTeamsResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisTeamsResult, "hrisTeamsResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisTeamsResult = hrisTeamsResult;
        this.headers = headers;
    }

    public HrisGetTeamGroupResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISTeamsResult> hrisTeamsResult() {
        return this.hrisTeamsResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisGetTeamGroupResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetTeamGroupResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetTeamGroupResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetTeamGroupResponse withHRISTeamsResult(HRISTeamsResult hrisTeamsResult) {
        Utils.checkNotNull(hrisTeamsResult, "hrisTeamsResult");
        this.hrisTeamsResult = Optional.ofNullable(hrisTeamsResult);
        return this;
    }

    public HrisGetTeamGroupResponse withHRISTeamsResult(Optional<? extends HRISTeamsResult> hrisTeamsResult) {
        Utils.checkNotNull(hrisTeamsResult, "hrisTeamsResult");
        this.hrisTeamsResult = hrisTeamsResult;
        return this;
    }

    public HrisGetTeamGroupResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetTeamGroupResponse other = (HrisGetTeamGroupResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.hrisTeamsResult, other.hrisTeamsResult) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.hrisTeamsResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetTeamGroupResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisTeamsResult", this.hrisTeamsResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HRISTeamsResult> hrisTeamsResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisTeamsResult(HRISTeamsResult hrisTeamsResult) {
            Utils.checkNotNull(hrisTeamsResult, "hrisTeamsResult");
            this.hrisTeamsResult = Optional.ofNullable(hrisTeamsResult);
            return this;
        }

        public Builder hrisTeamsResult(Optional<? extends HRISTeamsResult> hrisTeamsResult) {
            Utils.checkNotNull(hrisTeamsResult, "hrisTeamsResult");
            this.hrisTeamsResult = hrisTeamsResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetTeamGroupResponse build() {
            return new HrisGetTeamGroupResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisTeamsResult, this.headers);
        }
    }
}

