/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.asterisk.fastagi.AGIConnectionHandler;
import net.sf.asterisk.fastagi.AGIServer;
import net.sf.asterisk.fastagi.MappingStrategy;
import net.sf.asterisk.fastagi.ResourceBundleMappingStrategy;
import net.sf.asterisk.io.ServerSocketFacade;
import net.sf.asterisk.io.SocketConnectionFacade;
import net.sf.asterisk.io.impl.ServerSocketFacadeImpl;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;
import net.sf.asterisk.util.ThreadPool;

public class DefaultAGIServer
implements AGIServer {
    private static final String DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME = "fastagi";
    private static final int DEFAULT_BIND_PORT = 4573;
    private static final int DEFAULT_POOL_SIZE = 10;
    private final Log logger = LogFactory.getLog(class$net$sf$asterisk$fastagi$DefaultAGIServer == null ? (class$net$sf$asterisk$fastagi$DefaultAGIServer = DefaultAGIServer.class$("net.sf.asterisk.fastagi.DefaultAGIServer")) : class$net$sf$asterisk$fastagi$DefaultAGIServer);
    private ServerSocketFacade serverSocket;
    private int port = 4573;
    private ThreadPool pool;
    private int poolSize = 10;
    private boolean die;
    private MappingStrategy mappingStrategy = new ResourceBundleMappingStrategy();
    static /* synthetic */ Class class$net$sf$asterisk$fastagi$DefaultAGIServer;

    public DefaultAGIServer() {
        this.loadConfig();
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setBindPort(int bindPort) {
        this.port = bindPort;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMappingStrategy(MappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    private void loadConfig() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME);
        }
        catch (MissingResourceException e) {
            return;
        }
        try {
            String portString = resourceBundle.getString("port");
            if (portString == null) {
                portString = resourceBundle.getString("bindPort");
            }
            this.port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String poolSizeString = resourceBundle.getString("poolSize");
            this.poolSize = Integer.parseInt(poolSizeString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ServerSocketFacade createServerSocket() throws IOException {
        return new ServerSocketFacadeImpl(this.port, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() throws IOException, IllegalStateException {
        this.die = false;
        this.pool = new ThreadPool("AGIServer", this.poolSize);
        this.logger.info("Thread pool started.");
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (IOException e) {
            this.logger.error("Unable start AGI Server: cannot to bind to *:" + this.port + ".", e);
            throw e;
        }
        this.logger.info("Listening on *:" + this.port + ".");
        try {
            SocketConnectionFacade socket;
            while ((socket = this.serverSocket.accept()) != null) {
                this.logger.info("Received connection.");
                AGIConnectionHandler connectionHandler = new AGIConnectionHandler(socket, this.mappingStrategy);
                this.pool.addJob(connectionHandler);
            }
        }
        catch (IOException e) {
            if (!this.die) {
                this.logger.error("IOException while waiting for connections.", e);
                throw e;
            }
        }
        finally {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {}
            }
            this.serverSocket = null;
            this.pool.shutdown();
            this.logger.info("AGIServer shut down.");
        }
    }

    public void run() {
        try {
            this.startup();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void die() throws IOException {
        this.die = true;
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    public void shutdown() throws IOException, IllegalStateException {
        this.die();
    }

    public static void main(String[] args) throws Exception {
        DefaultAGIServer server = new DefaultAGIServer();
        server.startup();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

