/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaAdapter;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.program.JavaClassDef;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCollectionAdapter
extends JavaAdapter {
    private Collection<Object> _collection;

    public JavaCollectionAdapter(Env env, Collection<Object> coll, JavaClassDef def) {
        super(env, coll, def);
        this._collection = coll;
    }

    @Override
    public void clear() {
        this._collection.clear();
    }

    @Override
    public Value copy() {
        return new JavaCollectionAdapter(this.getEnv(), this._collection, this.getClassDef());
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        return new JavaCollectionAdapter(env, this._collection, this.getClassDef());
    }

    @Override
    public int getSize() {
        return this._collection.size();
    }

    @Override
    public Value createTailKey() {
        return LongValue.create(this.getSize());
    }

    @Override
    public Value putImpl(Value key, Value value) {
        if (key.toInt() != this.getSize()) {
            throw new UnsupportedOperationException("random assignment into Collection");
        }
        this._collection.add(value.toJavaObject());
        return value;
    }

    @Override
    public Value get(Value key) {
        int pos = key.toInt();
        if (pos < 0) {
            return UnsetValue.UNSET;
        }
        for (Object obj : this._collection) {
            if (pos-- > 0) continue;
            return this.wrapJava(obj);
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value remove(Value key) {
        int pos = key.toInt();
        if (pos < 0) {
            return UnsetValue.UNSET;
        }
        for (Object obj : this._collection) {
            if (pos-- > 0) continue;
            Value val = this.wrapJava(obj);
            this._collection.remove(obj);
            return val;
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Set<Map.Entry<Value, Value>> entrySet() {
        return new CollectionValueSet();
    }

    @Override
    public Set<Map.Entry<Object, Object>> objectEntrySet() {
        return new CollectionSet();
    }

    @Override
    public Collection<Value> values() {
        return new ValueCollection();
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        return new CollectionValueIterator();
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        return new KeyIterator();
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        return new ValueIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueIterator
    implements Iterator<Value> {
        private Iterator _iterator;

        public ValueIterator() {
            this._iterator = JavaCollectionAdapter.this._collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Value next() {
            return JavaCollectionAdapter.this.wrapJava(this._iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeyIterator
    implements Iterator<Value> {
        private int _index = 0;
        private Iterator _iterator;

        public KeyIterator() {
            this._iterator = JavaCollectionAdapter.this._collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Value next() {
            this._iterator.next();
            return LongValue.create(this._index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueCollection
    extends AbstractCollection<Value> {
        ValueCollection() {
        }

        @Override
        public int size() {
            return JavaCollectionAdapter.this.getSize();
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator();
        }
    }

    public static class CollectionValueEntry
    extends ArrayValue.Entry {
        public CollectionValueEntry(Value key, Value value) {
            super(key, value);
        }

        public ArrayValue.Entry getNext() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CollectionValueIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private int _index = 0;
        private Iterator _iterator;

        public CollectionValueIterator() {
            this._iterator = JavaCollectionAdapter.this._collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<Value, Value> next() {
            Value val = JavaCollectionAdapter.this.wrapJava(this._iterator.next());
            return new CollectionValueEntry(LongValue.create(this._index++), val);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CollectionValueSet
    extends AbstractSet<Map.Entry<Value, Value>> {
        CollectionValueSet() {
        }

        @Override
        public int size() {
            return JavaCollectionAdapter.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> iterator() {
            return new CollectionValueIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionEntry
    implements Map.Entry<Object, Object> {
        private final int _key;
        private Object _value;

        public CollectionEntry(int key, Object value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public Object getKey() {
            return this._key;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this._value;
            this._value = value;
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CollectionIterator
    implements Iterator<Map.Entry<Object, Object>> {
        private int _index = 0;
        private Iterator _iterator;

        public CollectionIterator() {
            this._iterator = JavaCollectionAdapter.this._collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<Object, Object> next() {
            return new CollectionEntry(this._index++, this._iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CollectionSet
    extends AbstractSet<Map.Entry<Object, Object>> {
        CollectionSet() {
        }

        @Override
        public int size() {
            return JavaCollectionAdapter.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return new CollectionIterator();
        }
    }
}

