/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.EachExpr;
import com.caucho.quercus.expr.Expr;

public class ListEachExpr
extends Expr {
    protected final AbstractVarExpr _keyVar;
    protected final AbstractVarExpr _valueVar;
    protected final Expr _value;

    public ListEachExpr(Expr[] varList, EachExpr each) {
        this._keyVar = varList.length > 0 ? (AbstractVarExpr)varList[0] : null;
        this._valueVar = varList.length > 1 ? (AbstractVarExpr)varList[1] : null;
        this._value = each.getExpr();
    }

    public Value eval(Env env) {
        Value value = this._value.eval(env);
        if (!(value instanceof ArrayValue)) {
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)value;
        if (this._keyVar != null) {
            this._keyVar.evalAssign(env, array.key());
        }
        if (this._valueVar != null) {
            this._valueVar.evalAssign(env, array.current());
        }
        return array.each();
    }

    public boolean evalBoolean(Env env) {
        Value value = this._value.eval(env);
        if (!(value instanceof ArrayValue)) {
            return false;
        }
        ArrayValue array = (ArrayValue)value;
        if (!array.hasCurrent()) {
            return false;
        }
        if (this._keyVar != null) {
            this._keyVar.evalAssign(env, array.key());
        }
        if (this._valueVar != null) {
            this._valueVar.evalAssign(env, array.current());
        }
        array.next();
        return true;
    }
}

