/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(MailModule.class.getName());
    private static final L10N L = new L10N(MailModule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mail(Env env, String to, String subject, StringValue message, @Optional String additionalHeaders, @Optional String additionalParameters) {
        Transport smtp = null;
        try {
            Address[] from;
            HashMap<String, String> headers = MailModule.splitHeaders(additionalHeaders);
            if (to == null || to.equals("")) {
                to = headers.get("to");
            }
            Properties props = new Properties();
            StringValue host = env.getIni("SMTP");
            if (host != null && !host.toString().equals("")) {
                props.put("mail.smtp.host", host.toString());
            } else if (System.getProperty("mail.smtp.host") != null) {
                props.put("mail.smtp.host", System.getProperty("mail.smtp.host"));
            }
            StringValue port = env.getIni("smtp_port");
            if (port != null && !port.toString().equals("")) {
                props.put("mail.smtp.port", port.toString());
            } else if (System.getProperty("mail.smtp.port") != null) {
                props.put("mail.smtp.port", System.getProperty("mail.smtp.port"));
            }
            if (System.getProperty("mail.smtp.class") != null) {
                props.put("mail.smtp.class", System.getProperty("mail.smtp.class"));
            }
            StringValue user = null;
            if (headers.get("from") != null) {
                user = env.createString(headers.get("from"));
            }
            if (user == null) {
                user = env.getIni("sendmail_from");
            }
            if (user != null && !user.toString().equals("")) {
                String userString = user.toString();
                props.put("mail.from", userString);
            } else if (System.getProperty("mail.from") != null) {
                props.put("mail.from", System.getProperty("mail.from"));
            } else {
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    String email = System.getProperty("user.name") + "@" + addr.getHostName();
                    props.put("mail.from", email);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            String username = env.getIniString("smtp_username");
            String password = env.getIniString("smtp_password");
            if (password != null && !"".equals(password)) {
                props.put("mail.smtp.auth", "true");
            }
            Session mailSession = Session.getInstance((Properties)props, null);
            smtp = mailSession.getTransport("smtp");
            MimeMessage msg = new MimeMessage(mailSession);
            if (subject == null) {
                subject = "";
            }
            msg.setSubject(subject);
            msg.setContent((Object)message.toString(), "text/plain");
            ArrayList<Address> addrList = MailModule.addRecipients(msg, Message.RecipientType.TO, to);
            if (headers != null) {
                MailModule.addHeaders(msg, headers);
            }
            if ((from = msg.getFrom()) == null || from.length == 0) {
                log.fine(L.l("mail 'From' not set, setting to Java System property 'user.name'"));
                msg.setFrom();
            }
            msg.saveChanges();
            if (addrList.size() == 0) {
                throw new QuercusModuleException(L.l("mail has no recipients"));
            }
            from = msg.getFrom();
            log.fine(L.l("sending mail, From: {0}, To: {1}", (Object)from[0], (Object)to));
            if (password != null && !"".equals(password)) {
                smtp.connect(username, password);
            } else {
                smtp.connect();
            }
            Address[] addr = new Address[addrList.size()];
            addrList.toArray(addr);
            smtp.sendMessage((Message)msg, addr);
            log.fine("quercus-mail: sent mail to " + to);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            log.log(Level.FINER, e.toString(), e);
            throw e;
        }
        catch (AuthenticationFailedException e) {
            log.warning(L.l("Quercus[] mail could not send mail to '{0}' because authentication failed\n{1}", (Object)to, (Object)e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            env.warning(e.toString());
            boolean props = false;
            return props;
        }
        catch (MessagingException e) {
            MessagingException cause = e;
            log.warning(L.l("Quercus[] mail could not send mail to '{0}'\n{1}", (Object)to, (Object)cause.getMessage()));
            log.log(Level.FINE, cause.toString(), cause);
            env.warning(cause.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Exception cause = e;
            log.warning(L.l("Quercus[] mail could not send mail to '{0}'\n{1}", (Object)to, (Object)cause.getMessage()));
            log.log(Level.FINE, cause.toString(), cause);
            env.warning(cause.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (smtp != null) {
                    smtp.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    private static ArrayList<Address> addRecipients(MimeMessage msg, Message.RecipientType type, String to) throws MessagingException {
        String[] split = to.split(",");
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (int i = 0; i < split.length; ++i) {
            int space;
            int closeBracket;
            String addrStr = split[i];
            if (addrStr.length() <= 0) continue;
            int openBracket = addrStr.indexOf(60);
            if (openBracket >= 0 && !addrStr.contains("\"") && (closeBracket = addrStr.indexOf(62, openBracket + 1)) > openBracket && openBracket < (space = addrStr.indexOf(32, openBracket + 1)) && space < closeBracket) {
                StringBuilder sb = new StringBuilder();
                sb.append(addrStr, 0, openBracket + 1);
                sb.append("\"");
                sb.append(addrStr, openBracket + 1, closeBracket);
                sb.append("\"");
                sb.append(addrStr, closeBracket, addrStr.length());
                addrStr = sb.toString();
            }
            InternetAddress addr = new InternetAddress(addrStr);
            addresses.add((Address)addr);
            msg.addRecipient(type, (Address)addr);
        }
        return addresses;
    }

    private static void addHeaders(MimeMessage msg, HashMap<String, String> headerMap) throws MessagingException {
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if ("".equals(value)) continue;
            if (name.equalsIgnoreCase("From")) {
                msg.setFrom((Address)new InternetAddress(value));
                continue;
            }
            if (name.equalsIgnoreCase("To")) {
                MailModule.addRecipients(msg, Message.RecipientType.TO, value);
                continue;
            }
            msg.addHeader(name, value);
        }
    }

    private static HashMap<String, String> splitHeaders(String headers) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (headers == null) {
            return headerMap;
        }
        int i = 0;
        int len = headers.length();
        CharBuffer buffer = new CharBuffer();
        while (i < len) {
            char ch;
            while (i < len && Character.isWhitespace(headers.charAt(i))) {
                ++i;
            }
            if (len <= i) {
                return headerMap;
            }
            buffer.clear();
            while (i < len && !Character.isWhitespace(ch = headers.charAt(i)) && ch != ':') {
                buffer.append(ch);
                ++i;
            }
            while (i < len && ((ch = headers.charAt(i)) == ' ' || ch == '\t' || ch == '\f' || ch == ':')) {
                ++i;
            }
            String name = buffer.toString();
            buffer.clear();
            while (i < len && (ch = headers.charAt(i)) != '\r' && ch != '\n') {
                buffer.append(ch);
                ++i;
            }
            String value = buffer.toString();
            if ("".equals(value)) continue;
            headerMap.put(name, value);
        }
        return headerMap;
    }
}

