/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jruby.objectweb.asm.ClassReader;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import jruby.objectweb.asm.util.CheckClassAdapter;
import jruby.objectweb.asm.util.TraceClassVisitor;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.ScriptCompiler;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.InheritedCacheCompiler;
import org.jruby.compiler.impl.MethodBodyCompiler;
import org.jruby.compiler.impl.RootScopedBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardASMCompiler
implements ScriptCompiler,
Opcodes {
    public static final String THREADCONTEXT = CodegenUtils.p(ThreadContext.class);
    public static final String RUBY = CodegenUtils.p(Ruby.class);
    public static final String IRUBYOBJECT = CodegenUtils.p(IRubyObject.class);
    public static final String[] METHOD_SIGNATURES = new String[]{CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class)};
    public static final String CLOSURE_SIGNATURE = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
    public static final String CLOSURE_SIGNATURE19 = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
    public static final int THIS = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int ARGS_INDEX = 3;
    public static final int CLOSURE_OFFSET = 0;
    public static final int DYNAMIC_SCOPE_OFFSET = 1;
    public static final int RUNTIME_OFFSET = 2;
    public static final int VARS_ARRAY_OFFSET = 3;
    public static final int NIL_OFFSET = 4;
    public static final int EXCEPTION_OFFSET = 5;
    public static final int PREVIOUS_EXCEPTION_OFFSET = 6;
    public static final int FIRST_TEMP_OFFSET = 7;
    public static final int STARTING_DSTR_SIZE = 20;
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    private SkinnyMethodAdapter initMethod;
    private SkinnyMethodAdapter clinitMethod;
    private int methodIndex = 0;
    private int innerIndex = 0;
    int fieldIndex = 0;
    private int rescueNumber = 1;
    private int ensureNumber = 1;
    StaticScope topLevelScope;
    private CacheCompiler cacheCompiler;
    public static final Constructor invDynInvCompilerConstructor;
    public static final Method invDynSupportInstaller;
    private int constants = 0;

    public StandardASMCompiler(String classname, String sourcename) {
        this.classname = classname;
        this.sourcename = sourcename;
    }

    public byte[] getClassByteArray() {
        return this.classWriter.toByteArray();
    }

    public Class<?> loadClass(JRubyClassLoader classLoader) throws ClassNotFoundException {
        classLoader.defineClass(CodegenUtils.c(this.getClassname()), this.classWriter.toByteArray());
        return classLoader.loadClass(CodegenUtils.c(this.getClassname()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpClass(PrintStream out) {
        PrintWriter pw = new PrintWriter(out);
        try {
            TraceClassVisitor tcv = new TraceClassVisitor(pw);
            new ClassReader(this.classWriter.toByteArray()).accept(tcv, 0);
        }
        finally {
            pw.close();
        }
    }

    public void writeClass(File destination) throws IOException {
        this.writeClass(this.getClassname(), destination, this.classWriter);
    }

    private void writeClass(String classname, File destination, ClassWriter writer) throws IOException {
        String fullname = classname + ".class";
        String filename2 = null;
        String path2 = null;
        byte[] bytecode = writer.toByteArray();
        CheckClassAdapter.verify(new ClassReader(bytecode), false, new PrintWriter(System.err));
        if (fullname.lastIndexOf("/") == -1) {
            filename2 = fullname;
            path2 = "";
        } else {
            filename2 = fullname.substring(fullname.lastIndexOf("/") + 1);
            path2 = fullname.substring(0, fullname.lastIndexOf("/"));
        }
        File pathfile = new File(destination, path2);
        pathfile.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(pathfile, filename2));
        out.write(bytecode);
        out.close();
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    @Override
    public void startScript(StaticScope scope) {
        String sourceNoPath;
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(RubyInstanceConfig.JAVA_VERSION, 33, this.getClassname(), null, CodegenUtils.p(AbstractScript.class), null);
        SkinnyMethodAdapter method2 = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(4106, "setPosition", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, Integer.TYPE)), null, null));
        method2.start();
        method2.aload(0);
        method2.ldc(this.sourcename);
        method2.iload(1);
        method2.invokevirtual(CodegenUtils.p(ThreadContext.class), "setFileAndLine", CodegenUtils.sig(Void.TYPE, String.class, Integer.TYPE));
        method2.voidreturn();
        method2.end();
        this.topLevelScope = scope;
        this.beginInit();
        this.cacheCompiler = new InheritedCacheCompiler(this);
        if (this.sourcename.indexOf("/") >= 0) {
            String[] pathElements = this.sourcename.split("/");
            sourceNoPath = pathElements[pathElements.length - 1];
        } else if (this.sourcename.indexOf("\\") >= 0) {
            String[] pathElements = this.sourcename.split("\\\\");
            sourceNoPath = pathElements[pathElements.length - 1];
        } else {
            sourceNoPath = this.sourcename;
        }
        this.classWriter.visitSource(sourceNoPath, null);
    }

    @Override
    public void endScript(boolean generateLoad, boolean generateMain) {
        SkinnyMethodAdapter method2;
        String methodName = "__file__";
        if (generateLoad || generateMain) {
            method2 = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "load", METHOD_SIGNATURES[4], null, null));
            method2.start();
            Label tryBegin = new Label();
            Label tryFinally = new Label();
            method2.label(tryBegin);
            method2.aload(1);
            StandardASMCompiler.buildStaticScopeNames(method2, this.topLevelScope);
            method2.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "preLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String[].class));
            method2.aload(0);
            method2.aload(1);
            method2.aload(2);
            method2.aload(3);
            method2.aload(4);
            method2.invokevirtual(this.getClassname(), methodName, METHOD_SIGNATURES[4]);
            method2.aload(1);
            method2.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            method2.areturn();
            method2.label(tryFinally);
            method2.aload(1);
            method2.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            method2.athrow();
            method2.trycatch(tryBegin, tryFinally, tryFinally, null);
            method2.end();
        }
        if (generateMain) {
            method2 = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, "main", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String[].class)), null, null));
            method2.start();
            method2.newobj(this.getClassname());
            method2.dup();
            method2.invokespecial(this.getClassname(), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            method2.newobj(CodegenUtils.p(RubyInstanceConfig.class));
            method2.dup();
            method2.invokespecial(CodegenUtils.p(RubyInstanceConfig.class), "<init>", "()V");
            method2.dup();
            method2.aload(0);
            method2.invokevirtual(CodegenUtils.p(RubyInstanceConfig.class), "setArgv", CodegenUtils.sig(Void.TYPE, String[].class));
            method2.invokestatic(CodegenUtils.p(Ruby.class), "newInstance", CodegenUtils.sig(Ruby.class, RubyInstanceConfig.class));
            method2.dup();
            method2.invokevirtual(RUBY, "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
            method2.swap();
            method2.invokevirtual(RUBY, "getTopSelf", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            method2.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            method2.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            method2.invokevirtual(this.getClassname(), "load", METHOD_SIGNATURES[4]);
            method2.voidreturn();
            method2.end();
        }
        this.getCacheCompiler().finish();
        this.endInit();
        this.endClassInit();
    }

    public static void buildStaticScopeNames(SkinnyMethodAdapter method2, StaticScope scope) {
        String signature = null;
        switch (scope.getNumberOfVariables()) {
            case 0: {
                method2.pushInt(0);
                method2.anewarray(CodegenUtils.p(String.class));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                signature = CodegenUtils.sig(String[].class, CodegenUtils.params(String.class, scope.getNumberOfVariables()));
                for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                    method2.ldc(scope.getVariables()[i]);
                }
                method2.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructStringArray", signature);
                break;
            }
            default: {
                method2.pushInt(scope.getNumberOfVariables());
                method2.anewarray(CodegenUtils.p(String.class));
                for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                    method2.dup();
                    method2.pushInt(i);
                    method2.ldc(scope.getVariables()[i]);
                    method2.arraystore();
                }
            }
        }
    }

    private void beginInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.initMethod = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        this.initMethod.start();
        this.initMethod.aload(0);
        this.initMethod.invokespecial(CodegenUtils.p(AbstractScript.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        cv.visitField(18, "$class", CodegenUtils.ci(Class.class), null, null);
        this.initMethod.aload(0);
        this.initMethod.ldc(CodegenUtils.c(this.getClassname()));
        this.initMethod.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        this.initMethod.putfield(this.getClassname(), "$class", CodegenUtils.ci(Class.class));
        this.initMethod.aload(0);
        this.initMethod.ldc(this.getSourcename());
        this.initMethod.putfield(this.getClassname(), "filename", CodegenUtils.ci(String.class));
    }

    private void endInit() {
        this.initMethod.voidreturn();
        this.initMethod.end();
    }

    private void beginClassInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.clinitMethod = new SkinnyMethodAdapter(cv.visitMethod(9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        this.clinitMethod.start();
        if (invDynSupportInstaller != null) {
            try {
                invDynSupportInstaller.invoke(null, this.clinitMethod, this.getClassname());
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void endClassInit() {
        if (this.clinitMethod != null) {
            this.clinitMethod.voidreturn();
            this.clinitMethod.end();
        }
    }

    public SkinnyMethodAdapter getInitMethod() {
        return this.initMethod;
    }

    public SkinnyMethodAdapter getClassInitMethod() {
        if (this.clinitMethod == null) {
            this.beginClassInit();
        }
        return this.clinitMethod;
    }

    public CacheCompiler getCacheCompiler() {
        return this.cacheCompiler;
    }

    @Override
    public BodyCompiler startMethod(String rubyName, String javaName, CompilerCallback args2, StaticScope scope, ASTInspector inspector) {
        MethodBodyCompiler methodCompiler = new MethodBodyCompiler(this, rubyName, javaName, inspector, scope);
        ((RootScopedBodyCompiler)methodCompiler).beginMethod(args2, scope);
        return methodCompiler;
    }

    @Override
    public BodyCompiler startRoot(String rubyName, String javaName, StaticScope scope, ASTInspector inspector) {
        MethodBodyCompiler methodCompiler = new MethodBodyCompiler(this, rubyName, javaName, inspector, scope);
        ((RootScopedBodyCompiler)methodCompiler).beginMethod(null, scope);
        return methodCompiler;
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public int getAndIncrementMethodIndex() {
        return this.methodIndex++;
    }

    public int getInnerIndex() {
        return this.innerIndex;
    }

    public int getAndIncrementInnerIndex() {
        return this.innerIndex++;
    }

    public int getRescueNumber() {
        return this.rescueNumber;
    }

    public int getAndIncrementRescueNumber() {
        return this.rescueNumber++;
    }

    public int getEnsureNumber() {
        return this.ensureNumber;
    }

    public int getAndIncrementEnsureNumber() {
        return this.ensureNumber++;
    }

    public String getNewConstant(String type2, String name_prefix) {
        return this.getNewConstant(type2, name_prefix, null);
    }

    public synchronized String getNewConstantName() {
        return "_" + this.constants++;
    }

    public String getNewConstant(String type2, String name_prefix, Object init) {
        ClassVisitor cv = this.getClassVisitor();
        String realName = this.getNewConstantName();
        cv.visitField(2, realName, type2, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.getClassname(), realName, type2);
        }
        return realName;
    }

    public String getNewField(String type2, String name2, Object init) {
        ClassVisitor cv = this.getClassVisitor();
        cv.visitField(2, name2, type2, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.getClassname(), name2, type2);
        }
        return name2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewStaticConstant(String type2, String name_prefix) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = "__" + this.constants++;
        }
        cv.visitField(26, realName, type2, null, null).visitEnd();
        return realName;
    }

    static {
        Constructor<?> compilerConstructor = null;
        Method installerMethod = null;
        try {
            Class.forName("java.dyn.Dynamic");
            Class<?> compiler = Class.forName("org.jruby.compiler.impl.InvokeDynamicInvocationCompiler");
            Class<?> support = Class.forName("org.jruby.runtime.invokedynamic.InvokeDynamicSupport");
            compilerConstructor = compiler.getConstructor(BaseBodyCompiler.class, SkinnyMethodAdapter.class);
            installerMethod = support.getDeclaredMethod("installBytecode", MethodVisitor.class, String.class);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        invDynInvCompilerConstructor = compilerConstructor;
        invDynSupportInstaller = installerMethod;
    }
}

