/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.environment;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyString;

public class OSEnvironment {
    public Map getEnvironmentVariableMap(Ruby runtime2) {
        Map envs = null;
        if (runtime2.getInstanceConfig().getEnvironment() != null) {
            return OSEnvironment.getAsMapOfRubyStrings(runtime2, runtime2.getInstanceConfig().getEnvironment().entrySet());
        }
        if (Ruby.isSecurityRestricted()) {
            envs = new HashMap();
        } else {
            Map<String, String> variables = System.getenv();
            envs = OSEnvironment.getAsMapOfRubyStrings(runtime2, variables.entrySet());
        }
        return envs;
    }

    public Map getSystemPropertiesMap(Ruby runtime2) {
        if (Ruby.isSecurityRestricted()) {
            return new HashMap();
        }
        return OSEnvironment.getAsMapOfRubyStrings(runtime2, System.getProperties().entrySet());
    }

    private static Map getAsMapOfRubyStrings(Ruby runtime2, Set entrySet) {
        HashMap<RubyString, RubyString> envs = new HashMap<RubyString, RubyString>();
        for (Map.Entry entry : entrySet) {
            envs.put(runtime2.newString(entry.getKey().toString()), runtime2.newString(entry.getValue().toString()));
        }
        return envs;
    }
}

