/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.ConfbridgeListEvent;
import org.asteriskjava.manager.event.ConnectEvent;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ExtensionStatusEvent;
import org.asteriskjava.manager.event.MeetMeJoinEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.PeerEntryEvent;
import org.asteriskjava.manager.event.QueueCallerLeaveEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.StatusCompleteEvent;
import org.asteriskjava.manager.event.VarSetEvent;
import org.asteriskjava.pbx.asterisk.wrap.actions.ManagerAction;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ConfbridgeListCompleteEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.DialEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.DndStateEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.MasqueradeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.MeetMeLeaveEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewStateEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.OriginateResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.PeerStatusEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.PeerlistCompleteEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.StatusEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnparkedCallEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.CommandResponse;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerError;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class CoherentEventFactory {
    private static final Log logger = LogFactory.getLog(CoherentEventFactory.class);
    static Hashtable<Class<? extends org.asteriskjava.manager.event.ManagerEvent>, Class<? extends ManagerEvent>> mapEvents = new Hashtable();
    static Hashtable<Class<? extends org.asteriskjava.manager.event.ResponseEvent>, Class<? extends ResponseEvent>> mapResponses = new Hashtable();

    public static Class<? extends ManagerEvent> getShadowEvent(org.asteriskjava.manager.event.ManagerEvent event) {
        Class<? extends ManagerEvent> result = mapEvents.get(event.getClass());
        if (result == null) {
            Class<? extends ResponseEvent> response = mapResponses.get(event.getClass());
            result = response;
        }
        return result;
    }

    public static ManagerEvent build(org.asteriskjava.manager.event.ManagerEvent event) {
        ManagerEvent iEvent = null;
        Class<ManagerEvent> target = null;
        target = event instanceof org.asteriskjava.manager.event.ResponseEvent ? mapResponses.get(event.getClass()) : mapEvents.get(event.getClass());
        if (target == null) {
            logger.warn("The given event " + event.getClass().getName() + " is not supported ");
        } else {
            try {
                iEvent = target.getDeclaredConstructor(event.getClass()).newInstance(event);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error(e, e);
            }
        }
        return iEvent;
    }

    public static ResponseEvent build(org.asteriskjava.manager.event.ResponseEvent event) {
        ResponseEvent response = null;
        Class<? extends ResponseEvent> target = mapResponses.get(event.getClass());
        if (target == null) {
            logger.warn("The given event " + event.getClass().getName() + " is not supported ");
        } else {
            try {
                Constructor<? extends ResponseEvent> declaredConstructor = target.getDeclaredConstructor(event.getClass());
                response = declaredConstructor.newInstance(event);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error(e, e);
            }
        }
        return response;
    }

    public static ManagerResponse build(org.asteriskjava.manager.response.ManagerResponse response) {
        ManagerResponse result = response instanceof org.asteriskjava.manager.response.CommandResponse ? new CommandResponse((org.asteriskjava.manager.response.CommandResponse)response) : (response instanceof org.asteriskjava.manager.response.ManagerError ? new ManagerError((org.asteriskjava.manager.response.ManagerError)response) : new ManagerResponse(response));
        return result;
    }

    public static org.asteriskjava.manager.action.ManagerAction build(ManagerAction action) {
        org.asteriskjava.manager.action.ManagerAction result = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Action " + action);
        }
        result = action.getAJAction();
        return result;
    }

    static {
        mapEvents.put(AgentCalledEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.AgentCalledEvent.class);
        mapEvents.put(AgentConnectEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.AgentConnectEvent.class);
        mapEvents.put(QueueCallerLeaveEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.QueueCallerLeaveEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.BridgeEvent.class, BridgeEvent.class);
        mapEvents.put(ConnectEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.ConnectEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.DialEvent.class, DialEvent.class);
        mapEvents.put(DisconnectEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.DisconnectEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.DndStateEvent.class, DndStateEvent.class);
        mapEvents.put(ExtensionStatusEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.ExtensionStatusEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.HangupEvent.class, HangupEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.LinkEvent.class, LinkEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.MasqueradeEvent.class, MasqueradeEvent.class);
        mapEvents.put(MeetMeJoinEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.MeetMeJoinEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.MeetMeLeaveEvent.class, MeetMeLeaveEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.NewChannelEvent.class, NewChannelEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.NewStateEvent.class, NewStateEvent.class);
        mapEvents.put(ParkedCallEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.ParkedCallEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.PeerStatusEvent.class, PeerStatusEvent.class);
        mapEvents.put(RenameEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.RenameEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.ResponseEvent.class, ResponseEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.UnlinkEvent.class, UnlinkEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.UnparkedCallEvent.class, UnparkedCallEvent.class);
        mapEvents.put(VarSetEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.VarSetEvent.class);
        mapResponses.put(org.asteriskjava.manager.event.OriginateResponseEvent.class, OriginateResponseEvent.class);
        mapResponses.put(PeerEntryEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.PeerEntryEvent.class);
        mapResponses.put(org.asteriskjava.manager.event.PeerlistCompleteEvent.class, PeerlistCompleteEvent.class);
        mapResponses.put(org.asteriskjava.manager.event.ResponseEvent.class, ResponseEvent.class);
        mapResponses.put(StatusCompleteEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.StatusCompleteEvent.class);
        mapResponses.put(org.asteriskjava.manager.event.StatusEvent.class, StatusEvent.class);
        mapEvents.put(ConfbridgeListEvent.class, org.asteriskjava.pbx.asterisk.wrap.events.ConfbridgeListEvent.class);
        mapEvents.put(org.asteriskjava.manager.event.ConfbridgeListCompleteEvent.class, ConfbridgeListCompleteEvent.class);
    }
}

