/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence;

import java.util.LinkedHashMap;
import java.util.Map;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.GeneSequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.SequenceReader;

public class ChromosomeSequence
extends DNASequence {
    private int chromosomeNumber;
    private Map<String, GeneSequence> geneSequenceHashMap = new LinkedHashMap<String, GeneSequence>();

    public ChromosomeSequence() {
    }

    public ChromosomeSequence(String seqString) throws CompoundNotFoundException {
        super(seqString, (CompoundSet<NucleotideCompound>)DNACompoundSet.getDNACompoundSet());
    }

    public ChromosomeSequence(SequenceReader<NucleotideCompound> proxyLoader) {
        super(proxyLoader, (CompoundSet<NucleotideCompound>)DNACompoundSet.getDNACompoundSet());
    }

    public ChromosomeSequence(String seqString, CompoundSet<NucleotideCompound> compoundSet) throws CompoundNotFoundException {
        super(seqString, compoundSet);
    }

    public ChromosomeSequence(SequenceReader<NucleotideCompound> proxyLoader, CompoundSet<NucleotideCompound> compoundSet) {
        super(proxyLoader, compoundSet);
    }

    public int getChromosomeNumber() {
        return this.chromosomeNumber;
    }

    public void setChromosomeNumber(int chromosomeNumber) {
        this.chromosomeNumber = chromosomeNumber;
    }

    public Map<String, GeneSequence> getGeneSequences() {
        return this.geneSequenceHashMap;
    }

    public GeneSequence removeGeneSequence(String accession) {
        return this.geneSequenceHashMap.remove(accession);
    }

    public GeneSequence addGene(AccessionID accession, int bioBegin, int bioEnd, Strand strand) {
        GeneSequence geneSequence = new GeneSequence(this, bioBegin, bioEnd, strand);
        geneSequence.setAccession(accession);
        this.geneSequenceHashMap.put(accession.toString(), geneSequence);
        return geneSequence;
    }

    public GeneSequence getGene(String accession) {
        return this.geneSequenceHashMap.get(accession);
    }
}

