/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.TaxonomyID;
import org.biojava.nbio.core.sequence.features.DBReferenceInfo;
import org.biojava.nbio.core.sequence.io.GenbankSequenceParser;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenbankReader<S extends AbstractSequence<C>, C extends Compound> {
    private SequenceCreatorInterface<C> sequenceCreator;
    private GenbankSequenceParser<S, C> genbankParser;
    private BufferedReader bufferedReader;
    private boolean closed;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean isClosed() {
        return this.closed;
    }

    public GenbankReader(InputStream is, SequenceHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) {
        this.sequenceCreator = sequenceCreator;
        this.bufferedReader = new BufferedReader(new InputStreamReader(is));
        this.genbankParser = new GenbankSequenceParser();
        this.closed = false;
    }

    public GenbankReader(File file, SequenceHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) throws FileNotFoundException {
        this.bufferedReader = new BufferedReader(new FileReader(file));
        this.sequenceCreator = sequenceCreator;
        this.genbankParser = new GenbankSequenceParser();
    }

    public Map<String, S> process() throws IOException, CompoundNotFoundException {
        Map<String, S> result = this.process(-1);
        this.close();
        return result;
    }

    public Map<String, S> process(int max) throws IOException, CompoundNotFoundException {
        if (this.closed) {
            throw new IOException("Cannot perform action: resource has been closed.");
        }
        LinkedHashMap<String, AbstractSequence<C>> sequences = new LinkedHashMap<String, AbstractSequence<C>>();
        int i = 0;
        while (max <= 0 || i < max) {
            ++i;
            String seqString = this.genbankParser.getSequence(this.bufferedReader, 0);
            if (seqString == null) break;
            AbstractSequence<C> sequence = this.sequenceCreator.getSequence(seqString, 0L);
            GenericGenbankHeaderParser<AbstractSequence<C>, C> genbankHeaderParser = this.genbankParser.getSequenceHeaderParser();
            genbankHeaderParser.parseHeader(this.genbankParser.getHeader(), sequence);
            String id = genbankHeaderParser.getAccession();
            int version = genbankHeaderParser.getVersion();
            String identifier = genbankHeaderParser.getIdentifier();
            AccessionID accession = new AccessionID(id, DataSource.GENBANK, version, identifier);
            sequence.setAccession(accession);
            this.genbankParser.getFeatures().values().stream().flatMap(Collection::stream).forEach(sequence::addFeature);
            List<DBReferenceInfo> dbQualifier = this.genbankParser.getDatabaseReferences().get("db_xref");
            if (dbQualifier != null) {
                DBReferenceInfo q = dbQualifier.get(0);
                sequence.setTaxonomy(new TaxonomyID(q.getDatabase() + ":" + q.getId(), DataSource.GENBANK));
            }
            sequences.put(sequence.getAccession().getID(), sequence);
        }
        return sequences;
    }

    public void close() {
        try {
            this.bufferedReader.close();
            this.closed = true;
        }
        catch (IOException e) {
            this.logger.error("Couldn't close the reader.", (Throwable)e);
            this.closed = false;
        }
    }
}

