/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io.embl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.biojava.nbio.core.sequence.io.embl.EmblId;
import org.biojava.nbio.core.sequence.io.embl.EmblRecord;
import org.biojava.nbio.core.sequence.io.embl.EmblReference;

public class EmblReader {
    public static EmblRecord process(File file) throws IOException {
        EmblRecord emblRecord = new EmblRecord();
        StringBuilder sequence = new StringBuilder("");
        LinkedList<EmblReference> emblReferences = new LinkedList<EmblReference>();
        EmblReference emblReference = new EmblReference();
        LinkedList<String> accessionNumber = new LinkedList<String>();
        LinkedList<String> keyword = new LinkedList<String>();
        if (file == null) {
            throw new NullPointerException("file can't be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("the file can't be a directory");
        }
        try (FileReader fileReader = new FileReader(file);){
            String line = "";
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.length() <= 1) continue;
                    String lineInfo = line.substring(2, line.length()).trim();
                    String lineIdentifier = line.substring(0, 2);
                    if ("ID".equals(lineIdentifier)) {
                        emblRecord.setEmblId(EmblReader.populateID(lineInfo));
                        continue;
                    }
                    if ("AC".equals(lineIdentifier)) {
                        EmblReader.populateAccessionNumber(line, accessionNumber);
                        continue;
                    }
                    if ("DT".equals(lineIdentifier) && line.contains("Created")) {
                        emblRecord.setCreatedDate(lineInfo);
                        continue;
                    }
                    if ("DT".equals(lineIdentifier) && line.contains("updated")) {
                        emblRecord.setLastUpdatedDate(lineInfo);
                        continue;
                    }
                    if ("DE".equals(lineIdentifier)) {
                        emblRecord.setSequenceDescription(lineInfo);
                        continue;
                    }
                    if ("KW".equals(lineIdentifier)) {
                        keyword.add(lineInfo);
                        continue;
                    }
                    if ("OS".equals(lineIdentifier)) {
                        emblRecord.setOrganismSpecies(lineInfo);
                        continue;
                    }
                    if ("OC".equals(lineIdentifier)) {
                        emblRecord.setOrganismClassification(lineInfo);
                        continue;
                    }
                    if ("OG".equals(lineIdentifier)) {
                        emblRecord.setOrGanelle(lineInfo);
                        continue;
                    }
                    if ("RN".equals(lineIdentifier) || "RP".equals(lineIdentifier) || "RX".equals(lineIdentifier) || "RG".equals(lineIdentifier) || "RA".equals(lineIdentifier) || "RT".equals(lineIdentifier) || "RL".equals(lineIdentifier)) {
                        EmblReader.populateEmblReferences(lineIdentifier, lineInfo, emblReference, emblReferences);
                        continue;
                    }
                    if ("DR".equals(lineIdentifier)) {
                        emblRecord.setDatabaseCrossReference(lineInfo);
                        continue;
                    }
                    if ("AH".equals(lineIdentifier)) {
                        emblRecord.setAssemblyHeader(lineInfo);
                        continue;
                    }
                    if ("AS".equals(lineIdentifier)) {
                        emblRecord.setAssemblyInformation(lineInfo);
                        continue;
                    }
                    if ("CO".equals(lineIdentifier)) {
                        emblRecord.setConstructedSequence(lineInfo);
                        continue;
                    }
                    if ("FH".equals(lineIdentifier)) {
                        emblRecord.setFeatureHeader(lineInfo);
                        continue;
                    }
                    if ("FT".equals(lineIdentifier)) {
                        emblRecord.setFeatureTable(lineInfo);
                        continue;
                    }
                    if ("SQ".equals(lineIdentifier)) {
                        emblRecord.setSequenceHeader(lineInfo);
                        continue;
                    }
                    if ("  ".equals(lineIdentifier) && !"//".equals(lineIdentifier)) {
                        EmblReader.populateSequence(line, sequence);
                        continue;
                    }
                    if (!"//".equals(lineIdentifier)) continue;
                    emblRecord.setKeyword(keyword);
                    emblRecord.setEmblReference(emblReferences);
                    emblRecord.setAccessionNumber(accessionNumber);
                    emblRecord.setSequence(sequence.toString());
                }
            }
        }
        return emblRecord;
    }

    private static void populateSequence(String line, StringBuilder sequence) {
        String sequenceLine = line.replace(" ", "").replaceAll("[0-9]", "");
        sequence.append(sequenceLine);
    }

    private static void populateEmblReferences(String lineIdentifier, String lineInfo, EmblReference emblReference, LinkedList<EmblReference> emblReferences) {
        if ("RN".equals(lineIdentifier)) {
            emblReference.setReferenceNumber(lineInfo);
        } else if ("RP".equals(lineIdentifier)) {
            emblReference.setReferencePosition(lineInfo);
        } else if ("RX".equals(lineIdentifier)) {
            emblReference.setReferenceCrossReference(lineInfo);
        } else if ("RG".equals(lineIdentifier)) {
            emblReference.setReferenceGroup(lineInfo);
        } else if ("RA".equals(lineIdentifier)) {
            emblReference.setReferenceAuthor(lineInfo);
        } else if ("RT".equals(lineIdentifier)) {
            emblReference.setReferenceTitle(lineInfo);
        } else if ("RL".equals(lineIdentifier)) {
            emblReference.setReferenceLocation(lineInfo);
            emblReferences.add(emblReference.copyEmblReference(emblReference));
        }
    }

    private static void populateAccessionNumber(String line, LinkedList<String> accessionNumber) {
        accessionNumber.add(line);
    }

    private static EmblId populateID(String line) {
        String[] strings = line.split(";");
        Arrays.stream(strings).map(String::trim).toArray(unused -> strings);
        EmblId emblId = new EmblId(strings[0], strings[1], strings[2], strings[3], strings[4], strings[5], strings[6]);
        return emblId;
    }
}

