/*
 * Copyright (c) 2010, Stanislav Muhametsin. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.sql.generation.api.common;

/**
 * Pretty much copy of org.qi4j.api.util.NullArgumentException.
 */
public class NullArgumentException extends RuntimeException
{
    private static final long serialVersionUID = 3342983960117811103L;

    private NullArgumentException( String message )
    {
        super( message );
    }

    /**
     * Validates that passed object is not null.
     * 
     * @param parameterName The name of the parameter.
     * @param object The parameter.
     * @throws NullArgumentException If {@code object} is {@code null}.
     */
    public static void validateNotNull( String parameterName, Object object )
    {
        if( object == null )
        {
            throw new NullArgumentException( parameterName + " was null." );
        }
    }
}
