/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.booleans;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.MultiPredicate;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.implementation.grammar.booleans.AbstractBooleanExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiPredicateImpl<ExpressionType extends MultiPredicate>
extends AbstractBooleanExpression<ExpressionType>
implements MultiPredicate {
    private final NonBooleanExpression _left;
    private final List<NonBooleanExpression> _rights;

    protected MultiPredicateImpl(Class<? extends ExpressionType> expressionClass, NonBooleanExpression left, NonBooleanExpression ... rights) {
        this(expressionClass, left, Arrays.asList(rights));
    }

    protected MultiPredicateImpl(Class<? extends ExpressionType> expressionClass, NonBooleanExpression left, List<NonBooleanExpression> rights) {
        super(expressionClass);
        NullArgumentException.validateNotNull((String)"left", (Object)left);
        NullArgumentException.validateNotNull((String)"rights", rights);
        for (NonBooleanExpression exp : rights) {
            NullArgumentException.validateNotNull((String)"right", (Object)exp);
        }
        this._left = left;
        this._rights = Collections.unmodifiableList(rights);
    }

    public NonBooleanExpression getLeft() {
        return this._left;
    }

    public List<NonBooleanExpression> getRights() {
        return this._rights;
    }

    protected boolean doesEqual(ExpressionType another) {
        return this._left.equals(another.getLeft()) && ((Object)this._rights).equals(another.getRights());
    }
}

