/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.builders.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.builders.query.ColumnsBuilder;
import org.sql.generation.api.grammar.common.SetQuantifier;
import org.sql.generation.api.grammar.query.ColumnReference;
import org.sql.generation.api.grammar.query.ColumnReferences;
import org.sql.generation.api.grammar.query.SelectColumnClause;
import org.sql.generation.implementation.grammar.query.AsteriskSelectImpl;
import org.sql.generation.implementation.grammar.query.ColumnReferencesImpl;
import org.sql.generation.implementation.grammar.query.SelectColumnClauseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsBuilderImpl
implements ColumnsBuilder {
    private final List<ColumnReferences.ColumnReferenceInfo> _columns;
    private SetQuantifier _quantifier;

    public ColumnsBuilderImpl(SetQuantifier setQuantifier) {
        NullArgumentException.validateNotNull((String)"set quantifier", (Object)setQuantifier);
        this._quantifier = setQuantifier;
        this._columns = new ArrayList<ColumnReferences.ColumnReferenceInfo>();
    }

    public ColumnsBuilder addUnnamedColumns(ColumnReference ... columns) {
        for (ColumnReference col : columns) {
            this.addNamedColumns(new ColumnReferences.ColumnReferenceInfo(null, col));
        }
        return this;
    }

    public ColumnsBuilder addNamedColumns(ColumnReferences.ColumnReferenceInfo ... namedColumns) {
        for (ColumnReferences.ColumnReferenceInfo info : namedColumns) {
            NullArgumentException.validateNotNull((String)"named column", (Object)info);
            this._columns.add(info);
        }
        return this;
    }

    public ColumnsBuilder setSetQuantifier(SetQuantifier newSetQuantifier) {
        NullArgumentException.validateNotNull((String)"new set quantifier", (Object)newSetQuantifier);
        this._quantifier = newSetQuantifier;
        return this;
    }

    public ColumnsBuilder selectAll() {
        this._columns.clear();
        return this;
    }

    public List<ColumnReferences.ColumnReferenceInfo> getColumns() {
        return Collections.unmodifiableList(this._columns);
    }

    public SetQuantifier getSetQuantifier() {
        return this._quantifier;
    }

    public SelectColumnClause createExpression() {
        SelectColumnClauseImpl result = null;
        result = this._columns.isEmpty() ? new AsteriskSelectImpl(this._quantifier) : new ColumnReferencesImpl(this._quantifier, this._columns);
        return result;
    }
}

