/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.builders.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.builders.query.QuerySpecificationBuilder;
import org.sql.generation.api.grammar.builders.query.SimpleQueryBuilder;
import org.sql.generation.api.grammar.builders.query.TableReferenceBuilder;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.common.ValueExpression;
import org.sql.generation.api.grammar.factories.ColumnsFactory;
import org.sql.generation.api.grammar.factories.QueryFactory;
import org.sql.generation.api.grammar.factories.TableReferenceFactory;
import org.sql.generation.api.grammar.query.ColumnReference;
import org.sql.generation.api.grammar.query.ColumnReferences;
import org.sql.generation.api.grammar.query.GroupingElement;
import org.sql.generation.api.grammar.query.Ordering;
import org.sql.generation.api.grammar.query.QueryExpression;
import org.sql.generation.api.grammar.query.QueryExpressionBody;
import org.sql.generation.api.grammar.query.SortSpecification;
import org.sql.generation.api.grammar.query.TableReferencePrimary;
import org.sql.generation.api.vendor.SQLVendor;

public class SimpleQueryBuilderImpl
implements SimpleQueryBuilder {
    private final List<String> _columns;
    private final Map<Integer, String> _columnAliases;
    private final List<TableName> _from;
    private BooleanExpression _where;
    private final List<String> _groupBy;
    private BooleanExpression _having;
    private final List<String> _orderBy;
    private final List<Ordering> _orderings;
    private final SQLVendor _vendor;

    public SimpleQueryBuilderImpl(SQLVendor vendor) {
        NullArgumentException.validateNotNull((String)"Vendor", (Object)vendor);
        this._vendor = vendor;
        this._columns = new ArrayList<String>();
        this._columnAliases = new HashMap<Integer, String>();
        this._from = new ArrayList<TableName>();
        this._groupBy = new ArrayList<String>();
        this._orderBy = new ArrayList<String>();
        this._orderings = new ArrayList<Ordering>();
    }

    public QueryExpression createExpression() {
        QueryFactory q = this._vendor.getQueryFactory();
        QuerySpecificationBuilder builda = q.querySpecificationBuilder();
        this.processQuerySpecBuilder(builda);
        return q.createQuery((QueryExpressionBody)builda.createExpression());
    }

    protected void processQuerySpecBuilder(QuerySpecificationBuilder builda) {
        QueryFactory q = this._vendor.getQueryFactory();
        ColumnsFactory c = this._vendor.getColumnsFactory();
        TableReferenceFactory t = this._vendor.getTableReferenceFactory();
        Integer colIndex = 0;
        while (colIndex < this._columnAliases.size()) {
            String colName = this._columns.get(colIndex);
            String alias = this._columnAliases.get(colIndex);
            builda.getSelect().addNamedColumns(new ColumnReferences.ColumnReferenceInfo[]{new ColumnReferences.ColumnReferenceInfo(alias, (ColumnReference)c.colName(colName))});
            colIndex = colIndex + 1;
        }
        for (TableName tableName : this._from) {
            builda.getFrom().addTableReferences(new TableReferenceBuilder[]{t.tableBuilder((TableReferencePrimary)t.table(tableName))});
        }
        builda.getWhere().reset(this._where);
        for (String groupBy : this._groupBy) {
            builda.getGroupBy().addGroupingElements(new GroupingElement[]{q.groupingElement(new NonBooleanExpression[]{c.colName(groupBy)})});
        }
        builda.getHaving().reset(this._having);
        Integer orderByIndex = 0;
        while (orderByIndex < this._orderBy.size()) {
            builda.getOrderBy().addSortSpecs(new SortSpecification[]{q.sortSpec((ValueExpression)c.colName(this._orderBy.get(orderByIndex)), this._orderings.get(orderByIndex))});
            orderByIndex = orderByIndex + 1;
        }
    }

    protected SQLVendor getVendor() {
        return this._vendor;
    }

    public SimpleQueryBuilder select(String ... columnNames) {
        for (String col : columnNames) {
            this._columns.add(col);
        }
        return this;
    }

    public SimpleQueryBuilder as(String columnAlias) {
        this._columnAliases.put(this._columns.size() - 1, columnAlias);
        return this;
    }

    public SimpleQueryBuilder from(TableName ... tableNames) {
        for (TableName table : tableNames) {
            this._from.add(table);
        }
        return this;
    }

    public SimpleQueryBuilder where(BooleanExpression searchCondition) {
        this._where = searchCondition;
        return this;
    }

    public SimpleQueryBuilder groupBy(String ... columns) {
        for (String col : columns) {
            this._groupBy.add(col);
        }
        return this;
    }

    public SimpleQueryBuilder having(BooleanExpression groupingCondition) {
        this._having = groupingCondition;
        return this;
    }

    public SimpleQueryBuilder orderByAsc(String ... columns) {
        for (String col : columns) {
            this._orderBy.add(col);
            this._orderings.add(Ordering.ASCENDING);
        }
        return this;
    }

    public SimpleQueryBuilder orderByDesc(String ... columns) {
        for (String col : columns) {
            this._orderBy.add(col);
            this._orderings.add(Ordering.DESCENDING);
        }
        return this;
    }
}

