/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.definition.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.atp.spi.TypeableImpl;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.common.SchemaStatement;
import org.sql.generation.api.grammar.definition.schema.SchemaDefinition;
import org.sql.generation.api.grammar.definition.schema.SchemaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaDefinitionImpl
extends TypeableImpl<SchemaStatement, SchemaDefinition>
implements SchemaDefinition {
    private final String _charset;
    private final String _name;
    private final List<SchemaElement> _elements;

    public SchemaDefinitionImpl(String name, String charset, List<SchemaElement> elements) {
        this(SchemaDefinition.class, name, charset, elements);
    }

    protected SchemaDefinitionImpl(Class<? extends SchemaDefinition> realImplementingType, String name, String charset, List<SchemaElement> elements) {
        super(realImplementingType);
        NullArgumentException.validateNotNull((String)"Schema name", (Object)name);
        NullArgumentException.validateNotNull((String)"Elements", elements);
        this._name = name;
        this._charset = charset;
        this._elements = Collections.unmodifiableList(new ArrayList<SchemaElement>(elements));
    }

    protected boolean doesEqual(SchemaDefinition another) {
        return this._name.equals(another.getSchemaName()) && ((Object)this._elements).equals(another.getSchemaElements()) && TypeableImpl.bothNullOrEquals((Object)this._charset, (Object)another.getSchemaCharset());
    }

    public String getSchemaCharset() {
        return this._charset;
    }

    public List<SchemaElement> getSchemaElements() {
        return this._elements;
    }

    public String getSchemaName() {
        return this._name;
    }
}

