/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.definition.view;

import org.atp.api.Typeable;
import org.atp.spi.TypeableImpl;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.common.SchemaStatement;
import org.sql.generation.api.grammar.common.TableName;
import org.sql.generation.api.grammar.definition.view.ViewCheckOption;
import org.sql.generation.api.grammar.definition.view.ViewDefinition;
import org.sql.generation.api.grammar.definition.view.ViewSpecification;
import org.sql.generation.api.grammar.query.QueryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDefinitionImpl
extends TypeableImpl<SchemaStatement, ViewDefinition>
implements ViewDefinition {
    private final TableName _name;
    private final QueryExpression _query;
    private final ViewSpecification _spec;
    private final ViewCheckOption _viewCheck;
    private final Boolean _isRecursive;

    public ViewDefinitionImpl(TableName name, QueryExpression query, ViewSpecification spec, ViewCheckOption viewCheck, Boolean isRecursive) {
        this(ViewDefinition.class, name, query, spec, viewCheck, isRecursive);
    }

    protected ViewDefinitionImpl(Class<? extends ViewDefinition> realImplementingType, TableName name, QueryExpression query, ViewSpecification spec, ViewCheckOption viewCheck, Boolean isRecursive) {
        super(realImplementingType);
        NullArgumentException.validateNotNull((String)"View name", (Object)name);
        NullArgumentException.validateNotNull((String)"View query", (Object)query);
        NullArgumentException.validateNotNull((String)"Is recursive", (Object)isRecursive);
        NullArgumentException.validateNotNull((String)"View specification", (Object)spec);
        this._name = name;
        this._query = query;
        this._spec = spec;
        this._isRecursive = isRecursive;
        this._viewCheck = viewCheck;
    }

    protected boolean doesEqual(ViewDefinition another) {
        return this._name.equals(another.getViewName()) && this._isRecursive.equals(another.isRecursive()) && this._spec.equals(another.getViewSpecification()) && this._query.equals(another.getViewQuery()) && TypeableImpl.bothNullOrEquals((Object)this._viewCheck, (Object)another.getViewCheckOption());
    }

    public Typeable<?> asTypeable() {
        return this;
    }

    public ViewCheckOption getViewCheckOption() {
        return this._viewCheck;
    }

    public TableName getViewName() {
        return this._name;
    }

    public QueryExpression getViewQuery() {
        return this._query;
    }

    public ViewSpecification getViewSpecification() {
        return this._spec;
    }

    public Boolean isRecursive() {
        return this._isRecursive;
    }
}

