/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.common.SetQuantifier;
import org.sql.generation.api.grammar.query.ColumnReferences;
import org.sql.generation.implementation.grammar.query.SelectColumnClauseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnReferencesImpl
extends SelectColumnClauseImpl<ColumnReferences>
implements ColumnReferences {
    private final List<ColumnReferences.ColumnReferenceInfo> _columns;

    public ColumnReferencesImpl(SetQuantifier quantifier, ColumnReferences.ColumnReferenceInfo ... columns) {
        this(quantifier, Arrays.asList(columns));
    }

    public ColumnReferencesImpl(SetQuantifier quantifier, List<ColumnReferences.ColumnReferenceInfo> columns) {
        this(ColumnReferences.class, quantifier, columns);
    }

    public ColumnReferencesImpl(Class<? extends ColumnReferences> type, SetQuantifier quantifier, List<ColumnReferences.ColumnReferenceInfo> columns) {
        super(type, quantifier);
        NullArgumentException.validateNotNull((String)"columns", columns);
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one column in column list.");
        }
        for (ColumnReferences.ColumnReferenceInfo column : columns) {
            NullArgumentException.validateNotNull((String)"column", (Object)column);
        }
        this._columns = Collections.unmodifiableList(columns);
    }

    public List<ColumnReferences.ColumnReferenceInfo> getColumns() {
        return this._columns;
    }

    @Override
    protected boolean doesEqual(ColumnReferences another) {
        return super.doesEqual(another) && ((Object)this._columns).equals(another.getColumns());
    }
}

