/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import java.util.Iterator;
import org.atp.api.Typeable;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BinaryPredicate;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.booleans.BooleanTest;
import org.sql.generation.api.grammar.booleans.Conjunction;
import org.sql.generation.api.grammar.booleans.Disjunction;
import org.sql.generation.api.grammar.booleans.MultiPredicate;
import org.sql.generation.api.grammar.booleans.Negation;
import org.sql.generation.api.grammar.booleans.UnaryPredicate;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.api.grammar.query.QueryExpression;
import org.sql.generation.implementation.grammar.booleans.BooleanUtils;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class BooleanExpressionProcessing {
    public static void processBinaryComposedObject(SQLProcessorAggregator aggregator, BooleanExpression left, BooleanExpression right, StringBuilder builder, String operator) {
        Boolean leftEmpty = BooleanUtils.isEmpty(left);
        Boolean rightEmpty = BooleanUtils.isEmpty(right);
        if (!leftEmpty.booleanValue() || !rightEmpty.booleanValue()) {
            Boolean oneEmpty = leftEmpty != false || rightEmpty != false;
            if (!oneEmpty.booleanValue()) {
                builder.append("(");
            }
            aggregator.process((Typeable<?>)left, builder);
            if (!oneEmpty.booleanValue()) {
                if (!leftEmpty.booleanValue()) {
                    builder.append(" ");
                }
                builder.append(operator);
                if (!rightEmpty.booleanValue()) {
                    builder.append(" ");
                }
            }
            aggregator.process((Typeable<?>)right, builder);
            if (!oneEmpty.booleanValue()) {
                builder.append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanTestProcessor
    extends AbstractProcessor<BooleanTest> {
        public BooleanTestProcessor() {
            super(BooleanTest.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, BooleanTest object, StringBuilder builder) {
            BooleanExpression testable = object.getBooleanExpression();
            builder.append("(");
            aggregator.process((Typeable<?>)testable, builder);
            builder.append(")").append("IS").append(" ");
            if (object.getTestType() == BooleanTest.TestType.IS_NOT) {
                builder.append("NOT").append(" ");
            }
            builder.append(object.getTruthValue().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisjunctionProcessor
    extends AbstractProcessor<Disjunction> {
        public DisjunctionProcessor() {
            super(Disjunction.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, Disjunction object, StringBuilder builder) {
            BooleanExpressionProcessing.processBinaryComposedObject(aggregator, object.getLeft(), object.getRight(), builder, "OR");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConjunctionProcessor
    extends AbstractProcessor<Conjunction> {
        public ConjunctionProcessor() {
            super(Conjunction.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, Conjunction object, StringBuilder builder) {
            BooleanExpressionProcessing.processBinaryComposedObject(aggregator, object.getLeft(), object.getRight(), builder, "AND");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NegationProcessor
    extends AbstractProcessor<Negation> {
        public NegationProcessor() {
            super(Negation.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, Negation object, StringBuilder builder) {
            BooleanExpression negated = object.getNegated();
            if (!BooleanUtils.isEmpty(negated).booleanValue()) {
                builder.append("NOT").append(" ");
                aggregator.process((Typeable<?>)negated, builder);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiPredicateProcessor
    extends AbstractProcessor<MultiPredicate> {
        private final String _operator;
        private final String _separator;
        private final Boolean _needParenthesis;

        public MultiPredicateProcessor(String multiOperator, String multiSeparator, Boolean needParenthesis) {
            super(MultiPredicate.class);
            NullArgumentException.validateNotNull((String)"multi-operator", (Object)multiOperator);
            NullArgumentException.validateNotNull((String)"multi separator", (Object)multiSeparator);
            NullArgumentException.validateNotNull((String)"need parenthesis", (Object)needParenthesis);
            this._operator = multiOperator;
            this._separator = multiSeparator;
            this._needParenthesis = needParenthesis;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, MultiPredicate predicate, StringBuilder builder) {
            processor.process((Typeable<?>)predicate.getLeft(), builder);
            builder.append(" ").append(this._operator).append(" ");
            if (this._needParenthesis.booleanValue()) {
                builder.append("(");
            }
            Iterator iter = predicate.getRights().iterator();
            while (iter.hasNext()) {
                NonBooleanExpression next = (NonBooleanExpression)iter.next();
                Boolean isQuery = next instanceof QueryExpression;
                if (isQuery.booleanValue()) {
                    builder.append("(");
                }
                processor.process((Typeable<?>)next, builder);
                if (isQuery.booleanValue()) {
                    builder.append(")");
                }
                if (!iter.hasNext()) continue;
                builder.append(this._separator);
            }
            if (this._needParenthesis.booleanValue()) {
                builder.append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BinaryPredicateProcessor
    extends AbstractProcessor<BinaryPredicate> {
        private final String _operator;

        public BinaryPredicateProcessor(String binaryOperator) {
            super(BinaryPredicate.class);
            NullArgumentException.validateNotNull((String)"binary operator", (Object)binaryOperator);
            this._operator = binaryOperator;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, BinaryPredicate predicate, StringBuilder builder) {
            processor.process((Typeable<?>)predicate.getLeft(), builder);
            builder.append(" ").append(this._operator).append(" ");
            processor.process((Typeable<?>)predicate.getRight(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnaryPredicateProcessor
    extends AbstractProcessor<UnaryPredicate> {
        public static final UnaryOperatorOrientation DEFAULT_ORIENTATION = UnaryOperatorOrientation.AFTER_EXPRESSION;
        private final UnaryOperatorOrientation _orientation;
        private final String _operator;

        public UnaryPredicateProcessor(String operator) {
            this(DEFAULT_ORIENTATION, operator);
        }

        public UnaryPredicateProcessor(UnaryOperatorOrientation unaryOrientation, String unaryOperator) {
            super(UnaryPredicate.class);
            NullArgumentException.validateNotNull((String)"unary operator orientation", (Object)((Object)unaryOrientation));
            NullArgumentException.validateNotNull((String)"unary operator", (Object)unaryOperator);
            this._orientation = unaryOrientation;
            this._operator = unaryOperator;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, UnaryPredicate predicate, StringBuilder builder) {
            NonBooleanExpression exp;
            Boolean isQuery;
            UnaryOperatorOrientation orientation = this._orientation;
            if (orientation == UnaryOperatorOrientation.BEFORE_EXPRESSION) {
                builder.append(this._operator).append(" ");
            }
            if ((isQuery = Boolean.valueOf((exp = predicate.getValueExpression()) instanceof QueryExpression)).booleanValue()) {
                builder.append("(");
            }
            processor.process((Typeable<?>)exp, builder);
            if (isQuery.booleanValue()) {
                builder.append(")");
            }
            if (orientation == UnaryOperatorOrientation.AFTER_EXPRESSION) {
                builder.append(" ").append(this._operator);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum UnaryOperatorOrientation {
            BEFORE_EXPRESSION,
            AFTER_EXPRESSION;

        }
    }
}

