/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation.pgsql;

import java.util.Map;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.definition.table.AutoGenerationPolicy;
import org.sql.generation.api.grammar.definition.table.ColumnDefinition;
import org.sql.generation.implementation.transformation.DefinitionProcessing;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class DefinitionProcessing {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PGColumnDefinitionProcessor
    extends DefinitionProcessing.ColumnDefinitionProcessor {
        private final Map<Class<?>, String> _dataTypeSerialNames;

        public PGColumnDefinitionProcessor(Map<Class<?>, String> dataTypeSerialNames) {
            NullArgumentException.validateNotNull((String)"Data type serial names", dataTypeSerialNames);
            this._dataTypeSerialNames = dataTypeSerialNames;
        }

        @Override
        protected void processDataType(SQLProcessorAggregator aggregator, ColumnDefinition object, StringBuilder builder) {
            AutoGenerationPolicy autoGenPolicy = object.getAutoGenerationPolicy();
            if (autoGenPolicy == null) {
                super.processDataType(aggregator, object, builder);
            } else if (AutoGenerationPolicy.BY_DEFAULT.equals(autoGenPolicy)) {
                Class<?> dtClass = object.getDataType().getClass();
                Boolean success = false;
                for (Map.Entry<Class<?>, String> entry : this._dataTypeSerialNames.entrySet()) {
                    success = entry.getKey().isAssignableFrom(dtClass);
                    if (!success.booleanValue()) continue;
                    builder.append(entry.getValue());
                    break;
                }
                if (!success.booleanValue()) {
                    throw new UnsupportedOperationException("Unsupported column data type " + object.getDataType() + " for auto-generated column.");
                }
            } else {
                throw new UnsupportedOperationException("Unsupported auto generation policy: " + autoGenPolicy + ".");
            }
        }

        @Override
        protected void processAutoGenerationPolicy(ColumnDefinition object, StringBuilder builder) {
        }
    }
}

