/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import com.carrotsearch.junitbenchmarks.ConsumerName;
import com.carrotsearch.junitbenchmarks.IResultsConsumer;
import java.util.ArrayList;

public final class BenchmarkOptionsSystemProperties {
    public static final String WARMUP_ROUNDS_PROPERTY = "jub.rounds.warmup";
    public static final String BENCHMARK_ROUNDS_PROPERTY = "jub.rounds.benchmark";
    public static final String CONCURRENCY_PROPERTY = "jub.concurrency";
    public static final String IGNORE_ANNOTATION_OPTIONS_PROPERTY = "jub.ignore.annotations";
    public static final String IGNORE_CALLGC_PROPERTY = "jub.ignore.callgc";
    public static final String XML_FILE_PROPERTY = "jub.xml.file";
    public static final String DB_FILE_PROPERTY = "jub.db.file";
    public static final String MYSQL_URL_PROPERTY = "jub.mysql.url";
    public static final String CHARTS_DIR_PROPERTY = "jub.charts.dir";
    public static final String CUSTOMKEY_PROPERTY = "jub.customkey";
    public static final String CONSUMERS_PROPERTY = "jub.consumers";
    static IResultsConsumer[] consumers;

    public static synchronized IResultsConsumer[] getDefaultConsumers() {
        if (consumers == null) {
            consumers = BenchmarkOptionsSystemProperties.initializeDefault();
        }
        return consumers;
    }

    private static IResultsConsumer[] initializeDefault() {
        if (consumers != null) {
            throw new RuntimeException("Consumers list already initialized.");
        }
        String[] consumers = System.getProperty(CONSUMERS_PROPERTY, ConsumerName.CONSOLE.toString()).split("\\s*[,]\\s*");
        ArrayList<IResultsConsumer> result = new ArrayList<IResultsConsumer>();
        for (String consumerName : consumers) {
            ConsumerName c = ConsumerName.valueOf(consumerName.toUpperCase());
            try {
                result.add(c.clazz.newInstance());
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return result.toArray(new IResultsConsumer[result.size()]);
    }
}

