/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.io.URILocation;

public class URILocationTest {
    @Test
    public void testURI() throws URISyntaxException {
        String uriString = "scheme://bob@big.server.somewhere:12345/foo/bar?pineapple=exquisite&strawberries=very%20delicious#anchor";
        URI uri = new URI("scheme://bob@big.server.somewhere:12345/foo/bar?pineapple=exquisite&strawberries=very%20delicious#anchor");
        URILocation loc = new URILocation(uri);
        Assert.assertSame((Object)uri, (Object)loc.getURI());
        Map queryMap = loc.getQueryMap();
        Assert.assertEquals((long)2L, (long)queryMap.size());
        Assert.assertEquals((Object)"exquisite", queryMap.get("pineapple"));
        Assert.assertEquals((Object)"very delicious", queryMap.get("strawberries"));
    }
}

