/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep.eval;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.sjep.AbstractTest;
import org.scijava.sjep.Variable;
import org.scijava.sjep.eval.DefaultEvaluator;

public class DefaultEvaluatorTest
extends AbstractTest {
    private DefaultEvaluator e;

    @Before
    public void setUp() {
        this.e = new DefaultEvaluator();
    }

    @Test
    public void testDot() {
        Assert.assertNull((Object)this.e.dot(this.o(0), this.o(1)));
    }

    @Test
    public void testTranspose() {
        Assert.assertNull((Object)this.e.transpose(this.o(0)));
    }

    @Test
    public void testDotTranspose() {
        Assert.assertNull((Object)this.e.dotTranspose(this.o(0)));
    }

    @Test
    public void testPow() {
        this.assertNumber(15.625, this.e.pow(this.o(2.5), this.o(3.0)));
        this.assertNumber(this.bi(15625), this.e.pow(this.o(this.bi(5)), this.o(6)));
        this.assertNumber(this.bd(15.625), this.e.pow(this.o(this.bd(2.5)), this.o(3)));
    }

    @Test
    public void testDotPow() {
        Assert.assertNull((Object)this.e.dotPow(this.o(0), this.o(0)));
    }

    @Test
    public void testPostInc() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)2);
        Assert.assertEquals((Object)2, (Object)this.e.postInc((Object)v));
        Assert.assertEquals((Object)3, (Object)this.e.get(v));
        this.e.set(v, (Object)4L);
        Assert.assertEquals((Object)4L, (Object)this.e.postInc((Object)v));
        Assert.assertEquals((Object)5L, (Object)this.e.get(v));
        this.e.set(v, (Object)Float.valueOf(6.0f));
        Assert.assertEquals((Object)Float.valueOf(6.0f), (Object)this.e.postInc((Object)v));
        Assert.assertEquals((Object)Float.valueOf(7.0f), (Object)this.e.get(v));
        this.e.set(v, (Object)8.0);
        Assert.assertEquals((Object)8.0, (Object)this.e.postInc((Object)v));
        Assert.assertEquals((Object)9.0, (Object)this.e.get(v));
        this.e.set(v, (Object)this.bi(10));
        Assert.assertEquals((Object)this.bi(10), (Object)this.e.postInc((Object)v));
        Assert.assertEquals((Object)this.bi(11), (Object)this.e.get(v));
        this.e.set(v, (Object)this.bd(12));
        Assert.assertEquals((Object)this.bd(12), (Object)this.e.postInc((Object)v));
        Assert.assertEquals((Object)this.bd(13), (Object)this.e.get(v));
    }

    @Test
    public void testPostDec() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)2);
        Assert.assertEquals((Object)2, (Object)this.e.postDec((Object)v));
        Assert.assertEquals((Object)1, (Object)this.e.get(v));
        this.e.set(v, (Object)4L);
        Assert.assertEquals((Object)4L, (Object)this.e.postDec((Object)v));
        Assert.assertEquals((Object)3L, (Object)this.e.get(v));
        this.e.set(v, (Object)Float.valueOf(6.0f));
        Assert.assertEquals((Object)Float.valueOf(6.0f), (Object)this.e.postDec((Object)v));
        Assert.assertEquals((Object)Float.valueOf(5.0f), (Object)this.e.get(v));
        this.e.set(v, (Object)8.0);
        Assert.assertEquals((Object)8.0, (Object)this.e.postDec((Object)v));
        Assert.assertEquals((Object)7.0, (Object)this.e.get(v));
        this.e.set(v, (Object)this.bi(10));
        Assert.assertEquals((Object)this.bi(10), (Object)this.e.postDec((Object)v));
        Assert.assertEquals((Object)this.bi(9), (Object)this.e.get(v));
        this.e.set(v, (Object)this.bd(12));
        Assert.assertEquals((Object)this.bd(12), (Object)this.e.postDec((Object)v));
        Assert.assertEquals((Object)this.bd(11), (Object)this.e.get(v));
    }

    @Test
    public void testPreInc() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)2);
        Assert.assertEquals((Object)3, (Object)this.e.preInc((Object)v));
        Assert.assertEquals((Object)3, (Object)this.e.get(v));
        this.e.set(v, (Object)4L);
        Assert.assertEquals((Object)5L, (Object)this.e.preInc((Object)v));
        Assert.assertEquals((Object)5L, (Object)this.e.get(v));
        this.e.set(v, (Object)Float.valueOf(6.0f));
        Assert.assertEquals((Object)Float.valueOf(7.0f), (Object)this.e.preInc((Object)v));
        Assert.assertEquals((Object)Float.valueOf(7.0f), (Object)this.e.get(v));
        this.e.set(v, (Object)8.0);
        Assert.assertEquals((Object)9.0, (Object)this.e.preInc((Object)v));
        Assert.assertEquals((Object)9.0, (Object)this.e.get(v));
        this.e.set(v, (Object)this.bi(10));
        Assert.assertEquals((Object)this.bi(11), (Object)this.e.preInc((Object)v));
        Assert.assertEquals((Object)this.bi(11), (Object)this.e.get(v));
        this.e.set(v, (Object)this.bd(12));
        Assert.assertEquals((Object)this.bd(13), (Object)this.e.preInc((Object)v));
        Assert.assertEquals((Object)this.bd(13), (Object)this.e.get(v));
    }

    @Test
    public void testPreDec() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)2);
        Assert.assertEquals((Object)1, (Object)this.e.preDec((Object)v));
        Assert.assertEquals((Object)1, (Object)this.e.get(v));
        this.e.set(v, (Object)4L);
        Assert.assertEquals((Object)3L, (Object)this.e.preDec((Object)v));
        Assert.assertEquals((Object)3L, (Object)this.e.get(v));
        this.e.set(v, (Object)Float.valueOf(6.0f));
        Assert.assertEquals((Object)Float.valueOf(5.0f), (Object)this.e.preDec((Object)v));
        Assert.assertEquals((Object)Float.valueOf(5.0f), (Object)this.e.get(v));
        this.e.set(v, (Object)8.0);
        Assert.assertEquals((Object)7.0, (Object)this.e.preDec((Object)v));
        Assert.assertEquals((Object)7.0, (Object)this.e.get(v));
        this.e.set(v, (Object)this.bi(10));
        Assert.assertEquals((Object)this.bi(9), (Object)this.e.preDec((Object)v));
        Assert.assertEquals((Object)this.bi(9), (Object)this.e.get(v));
        this.e.set(v, (Object)this.bd(12));
        Assert.assertEquals((Object)this.bd(11), (Object)this.e.preDec((Object)v));
        Assert.assertEquals((Object)this.bd(11), (Object)this.e.get(v));
    }

    @Test
    public void testPos() {
        this.assertNumber(7, this.e.pos(this.o(7)));
        this.assertNumber(7L, this.e.pos(this.o(7L)));
        this.assertNumber(7.8, this.e.pos(this.o(7.8)));
        this.assertNumber(Float.valueOf(7.8f), this.e.pos(this.o(Float.valueOf(7.8f))));
        Assert.assertSame((Object)BigInteger.ZERO, (Object)this.e.pos((Object)BigInteger.ZERO));
        Assert.assertSame((Object)BigInteger.ONE, (Object)this.e.pos((Object)BigInteger.ONE));
        Assert.assertSame((Object)BigInteger.TEN, (Object)this.e.pos((Object)BigInteger.TEN));
        Assert.assertSame((Object)BigDecimal.ZERO, (Object)this.e.pos((Object)BigDecimal.ZERO));
        Assert.assertSame((Object)BigDecimal.ONE, (Object)this.e.pos((Object)BigDecimal.ONE));
        Assert.assertSame((Object)BigDecimal.TEN, (Object)this.e.pos((Object)BigDecimal.TEN));
    }

    @Test
    public void testNeg() {
        this.assertNumber(7, this.e.neg(this.o(-7)));
        this.assertNumber(7L, this.e.neg(this.o(-7L)));
        this.assertNumber(Float.valueOf(7.8f), this.e.neg(this.o(Float.valueOf(-7.8f))));
        this.assertNumber(7.8, this.e.neg(this.o(-7.8)));
        this.assertNumber(this.bi(7), this.e.neg(this.o(this.bi(-7))));
        this.assertNumber(this.bd(7.8), this.e.neg(this.o(this.bd(-7.8))));
        this.assertNumber(-7, this.e.neg(this.o(7)));
        this.assertNumber(-7L, this.e.neg(this.o(7L)));
        this.assertNumber(Float.valueOf(-7.8f), this.e.neg(this.o(Float.valueOf(7.8f))));
        this.assertNumber(-7.8, this.e.neg(this.o(7.8)));
        this.assertNumber(this.bi(-7), this.e.neg(this.o(this.bi(7))));
        this.assertNumber(this.bd(-7.8), this.e.neg(this.o(this.bd(7.8))));
    }

    @Test
    public void testComplement() {
        this.assertNumber(889275713, this.e.complement(this.o(-889275714)));
        this.assertNumber(2401039830844720449L, this.e.complement(this.o(-2401039830844720450L)));
    }

    @Test
    public void testNot() {
        Assert.assertSame((Object)false, (Object)this.e.not(this.o(true)));
        Assert.assertSame((Object)true, (Object)this.e.not(this.o(false)));
    }

    @Test
    public void testMul() {
        this.assertNumber(24, this.e.mul(this.o(4), this.o(6)));
        this.assertNumber(24L, this.e.mul(this.o(4L), this.o(6L)));
        this.assertNumber(Float.valueOf(8.75f), this.e.mul(this.o(Float.valueOf(2.5f)), this.o(Float.valueOf(3.5f))));
        this.assertNumber(8.75, this.e.mul(this.o(2.5), this.o(3.5)));
        this.assertNumber(this.bi(24), this.e.mul(this.o(this.bi(4)), this.o(this.bi(6))));
        this.assertNumber(this.bd(8.75), this.e.mul(this.o(this.bd(2.5)), this.o(this.bd(3.5))));
    }

    @Test
    public void testDiv() {
        this.assertNumber(4, this.e.div(this.o(27), this.o(6)));
        this.assertNumber(4L, this.e.div(this.o(27L), this.o(6L)));
        this.assertNumber(Float.valueOf(2.5f), this.e.div(this.o(Float.valueOf(8.75f)), this.o(Float.valueOf(3.5f))));
        this.assertNumber(2.5, this.e.div(this.o(8.75), this.o(3.5)));
        this.assertNumber(this.bi(4), this.e.div(this.o(this.bi(27)), this.o(this.bi(6))));
        this.assertNumber(this.bd(2.5), this.e.div(this.o(this.bd(8.75)), this.o(this.bd(3.5))));
    }

    @Test
    public void testMod() {
        this.assertNumber(3, this.e.mod(this.o(27), this.o(6)));
        this.assertNumber(3L, this.e.mod(this.o(27L), this.o(6L)));
        this.assertNumber(Float.valueOf(1.75f), this.e.mod(this.o(Float.valueOf(8.75f)), this.o(Float.valueOf(3.5f))));
        this.assertNumber(1.75, this.e.mod(this.o(8.75), this.o(3.5)));
        this.assertNumber(this.bi(3), this.e.mod(this.o(this.bi(27)), this.o(this.bi(6))));
        this.assertNumber(this.bd(1.75), this.e.mod(this.o(this.bd(8.75)), this.o(this.bd(3.5))));
    }

    @Test
    public void testRightDiv() {
        Assert.assertNull((Object)this.e.rightDiv(this.o(0), this.o(0)));
    }

    @Test
    public void testDotDiv() {
        Assert.assertNull((Object)this.e.dotDiv(this.o(0), this.o(0)));
    }

    @Test
    public void testDotRightDiv() {
        Assert.assertNull((Object)this.e.dotRightDiv(this.o(0), this.o(0)));
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((Object)"Hello, world", (Object)this.e.add(this.o("Hello,"), this.o(" world")));
        this.assertNumber(10, this.e.add(this.o(4), this.o(6)));
        this.assertNumber(10L, this.e.add(this.o(4L), this.o(6L)));
        this.assertNumber(Float.valueOf(3.6f), this.e.add(this.o(Float.valueOf(1.5f)), this.o(Float.valueOf(2.1f))));
        this.assertNumber(3.6, this.e.add(this.o(1.5), this.o(2.1)));
        this.assertNumber(this.bi(10), this.e.add(this.o(this.bi(4)), this.o(this.bi(6))));
        this.assertNumber(this.bd(3.6), this.e.add(this.o(this.bd(1.5)), this.o(this.bd(2.1))));
    }

    @Test
    public void testSub() {
        this.assertNumber(4, this.e.sub(this.o(10), this.o(6)));
        this.assertNumber(4L, this.e.sub(this.o(10L), this.o(6L)));
        this.assertNumber(Float.valueOf(1.5f), this.e.sub(this.o(Float.valueOf(3.6f)), this.o(Float.valueOf(2.1f))));
        this.assertNumber(1.5, this.e.sub(this.o(3.6), this.o(2.1)));
        this.assertNumber(this.bi(4), this.e.sub(this.o(this.bi(10)), this.o(this.bi(6))));
        this.assertNumber(this.bd(1.5), this.e.sub(this.o(this.bd(3.6)), this.o(this.bd(2.1))));
    }

    @Test
    public void testLeftShift() {
        this.assertNumber(-1343509536, this.e.leftShift(this.o(-889275714), this.o(4)));
        this.assertNumber(-2544555852783951872L, this.e.leftShift(this.o(-2401039830844720450L), this.o(12)));
        this.assertNumber(this.bi(7296), this.e.leftShift(this.o(this.bi(57)), this.o(7)));
    }

    @Test
    public void testRightShift() {
        this.assertNumber(-55579733, this.e.rightShift(this.o(-889275714), this.o(4)));
        this.assertNumber(-586191364952325L, this.e.rightShift(this.o(-2401039830844720450L), this.o(12)));
        this.assertNumber(this.bi(278), this.e.rightShift(this.o(this.bi(8920)), this.o(5)));
    }

    @Test
    public void testUnsignedRightShift() {
        this.assertNumber(212855723, this.e.unsignedRightShift(this.o(-889275714), this.o(4)));
        this.assertNumber(3917408262418171L, this.e.unsignedRightShift(this.o(-2401039830844720450L), this.o(12)));
    }

    @Test
    public void testColon() {
        Assert.assertNull((Object)this.e.colon(this.o(0), this.o(0)));
    }

    @Test
    public void testLessThan() {
        Assert.assertSame((Object)true, (Object)this.e.lessThan(this.o(false), this.o(true)));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(false), this.o(false)));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(true), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.lessThan(this.o("hello"), this.o("world")));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o("hello"), this.o("hello")));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o("young"), this.o("world")));
        Assert.assertSame((Object)true, (Object)this.e.lessThan(this.o(2), this.o(3)));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(2), this.o(2)));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(2), this.o(1)));
        Assert.assertSame((Object)true, (Object)this.e.lessThan(this.o(5L), this.o(6L)));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(5L), this.o(5L)));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(5L), this.o(4L)));
        Assert.assertSame((Object)true, (Object)this.e.lessThan(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(9.0f))));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(8.0f))));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(7.0f))));
        Assert.assertSame((Object)true, (Object)this.e.lessThan(this.o(11.0), this.o(12.0)));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(11.0), this.o(11.0)));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(11.0), this.o(10.0)));
        Assert.assertSame((Object)true, (Object)this.e.lessThan(this.o(this.bi(14)), this.o(this.bi(15))));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(this.bi(14)), this.o(this.bi(14))));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(this.bi(14)), this.o(this.bi(13))));
        Assert.assertSame((Object)true, (Object)this.e.lessThan(this.o(this.bd(17)), this.o(this.bd(18))));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(this.bd(17)), this.o(this.bd(17))));
        Assert.assertSame((Object)false, (Object)this.e.lessThan(this.o(this.bd(17)), this.o(this.bd(16))));
    }

    @Test
    public void testGreaterThan() {
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(false), this.o(true)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(false), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThan(this.o(true), this.o(false)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o("hello"), this.o("world")));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o("hello"), this.o("hello")));
        Assert.assertSame((Object)true, (Object)this.e.greaterThan(this.o("young"), this.o("world")));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(2), this.o(3)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(2), this.o(2)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThan(this.o(2), this.o(1)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(5L), this.o(6L)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(5L), this.o(5L)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThan(this.o(5L), this.o(4L)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(9.0f))));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(8.0f))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThan(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(7.0f))));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(11.0), this.o(12.0)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(11.0), this.o(11.0)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThan(this.o(11.0), this.o(10.0)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(this.bi(14)), this.o(this.bi(15))));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(this.bi(14)), this.o(this.bi(14))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThan(this.o(this.bi(14)), this.o(this.bi(13))));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(this.bd(17)), this.o(this.bd(18))));
        Assert.assertSame((Object)false, (Object)this.e.greaterThan(this.o(this.bd(17)), this.o(this.bd(17))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThan(this.o(this.bd(17)), this.o(this.bd(16))));
    }

    @Test
    public void testLessThanOrEqual() {
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(false), this.o(true)));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(false), this.o(false)));
        Assert.assertSame((Object)false, (Object)this.e.lessThanOrEqual(this.o(true), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o("hello"), this.o("world")));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o("hello"), this.o("hello")));
        Assert.assertSame((Object)false, (Object)this.e.lessThanOrEqual(this.o("young"), this.o("world")));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(2), this.o(3)));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(2), this.o(2)));
        Assert.assertSame((Object)false, (Object)this.e.lessThanOrEqual(this.o(2), this.o(1)));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(5L), this.o(6L)));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(5L), this.o(5L)));
        Assert.assertSame((Object)false, (Object)this.e.lessThanOrEqual(this.o(5L), this.o(4L)));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(9.0f))));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(8.0f))));
        Assert.assertSame((Object)false, (Object)this.e.lessThanOrEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(7.0f))));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(11.0), this.o(12.0)));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(11.0), this.o(11.0)));
        Assert.assertSame((Object)false, (Object)this.e.lessThanOrEqual(this.o(11.0), this.o(10.0)));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(this.bi(14)), this.o(this.bi(15))));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(this.bi(14)), this.o(this.bi(14))));
        Assert.assertSame((Object)false, (Object)this.e.lessThanOrEqual(this.o(this.bi(14)), this.o(this.bi(13))));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(this.bd(17)), this.o(this.bd(18))));
        Assert.assertSame((Object)true, (Object)this.e.lessThanOrEqual(this.o(this.bd(17)), this.o(this.bd(17))));
        Assert.assertSame((Object)false, (Object)this.e.lessThanOrEqual(this.o(this.bd(17)), this.o(this.bd(16))));
    }

    @Test
    public void testGreaterThanOrEqual() {
        Assert.assertSame((Object)false, (Object)this.e.greaterThanOrEqual(this.o(false), this.o(true)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(false), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(true), this.o(false)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThanOrEqual(this.o("hello"), this.o("world")));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o("hello"), this.o("hello")));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o("young"), this.o("world")));
        Assert.assertSame((Object)false, (Object)this.e.greaterThanOrEqual(this.o(2), this.o(3)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(2), this.o(2)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(2), this.o(1)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThanOrEqual(this.o(5L), this.o(6L)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(5L), this.o(5L)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(5L), this.o(4L)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThanOrEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(9.0f))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(8.0f))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(7.0f))));
        Assert.assertSame((Object)false, (Object)this.e.greaterThanOrEqual(this.o(11.0), this.o(12.0)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(11.0), this.o(11.0)));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(11.0), this.o(10.0)));
        Assert.assertSame((Object)false, (Object)this.e.greaterThanOrEqual(this.o(this.bi(14)), this.o(this.bi(15))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(this.bi(14)), this.o(this.bi(14))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(this.bi(14)), this.o(this.bi(13))));
        Assert.assertSame((Object)false, (Object)this.e.greaterThanOrEqual(this.o(this.bd(17)), this.o(this.bd(18))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(this.bd(17)), this.o(this.bd(17))));
        Assert.assertSame((Object)true, (Object)this.e.greaterThanOrEqual(this.o(this.bd(17)), this.o(this.bd(16))));
    }

    @Test
    public void testInstanceOf() {
        Assert.assertNull((Object)this.e.instanceOf(this.o(0), this.o(0)));
    }

    @Test
    public void testEqual() {
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(false), this.o(true)));
        Assert.assertSame((Object)true, (Object)this.e.equal(this.o(false), this.o(false)));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(true), this.o(false)));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o("hello"), this.o("world")));
        Assert.assertSame((Object)true, (Object)this.e.equal(this.o("hello"), this.o("hello")));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o("young"), this.o("world")));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(2), this.o(3)));
        Assert.assertSame((Object)true, (Object)this.e.equal(this.o(2), this.o(2)));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(2), this.o(1)));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(5L), this.o(6L)));
        Assert.assertSame((Object)true, (Object)this.e.equal(this.o(5L), this.o(5L)));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(5L), this.o(4L)));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(9.0f))));
        Assert.assertSame((Object)true, (Object)this.e.equal(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(8.0f))));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(7.0f))));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(11.0), this.o(12.0)));
        Assert.assertSame((Object)true, (Object)this.e.equal(this.o(11.0), this.o(11.0)));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(11.0), this.o(10.0)));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(this.bi(14)), this.o(this.bi(15))));
        Assert.assertSame((Object)true, (Object)this.e.equal(this.o(this.bi(14)), this.o(this.bi(14))));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(this.bi(14)), this.o(this.bi(13))));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(this.bd(17)), this.o(this.bd(18))));
        Assert.assertSame((Object)true, (Object)this.e.equal(this.o(this.bd(17)), this.o(this.bd(17))));
        Assert.assertSame((Object)false, (Object)this.e.equal(this.o(this.bd(17)), this.o(this.bd(16))));
    }

    @Test
    public void testNotEqual() {
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(false), this.o(true)));
        Assert.assertSame((Object)false, (Object)this.e.notEqual(this.o(false), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(true), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o("hello"), this.o("world")));
        Assert.assertSame((Object)false, (Object)this.e.notEqual(this.o("hello"), this.o("hello")));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o("young"), this.o("world")));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(2), this.o(3)));
        Assert.assertSame((Object)false, (Object)this.e.notEqual(this.o(2), this.o(2)));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(2), this.o(1)));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(5L), this.o(6L)));
        Assert.assertSame((Object)false, (Object)this.e.notEqual(this.o(5L), this.o(5L)));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(5L), this.o(4L)));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(9.0f))));
        Assert.assertSame((Object)false, (Object)this.e.notEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(8.0f))));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(Float.valueOf(8.0f)), this.o(Float.valueOf(7.0f))));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(11.0), this.o(12.0)));
        Assert.assertSame((Object)false, (Object)this.e.notEqual(this.o(11.0), this.o(11.0)));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(11.0), this.o(10.0)));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(this.bi(14)), this.o(this.bi(15))));
        Assert.assertSame((Object)false, (Object)this.e.notEqual(this.o(this.bi(14)), this.o(this.bi(14))));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(this.bi(14)), this.o(this.bi(13))));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(this.bd(17)), this.o(this.bd(18))));
        Assert.assertSame((Object)false, (Object)this.e.notEqual(this.o(this.bd(17)), this.o(this.bd(17))));
        Assert.assertSame((Object)true, (Object)this.e.notEqual(this.o(this.bd(17)), this.o(this.bd(16))));
    }

    @Test
    public void testBitwiseAnd() {
        this.assertNumber(-894649682, this.e.bitwiseAnd(this.o(-889275714), this.o(-559038737)));
        this.assertNumber(0L, this.e.bitwiseAnd(this.o(940700423319850766L), this.o(-5701309803890954016L)));
        this.assertNumber(this.bi(-894649682), this.e.bitwiseAnd(this.o(this.bi(-889275714)), this.o(this.bi(-559038737))));
    }

    @Test
    public void testBitwiseOr() {
        this.assertNumber(-553664769, this.e.bitwiseOr(this.o(-889275714), this.o(-559038737)));
        this.assertNumber(-4760609380571103250L, this.e.bitwiseOr(this.o(940700423319850766L), this.o(-5701309803890954016L)));
        this.assertNumber(this.bi(-553664769), this.e.bitwiseOr(this.o(this.bi(-889275714)), this.o(this.bi(-559038737))));
    }

    @Test
    public void testLogicalAnd() {
        Assert.assertSame((Object)false, (Object)this.e.logicalAnd(this.o(false), this.o(false)));
        Assert.assertSame((Object)false, (Object)this.e.logicalAnd(this.o(false), this.o(true)));
        Assert.assertSame((Object)false, (Object)this.e.logicalAnd(this.o(true), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.logicalAnd(this.o(true), this.o(true)));
    }

    @Test
    public void testLogicalOr() {
        Assert.assertSame((Object)false, (Object)this.e.logicalOr(this.o(false), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.logicalOr(this.o(false), this.o(true)));
        Assert.assertSame((Object)true, (Object)this.e.logicalOr(this.o(true), this.o(false)));
        Assert.assertSame((Object)true, (Object)this.e.logicalOr(this.o(true), this.o(true)));
    }

    @Test
    public void testAssign() {
        Variable v = new Variable("v");
        this.assertAssigned(true, v, this.e.assign((Object)v, (Object)true));
        this.assertAssigned("hello", v, this.e.assign((Object)v, (Object)"hello"));
        this.assertAssigned(1, v, this.e.assign((Object)v, (Object)1));
        this.assertAssigned(2L, v, this.e.assign((Object)v, (Object)2L));
        this.assertAssigned(Float.valueOf(3.0f), v, this.e.assign((Object)v, (Object)Float.valueOf(3.0f)));
        this.assertAssigned(4.0, v, this.e.assign((Object)v, (Object)4.0));
        this.assertAssigned(this.bi(5), v, this.e.assign((Object)v, (Object)this.bi(5)));
        this.assertAssigned(this.bd(6), v, this.e.assign((Object)v, (Object)this.bd(6)));
    }

    @Test
    public void testPowAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)2.5);
        this.assertAssigned(15.625, v, this.e.powAssign((Object)v, (Object)3));
        this.e.set(v, (Object)this.bi(5));
        this.assertAssigned(this.bi(15625), v, this.e.powAssign((Object)v, (Object)6));
        this.e.set(v, (Object)this.bd(2.5));
        this.assertAssigned(this.bd(15.625), v, this.e.powAssign((Object)v, (Object)3));
    }

    @Test
    public void testDotPowAssign() {
    }

    @Test
    public void testMulAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)4);
        this.assertAssigned(24, v, this.e.mulAssign((Object)v, (Object)6));
        this.e.set(v, (Object)4L);
        this.assertAssigned(24L, v, this.e.mulAssign((Object)v, (Object)6L));
        this.e.set(v, (Object)Float.valueOf(2.5f));
        this.assertAssigned(Float.valueOf(8.75f), v, this.e.mulAssign((Object)v, (Object)Float.valueOf(3.5f)));
        this.e.set(v, (Object)2.5);
        this.assertAssigned(8.75, v, this.e.mulAssign((Object)v, (Object)3.5));
        this.e.set(v, (Object)this.bi(4));
        this.assertAssigned(this.bi(24), v, this.e.mulAssign((Object)v, (Object)this.bi(6)));
        this.e.set(v, (Object)this.bd(2.5));
        this.assertAssigned(this.bd(8.75), v, this.e.mulAssign((Object)v, (Object)this.bd(3.5)));
    }

    @Test
    public void testDivAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)27);
        this.assertAssigned(4, v, this.e.divAssign((Object)v, (Object)6));
        this.e.set(v, (Object)27L);
        this.assertAssigned(4L, v, this.e.divAssign((Object)v, (Object)6L));
        this.e.set(v, (Object)Float.valueOf(8.75f));
        this.assertAssigned(Float.valueOf(2.5f), v, this.e.divAssign((Object)v, (Object)Float.valueOf(3.5f)));
        this.e.set(v, (Object)8.75);
        this.assertAssigned(2.5, v, this.e.divAssign((Object)v, (Object)3.5));
        this.e.set(v, (Object)this.bi(27));
        this.assertAssigned(this.bi(4), v, this.e.divAssign((Object)v, (Object)this.bi(6)));
        this.e.set(v, (Object)this.bd(8.75));
        this.assertAssigned(this.bd(2.5), v, this.e.divAssign((Object)v, (Object)this.bd(3.5)));
    }

    @Test
    public void testModAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)27);
        this.assertAssigned(3, v, this.e.modAssign((Object)v, (Object)6));
        this.e.set(v, (Object)27L);
        this.assertAssigned(3L, v, this.e.modAssign((Object)v, (Object)6L));
        this.e.set(v, (Object)Float.valueOf(8.75f));
        this.assertAssigned(Float.valueOf(1.75f), v, this.e.modAssign((Object)v, (Object)Float.valueOf(3.5f)));
        this.e.set(v, (Object)8.75);
        this.assertAssigned(1.75, v, this.e.modAssign((Object)v, (Object)3.5));
        this.e.set(v, (Object)this.bi(27));
        this.assertAssigned(this.bi(3), v, this.e.modAssign((Object)v, (Object)this.bi(6)));
        this.e.set(v, (Object)this.bd(8.75));
        this.assertAssigned(this.bd(1.75), v, this.e.modAssign((Object)v, (Object)this.bd(3.5)));
    }

    @Test
    public void testRightDivAssign() {
    }

    @Test
    public void testDotDivAssign() {
    }

    @Test
    public void testDotRightDivAssign() {
    }

    @Test
    public void testAddAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)"Hello,");
        this.assertAssigned("Hello, world", v, this.e.addAssign((Object)v, (Object)" world"));
        this.e.set(v, (Object)4);
        this.assertAssigned(10, v, this.e.addAssign((Object)v, (Object)6));
        this.e.set(v, (Object)4L);
        this.assertAssigned(10L, v, this.e.addAssign((Object)v, (Object)6L));
        this.e.set(v, (Object)Float.valueOf(1.5f));
        this.assertAssigned(Float.valueOf(3.6f), v, this.e.addAssign((Object)v, (Object)Float.valueOf(2.1f)));
        this.e.set(v, (Object)1.5);
        this.assertAssigned(3.6, v, this.e.addAssign((Object)v, (Object)2.1));
        this.e.set(v, (Object)this.bi(4));
        this.assertAssigned(this.bi(10), v, this.e.addAssign((Object)v, (Object)this.bi(6)));
        this.e.set(v, (Object)this.bd(1.5));
        this.assertAssigned(this.bd(3.6), v, this.e.addAssign((Object)v, (Object)this.bd(2.1)));
    }

    @Test
    public void testSubAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)10);
        this.assertAssigned(4, v, this.e.subAssign((Object)v, (Object)6));
        this.e.set(v, (Object)10L);
        this.assertAssigned(4L, v, this.e.subAssign((Object)v, (Object)6L));
        this.e.set(v, (Object)Float.valueOf(3.6f));
        this.assertAssigned(Float.valueOf(1.5f), v, this.e.subAssign((Object)v, (Object)Float.valueOf(2.1f)));
        this.e.set(v, (Object)3.6);
        this.assertAssigned(1.5, v, this.e.subAssign((Object)v, (Object)2.1));
        this.e.set(v, (Object)this.bi(10));
        this.assertAssigned(this.bi(4), v, this.e.subAssign((Object)v, (Object)this.bi(6)));
        this.e.set(v, (Object)this.bd(3.6));
        this.assertAssigned(this.bd(1.5), v, this.e.subAssign((Object)v, (Object)this.bd(2.1)));
    }

    @Test
    public void testAndAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)-889275714);
        this.assertAssigned(-894649682, v, this.e.andAssign((Object)v, (Object)-559038737));
        this.e.set(v, (Object)940700423319850766L);
        this.assertAssigned(0L, v, this.e.andAssign((Object)v, (Object)-5701309803890954016L));
        this.e.set(v, (Object)this.bi(3405691582L));
        this.assertAssigned(this.bi(3400317614L), v, this.e.andAssign((Object)v, (Object)this.bi(3735928559L)));
    }

    @Test
    public void testOrAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)-889275714);
        this.assertAssigned(-553664769, v, this.e.orAssign((Object)v, (Object)-559038737));
        this.e.set(v, (Object)940700423319850766L);
        this.assertAssigned(-4760609380571103250L, v, this.e.orAssign((Object)v, (Object)-5701309803890954016L));
        this.e.set(v, (Object)this.bi(3405691582L));
        this.assertAssigned(this.bi(3741302527L), v, this.e.orAssign((Object)v, (Object)this.bi(3735928559L)));
    }

    @Test
    public void testLeftShiftAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)-889275714);
        this.assertAssigned(-1343509536, v, this.e.leftShiftAssign((Object)v, (Object)4));
        this.e.set(v, (Object)-2401039830844720450L);
        this.assertAssigned(-2544555852783951872L, v, this.e.leftShiftAssign((Object)v, (Object)12));
        this.e.set(v, (Object)this.bi(57));
        this.assertAssigned(this.bi(7296), v, this.e.leftShiftAssign((Object)v, (Object)7));
    }

    @Test
    public void testRightShiftAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)-889275714);
        this.assertAssigned(-55579733, v, this.e.rightShiftAssign((Object)v, (Object)4));
        this.e.set(v, (Object)-2401039830844720450L);
        this.assertAssigned(-586191364952325L, v, this.e.rightShiftAssign((Object)v, (Object)12));
        this.e.set(v, (Object)this.bi(8920));
        this.assertAssigned(this.bi(278), v, this.e.rightShiftAssign((Object)v, (Object)5));
    }

    @Test
    public void testUnsignedRightShiftAssign() {
        Variable v = new Variable("v");
        this.e.set(v, (Object)-889275714);
        this.assertAssigned(212855723, v, this.e.unsignedRightShiftAssign((Object)v, (Object)4));
        this.e.set(v, (Object)-2401039830844720450L);
        this.assertAssigned(3917408262418171L, v, this.e.unsignedRightShiftAssign((Object)v, (Object)12));
    }

    private Object o(Object o) {
        return o;
    }

    private BigInteger bi(Object o) {
        return new BigInteger(o.toString());
    }

    private BigDecimal bd(Object o) {
        return new BigDecimal(o.toString());
    }

    private void assertAssigned(Object expected, Variable v, Object result) {
        Assert.assertSame((Object)v, (Object)result);
        Assert.assertEquals((Object)expected, (Object)this.e.get(v));
    }
}

