/*-
 * #%L
 * Functional interfaces for SciJava-based libraries.
 * %%
 * Copyright (C) 2021 - 2024 SciJava developers.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */
/*
 * This is autogenerated source code -- DO NOT EDIT. Instead, edit the
 * corresponding template in templates/ and rerun bin/generate.groovy.
 */

package org.scijava.function;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * Container class for inplace-style functional interfaces at various
 * <a href="https://en.wikipedia.org/wiki/Arity">arities</a>.
 * <p>
 * An inplace has functional method {@code mutate} with a number of arguments
 * corresponding to the arity. Any of the arguments annotated
 * with @{@link Mutable} may be mutated during execution. Some interfaces narrow
 * this behavior to only a specific argument; most ops in practice will
 * implement one of these narrowed interfaces. For example,
 * {@link Inplaces.Arity2_1} is a binary inplace op that mutates the first of
 * two arguments&mdash;e.g., an {@code a /= b} division operation would be an
 * {@link Inplaces.Arity2_1}, whereas {@code b = a / b} would be an
 * {@link Inplaces.Arity2_2}.
 * </p>
 * <p>
 * Each inplace interface implements a corresponding {@link Consumer}-style
 * interface (see {@link Consumers}) with same arity; the consumer's
 * {@code accept} method simply delegates to {@code mutate}. This pattern allows
 * inplace ops to be used directly as consumers as needed.
 * </p>
 * <p>
 * Note that there is no nullary (arity 0) inplace interface, because there
 * would be no arguments to mutate; see also {@link Consumers.Arity0},
 * {@link Computers.Arity0} and {@link Producer}.
 * </p>
 *
 * @author Curtis Rueden
 * @author Gabriel Selzer
 */
public final class Inplaces {

	private Inplaces() {
		// NB: Prevent instantiation of container class.
	}

	/**
	 * All known inplace types and their arities and mutable positions. The
	 * entries are sorted by arity and mutable position.
	 */
	public static final Map<InplaceInfo, Class<?>> ALL_INPLACES;
	public static final Map<Class<?>, InplaceInfo> ALL_ARITIES;

	static {
		ALL_INPLACES = new HashMap<>();
		ALL_ARITIES = new HashMap<>();
        InplaceInfo info_1_1 = new InplaceInfo(1, 0);
		ALL_INPLACES.put(info_1_1, Inplaces.Arity1.class);
		ALL_ARITIES.put(Inplaces.Arity1.class, info_1_1);
        InplaceInfo info_2_1 = new InplaceInfo(2, 0);
		ALL_INPLACES.put(info_2_1, Inplaces.Arity2_1.class);
		ALL_ARITIES.put(Inplaces.Arity2_1.class, info_2_1);
        InplaceInfo info_2_2 = new InplaceInfo(2, 1);
		ALL_INPLACES.put(info_2_2, Inplaces.Arity2_2.class);
		ALL_ARITIES.put(Inplaces.Arity2_2.class, info_2_2);
        InplaceInfo info_3_1 = new InplaceInfo(3, 0);
		ALL_INPLACES.put(info_3_1, Inplaces.Arity3_1.class);
		ALL_ARITIES.put(Inplaces.Arity3_1.class, info_3_1);
        InplaceInfo info_3_2 = new InplaceInfo(3, 1);
		ALL_INPLACES.put(info_3_2, Inplaces.Arity3_2.class);
		ALL_ARITIES.put(Inplaces.Arity3_2.class, info_3_2);
        InplaceInfo info_3_3 = new InplaceInfo(3, 2);
		ALL_INPLACES.put(info_3_3, Inplaces.Arity3_3.class);
		ALL_ARITIES.put(Inplaces.Arity3_3.class, info_3_3);
        InplaceInfo info_4_1 = new InplaceInfo(4, 0);
		ALL_INPLACES.put(info_4_1, Inplaces.Arity4_1.class);
		ALL_ARITIES.put(Inplaces.Arity4_1.class, info_4_1);
        InplaceInfo info_4_2 = new InplaceInfo(4, 1);
		ALL_INPLACES.put(info_4_2, Inplaces.Arity4_2.class);
		ALL_ARITIES.put(Inplaces.Arity4_2.class, info_4_2);
        InplaceInfo info_4_3 = new InplaceInfo(4, 2);
		ALL_INPLACES.put(info_4_3, Inplaces.Arity4_3.class);
		ALL_ARITIES.put(Inplaces.Arity4_3.class, info_4_3);
        InplaceInfo info_4_4 = new InplaceInfo(4, 3);
		ALL_INPLACES.put(info_4_4, Inplaces.Arity4_4.class);
		ALL_ARITIES.put(Inplaces.Arity4_4.class, info_4_4);
        InplaceInfo info_5_1 = new InplaceInfo(5, 0);
		ALL_INPLACES.put(info_5_1, Inplaces.Arity5_1.class);
		ALL_ARITIES.put(Inplaces.Arity5_1.class, info_5_1);
        InplaceInfo info_5_2 = new InplaceInfo(5, 1);
		ALL_INPLACES.put(info_5_2, Inplaces.Arity5_2.class);
		ALL_ARITIES.put(Inplaces.Arity5_2.class, info_5_2);
        InplaceInfo info_5_3 = new InplaceInfo(5, 2);
		ALL_INPLACES.put(info_5_3, Inplaces.Arity5_3.class);
		ALL_ARITIES.put(Inplaces.Arity5_3.class, info_5_3);
        InplaceInfo info_5_4 = new InplaceInfo(5, 3);
		ALL_INPLACES.put(info_5_4, Inplaces.Arity5_4.class);
		ALL_ARITIES.put(Inplaces.Arity5_4.class, info_5_4);
        InplaceInfo info_5_5 = new InplaceInfo(5, 4);
		ALL_INPLACES.put(info_5_5, Inplaces.Arity5_5.class);
		ALL_ARITIES.put(Inplaces.Arity5_5.class, info_5_5);
        InplaceInfo info_6_1 = new InplaceInfo(6, 0);
		ALL_INPLACES.put(info_6_1, Inplaces.Arity6_1.class);
		ALL_ARITIES.put(Inplaces.Arity6_1.class, info_6_1);
        InplaceInfo info_6_2 = new InplaceInfo(6, 1);
		ALL_INPLACES.put(info_6_2, Inplaces.Arity6_2.class);
		ALL_ARITIES.put(Inplaces.Arity6_2.class, info_6_2);
        InplaceInfo info_6_3 = new InplaceInfo(6, 2);
		ALL_INPLACES.put(info_6_3, Inplaces.Arity6_3.class);
		ALL_ARITIES.put(Inplaces.Arity6_3.class, info_6_3);
        InplaceInfo info_6_4 = new InplaceInfo(6, 3);
		ALL_INPLACES.put(info_6_4, Inplaces.Arity6_4.class);
		ALL_ARITIES.put(Inplaces.Arity6_4.class, info_6_4);
        InplaceInfo info_6_5 = new InplaceInfo(6, 4);
		ALL_INPLACES.put(info_6_5, Inplaces.Arity6_5.class);
		ALL_ARITIES.put(Inplaces.Arity6_5.class, info_6_5);
        InplaceInfo info_6_6 = new InplaceInfo(6, 5);
		ALL_INPLACES.put(info_6_6, Inplaces.Arity6_6.class);
		ALL_ARITIES.put(Inplaces.Arity6_6.class, info_6_6);
        InplaceInfo info_7_1 = new InplaceInfo(7, 0);
		ALL_INPLACES.put(info_7_1, Inplaces.Arity7_1.class);
		ALL_ARITIES.put(Inplaces.Arity7_1.class, info_7_1);
        InplaceInfo info_7_2 = new InplaceInfo(7, 1);
		ALL_INPLACES.put(info_7_2, Inplaces.Arity7_2.class);
		ALL_ARITIES.put(Inplaces.Arity7_2.class, info_7_2);
        InplaceInfo info_7_3 = new InplaceInfo(7, 2);
		ALL_INPLACES.put(info_7_3, Inplaces.Arity7_3.class);
		ALL_ARITIES.put(Inplaces.Arity7_3.class, info_7_3);
        InplaceInfo info_7_4 = new InplaceInfo(7, 3);
		ALL_INPLACES.put(info_7_4, Inplaces.Arity7_4.class);
		ALL_ARITIES.put(Inplaces.Arity7_4.class, info_7_4);
        InplaceInfo info_7_5 = new InplaceInfo(7, 4);
		ALL_INPLACES.put(info_7_5, Inplaces.Arity7_5.class);
		ALL_ARITIES.put(Inplaces.Arity7_5.class, info_7_5);
        InplaceInfo info_7_6 = new InplaceInfo(7, 5);
		ALL_INPLACES.put(info_7_6, Inplaces.Arity7_6.class);
		ALL_ARITIES.put(Inplaces.Arity7_6.class, info_7_6);
        InplaceInfo info_7_7 = new InplaceInfo(7, 6);
		ALL_INPLACES.put(info_7_7, Inplaces.Arity7_7.class);
		ALL_ARITIES.put(Inplaces.Arity7_7.class, info_7_7);
        InplaceInfo info_8_1 = new InplaceInfo(8, 0);
		ALL_INPLACES.put(info_8_1, Inplaces.Arity8_1.class);
		ALL_ARITIES.put(Inplaces.Arity8_1.class, info_8_1);
        InplaceInfo info_8_2 = new InplaceInfo(8, 1);
		ALL_INPLACES.put(info_8_2, Inplaces.Arity8_2.class);
		ALL_ARITIES.put(Inplaces.Arity8_2.class, info_8_2);
        InplaceInfo info_8_3 = new InplaceInfo(8, 2);
		ALL_INPLACES.put(info_8_3, Inplaces.Arity8_3.class);
		ALL_ARITIES.put(Inplaces.Arity8_3.class, info_8_3);
        InplaceInfo info_8_4 = new InplaceInfo(8, 3);
		ALL_INPLACES.put(info_8_4, Inplaces.Arity8_4.class);
		ALL_ARITIES.put(Inplaces.Arity8_4.class, info_8_4);
        InplaceInfo info_8_5 = new InplaceInfo(8, 4);
		ALL_INPLACES.put(info_8_5, Inplaces.Arity8_5.class);
		ALL_ARITIES.put(Inplaces.Arity8_5.class, info_8_5);
        InplaceInfo info_8_6 = new InplaceInfo(8, 5);
		ALL_INPLACES.put(info_8_6, Inplaces.Arity8_6.class);
		ALL_ARITIES.put(Inplaces.Arity8_6.class, info_8_6);
        InplaceInfo info_8_7 = new InplaceInfo(8, 6);
		ALL_INPLACES.put(info_8_7, Inplaces.Arity8_7.class);
		ALL_ARITIES.put(Inplaces.Arity8_7.class, info_8_7);
        InplaceInfo info_8_8 = new InplaceInfo(8, 7);
		ALL_INPLACES.put(info_8_8, Inplaces.Arity8_8.class);
		ALL_ARITIES.put(Inplaces.Arity8_8.class, info_8_8);
        InplaceInfo info_9_1 = new InplaceInfo(9, 0);
		ALL_INPLACES.put(info_9_1, Inplaces.Arity9_1.class);
		ALL_ARITIES.put(Inplaces.Arity9_1.class, info_9_1);
        InplaceInfo info_9_2 = new InplaceInfo(9, 1);
		ALL_INPLACES.put(info_9_2, Inplaces.Arity9_2.class);
		ALL_ARITIES.put(Inplaces.Arity9_2.class, info_9_2);
        InplaceInfo info_9_3 = new InplaceInfo(9, 2);
		ALL_INPLACES.put(info_9_3, Inplaces.Arity9_3.class);
		ALL_ARITIES.put(Inplaces.Arity9_3.class, info_9_3);
        InplaceInfo info_9_4 = new InplaceInfo(9, 3);
		ALL_INPLACES.put(info_9_4, Inplaces.Arity9_4.class);
		ALL_ARITIES.put(Inplaces.Arity9_4.class, info_9_4);
        InplaceInfo info_9_5 = new InplaceInfo(9, 4);
		ALL_INPLACES.put(info_9_5, Inplaces.Arity9_5.class);
		ALL_ARITIES.put(Inplaces.Arity9_5.class, info_9_5);
        InplaceInfo info_9_6 = new InplaceInfo(9, 5);
		ALL_INPLACES.put(info_9_6, Inplaces.Arity9_6.class);
		ALL_ARITIES.put(Inplaces.Arity9_6.class, info_9_6);
        InplaceInfo info_9_7 = new InplaceInfo(9, 6);
		ALL_INPLACES.put(info_9_7, Inplaces.Arity9_7.class);
		ALL_ARITIES.put(Inplaces.Arity9_7.class, info_9_7);
        InplaceInfo info_9_8 = new InplaceInfo(9, 7);
		ALL_INPLACES.put(info_9_8, Inplaces.Arity9_8.class);
		ALL_ARITIES.put(Inplaces.Arity9_8.class, info_9_8);
        InplaceInfo info_9_9 = new InplaceInfo(9, 8);
		ALL_INPLACES.put(info_9_9, Inplaces.Arity9_9.class);
		ALL_ARITIES.put(Inplaces.Arity9_9.class, info_9_9);
        InplaceInfo info_10_1 = new InplaceInfo(10, 0);
		ALL_INPLACES.put(info_10_1, Inplaces.Arity10_1.class);
		ALL_ARITIES.put(Inplaces.Arity10_1.class, info_10_1);
        InplaceInfo info_10_2 = new InplaceInfo(10, 1);
		ALL_INPLACES.put(info_10_2, Inplaces.Arity10_2.class);
		ALL_ARITIES.put(Inplaces.Arity10_2.class, info_10_2);
        InplaceInfo info_10_3 = new InplaceInfo(10, 2);
		ALL_INPLACES.put(info_10_3, Inplaces.Arity10_3.class);
		ALL_ARITIES.put(Inplaces.Arity10_3.class, info_10_3);
        InplaceInfo info_10_4 = new InplaceInfo(10, 3);
		ALL_INPLACES.put(info_10_4, Inplaces.Arity10_4.class);
		ALL_ARITIES.put(Inplaces.Arity10_4.class, info_10_4);
        InplaceInfo info_10_5 = new InplaceInfo(10, 4);
		ALL_INPLACES.put(info_10_5, Inplaces.Arity10_5.class);
		ALL_ARITIES.put(Inplaces.Arity10_5.class, info_10_5);
        InplaceInfo info_10_6 = new InplaceInfo(10, 5);
		ALL_INPLACES.put(info_10_6, Inplaces.Arity10_6.class);
		ALL_ARITIES.put(Inplaces.Arity10_6.class, info_10_6);
        InplaceInfo info_10_7 = new InplaceInfo(10, 6);
		ALL_INPLACES.put(info_10_7, Inplaces.Arity10_7.class);
		ALL_ARITIES.put(Inplaces.Arity10_7.class, info_10_7);
        InplaceInfo info_10_8 = new InplaceInfo(10, 7);
		ALL_INPLACES.put(info_10_8, Inplaces.Arity10_8.class);
		ALL_ARITIES.put(Inplaces.Arity10_8.class, info_10_8);
        InplaceInfo info_10_9 = new InplaceInfo(10, 8);
		ALL_INPLACES.put(info_10_9, Inplaces.Arity10_9.class);
		ALL_ARITIES.put(Inplaces.Arity10_9.class, info_10_9);
        InplaceInfo info_10_10 = new InplaceInfo(10, 9);
		ALL_INPLACES.put(info_10_10, Inplaces.Arity10_10.class);
		ALL_ARITIES.put(Inplaces.Arity10_10.class, info_10_10);
        InplaceInfo info_11_1 = new InplaceInfo(11, 0);
		ALL_INPLACES.put(info_11_1, Inplaces.Arity11_1.class);
		ALL_ARITIES.put(Inplaces.Arity11_1.class, info_11_1);
        InplaceInfo info_11_2 = new InplaceInfo(11, 1);
		ALL_INPLACES.put(info_11_2, Inplaces.Arity11_2.class);
		ALL_ARITIES.put(Inplaces.Arity11_2.class, info_11_2);
        InplaceInfo info_11_3 = new InplaceInfo(11, 2);
		ALL_INPLACES.put(info_11_3, Inplaces.Arity11_3.class);
		ALL_ARITIES.put(Inplaces.Arity11_3.class, info_11_3);
        InplaceInfo info_11_4 = new InplaceInfo(11, 3);
		ALL_INPLACES.put(info_11_4, Inplaces.Arity11_4.class);
		ALL_ARITIES.put(Inplaces.Arity11_4.class, info_11_4);
        InplaceInfo info_11_5 = new InplaceInfo(11, 4);
		ALL_INPLACES.put(info_11_5, Inplaces.Arity11_5.class);
		ALL_ARITIES.put(Inplaces.Arity11_5.class, info_11_5);
        InplaceInfo info_11_6 = new InplaceInfo(11, 5);
		ALL_INPLACES.put(info_11_6, Inplaces.Arity11_6.class);
		ALL_ARITIES.put(Inplaces.Arity11_6.class, info_11_6);
        InplaceInfo info_11_7 = new InplaceInfo(11, 6);
		ALL_INPLACES.put(info_11_7, Inplaces.Arity11_7.class);
		ALL_ARITIES.put(Inplaces.Arity11_7.class, info_11_7);
        InplaceInfo info_11_8 = new InplaceInfo(11, 7);
		ALL_INPLACES.put(info_11_8, Inplaces.Arity11_8.class);
		ALL_ARITIES.put(Inplaces.Arity11_8.class, info_11_8);
        InplaceInfo info_11_9 = new InplaceInfo(11, 8);
		ALL_INPLACES.put(info_11_9, Inplaces.Arity11_9.class);
		ALL_ARITIES.put(Inplaces.Arity11_9.class, info_11_9);
        InplaceInfo info_11_10 = new InplaceInfo(11, 9);
		ALL_INPLACES.put(info_11_10, Inplaces.Arity11_10.class);
		ALL_ARITIES.put(Inplaces.Arity11_10.class, info_11_10);
        InplaceInfo info_11_11 = new InplaceInfo(11, 10);
		ALL_INPLACES.put(info_11_11, Inplaces.Arity11_11.class);
		ALL_ARITIES.put(Inplaces.Arity11_11.class, info_11_11);
        InplaceInfo info_12_1 = new InplaceInfo(12, 0);
		ALL_INPLACES.put(info_12_1, Inplaces.Arity12_1.class);
		ALL_ARITIES.put(Inplaces.Arity12_1.class, info_12_1);
        InplaceInfo info_12_2 = new InplaceInfo(12, 1);
		ALL_INPLACES.put(info_12_2, Inplaces.Arity12_2.class);
		ALL_ARITIES.put(Inplaces.Arity12_2.class, info_12_2);
        InplaceInfo info_12_3 = new InplaceInfo(12, 2);
		ALL_INPLACES.put(info_12_3, Inplaces.Arity12_3.class);
		ALL_ARITIES.put(Inplaces.Arity12_3.class, info_12_3);
        InplaceInfo info_12_4 = new InplaceInfo(12, 3);
		ALL_INPLACES.put(info_12_4, Inplaces.Arity12_4.class);
		ALL_ARITIES.put(Inplaces.Arity12_4.class, info_12_4);
        InplaceInfo info_12_5 = new InplaceInfo(12, 4);
		ALL_INPLACES.put(info_12_5, Inplaces.Arity12_5.class);
		ALL_ARITIES.put(Inplaces.Arity12_5.class, info_12_5);
        InplaceInfo info_12_6 = new InplaceInfo(12, 5);
		ALL_INPLACES.put(info_12_6, Inplaces.Arity12_6.class);
		ALL_ARITIES.put(Inplaces.Arity12_6.class, info_12_6);
        InplaceInfo info_12_7 = new InplaceInfo(12, 6);
		ALL_INPLACES.put(info_12_7, Inplaces.Arity12_7.class);
		ALL_ARITIES.put(Inplaces.Arity12_7.class, info_12_7);
        InplaceInfo info_12_8 = new InplaceInfo(12, 7);
		ALL_INPLACES.put(info_12_8, Inplaces.Arity12_8.class);
		ALL_ARITIES.put(Inplaces.Arity12_8.class, info_12_8);
        InplaceInfo info_12_9 = new InplaceInfo(12, 8);
		ALL_INPLACES.put(info_12_9, Inplaces.Arity12_9.class);
		ALL_ARITIES.put(Inplaces.Arity12_9.class, info_12_9);
        InplaceInfo info_12_10 = new InplaceInfo(12, 9);
		ALL_INPLACES.put(info_12_10, Inplaces.Arity12_10.class);
		ALL_ARITIES.put(Inplaces.Arity12_10.class, info_12_10);
        InplaceInfo info_12_11 = new InplaceInfo(12, 10);
		ALL_INPLACES.put(info_12_11, Inplaces.Arity12_11.class);
		ALL_ARITIES.put(Inplaces.Arity12_11.class, info_12_11);
        InplaceInfo info_12_12 = new InplaceInfo(12, 11);
		ALL_INPLACES.put(info_12_12, Inplaces.Arity12_12.class);
		ALL_ARITIES.put(Inplaces.Arity12_12.class, info_12_12);
        InplaceInfo info_13_1 = new InplaceInfo(13, 0);
		ALL_INPLACES.put(info_13_1, Inplaces.Arity13_1.class);
		ALL_ARITIES.put(Inplaces.Arity13_1.class, info_13_1);
        InplaceInfo info_13_2 = new InplaceInfo(13, 1);
		ALL_INPLACES.put(info_13_2, Inplaces.Arity13_2.class);
		ALL_ARITIES.put(Inplaces.Arity13_2.class, info_13_2);
        InplaceInfo info_13_3 = new InplaceInfo(13, 2);
		ALL_INPLACES.put(info_13_3, Inplaces.Arity13_3.class);
		ALL_ARITIES.put(Inplaces.Arity13_3.class, info_13_3);
        InplaceInfo info_13_4 = new InplaceInfo(13, 3);
		ALL_INPLACES.put(info_13_4, Inplaces.Arity13_4.class);
		ALL_ARITIES.put(Inplaces.Arity13_4.class, info_13_4);
        InplaceInfo info_13_5 = new InplaceInfo(13, 4);
		ALL_INPLACES.put(info_13_5, Inplaces.Arity13_5.class);
		ALL_ARITIES.put(Inplaces.Arity13_5.class, info_13_5);
        InplaceInfo info_13_6 = new InplaceInfo(13, 5);
		ALL_INPLACES.put(info_13_6, Inplaces.Arity13_6.class);
		ALL_ARITIES.put(Inplaces.Arity13_6.class, info_13_6);
        InplaceInfo info_13_7 = new InplaceInfo(13, 6);
		ALL_INPLACES.put(info_13_7, Inplaces.Arity13_7.class);
		ALL_ARITIES.put(Inplaces.Arity13_7.class, info_13_7);
        InplaceInfo info_13_8 = new InplaceInfo(13, 7);
		ALL_INPLACES.put(info_13_8, Inplaces.Arity13_8.class);
		ALL_ARITIES.put(Inplaces.Arity13_8.class, info_13_8);
        InplaceInfo info_13_9 = new InplaceInfo(13, 8);
		ALL_INPLACES.put(info_13_9, Inplaces.Arity13_9.class);
		ALL_ARITIES.put(Inplaces.Arity13_9.class, info_13_9);
        InplaceInfo info_13_10 = new InplaceInfo(13, 9);
		ALL_INPLACES.put(info_13_10, Inplaces.Arity13_10.class);
		ALL_ARITIES.put(Inplaces.Arity13_10.class, info_13_10);
        InplaceInfo info_13_11 = new InplaceInfo(13, 10);
		ALL_INPLACES.put(info_13_11, Inplaces.Arity13_11.class);
		ALL_ARITIES.put(Inplaces.Arity13_11.class, info_13_11);
        InplaceInfo info_13_12 = new InplaceInfo(13, 11);
		ALL_INPLACES.put(info_13_12, Inplaces.Arity13_12.class);
		ALL_ARITIES.put(Inplaces.Arity13_12.class, info_13_12);
        InplaceInfo info_13_13 = new InplaceInfo(13, 12);
		ALL_INPLACES.put(info_13_13, Inplaces.Arity13_13.class);
		ALL_ARITIES.put(Inplaces.Arity13_13.class, info_13_13);
        InplaceInfo info_14_1 = new InplaceInfo(14, 0);
		ALL_INPLACES.put(info_14_1, Inplaces.Arity14_1.class);
		ALL_ARITIES.put(Inplaces.Arity14_1.class, info_14_1);
        InplaceInfo info_14_2 = new InplaceInfo(14, 1);
		ALL_INPLACES.put(info_14_2, Inplaces.Arity14_2.class);
		ALL_ARITIES.put(Inplaces.Arity14_2.class, info_14_2);
        InplaceInfo info_14_3 = new InplaceInfo(14, 2);
		ALL_INPLACES.put(info_14_3, Inplaces.Arity14_3.class);
		ALL_ARITIES.put(Inplaces.Arity14_3.class, info_14_3);
        InplaceInfo info_14_4 = new InplaceInfo(14, 3);
		ALL_INPLACES.put(info_14_4, Inplaces.Arity14_4.class);
		ALL_ARITIES.put(Inplaces.Arity14_4.class, info_14_4);
        InplaceInfo info_14_5 = new InplaceInfo(14, 4);
		ALL_INPLACES.put(info_14_5, Inplaces.Arity14_5.class);
		ALL_ARITIES.put(Inplaces.Arity14_5.class, info_14_5);
        InplaceInfo info_14_6 = new InplaceInfo(14, 5);
		ALL_INPLACES.put(info_14_6, Inplaces.Arity14_6.class);
		ALL_ARITIES.put(Inplaces.Arity14_6.class, info_14_6);
        InplaceInfo info_14_7 = new InplaceInfo(14, 6);
		ALL_INPLACES.put(info_14_7, Inplaces.Arity14_7.class);
		ALL_ARITIES.put(Inplaces.Arity14_7.class, info_14_7);
        InplaceInfo info_14_8 = new InplaceInfo(14, 7);
		ALL_INPLACES.put(info_14_8, Inplaces.Arity14_8.class);
		ALL_ARITIES.put(Inplaces.Arity14_8.class, info_14_8);
        InplaceInfo info_14_9 = new InplaceInfo(14, 8);
		ALL_INPLACES.put(info_14_9, Inplaces.Arity14_9.class);
		ALL_ARITIES.put(Inplaces.Arity14_9.class, info_14_9);
        InplaceInfo info_14_10 = new InplaceInfo(14, 9);
		ALL_INPLACES.put(info_14_10, Inplaces.Arity14_10.class);
		ALL_ARITIES.put(Inplaces.Arity14_10.class, info_14_10);
        InplaceInfo info_14_11 = new InplaceInfo(14, 10);
		ALL_INPLACES.put(info_14_11, Inplaces.Arity14_11.class);
		ALL_ARITIES.put(Inplaces.Arity14_11.class, info_14_11);
        InplaceInfo info_14_12 = new InplaceInfo(14, 11);
		ALL_INPLACES.put(info_14_12, Inplaces.Arity14_12.class);
		ALL_ARITIES.put(Inplaces.Arity14_12.class, info_14_12);
        InplaceInfo info_14_13 = new InplaceInfo(14, 12);
		ALL_INPLACES.put(info_14_13, Inplaces.Arity14_13.class);
		ALL_ARITIES.put(Inplaces.Arity14_13.class, info_14_13);
        InplaceInfo info_14_14 = new InplaceInfo(14, 13);
		ALL_INPLACES.put(info_14_14, Inplaces.Arity14_14.class);
		ALL_ARITIES.put(Inplaces.Arity14_14.class, info_14_14);
        InplaceInfo info_15_1 = new InplaceInfo(15, 0);
		ALL_INPLACES.put(info_15_1, Inplaces.Arity15_1.class);
		ALL_ARITIES.put(Inplaces.Arity15_1.class, info_15_1);
        InplaceInfo info_15_2 = new InplaceInfo(15, 1);
		ALL_INPLACES.put(info_15_2, Inplaces.Arity15_2.class);
		ALL_ARITIES.put(Inplaces.Arity15_2.class, info_15_2);
        InplaceInfo info_15_3 = new InplaceInfo(15, 2);
		ALL_INPLACES.put(info_15_3, Inplaces.Arity15_3.class);
		ALL_ARITIES.put(Inplaces.Arity15_3.class, info_15_3);
        InplaceInfo info_15_4 = new InplaceInfo(15, 3);
		ALL_INPLACES.put(info_15_4, Inplaces.Arity15_4.class);
		ALL_ARITIES.put(Inplaces.Arity15_4.class, info_15_4);
        InplaceInfo info_15_5 = new InplaceInfo(15, 4);
		ALL_INPLACES.put(info_15_5, Inplaces.Arity15_5.class);
		ALL_ARITIES.put(Inplaces.Arity15_5.class, info_15_5);
        InplaceInfo info_15_6 = new InplaceInfo(15, 5);
		ALL_INPLACES.put(info_15_6, Inplaces.Arity15_6.class);
		ALL_ARITIES.put(Inplaces.Arity15_6.class, info_15_6);
        InplaceInfo info_15_7 = new InplaceInfo(15, 6);
		ALL_INPLACES.put(info_15_7, Inplaces.Arity15_7.class);
		ALL_ARITIES.put(Inplaces.Arity15_7.class, info_15_7);
        InplaceInfo info_15_8 = new InplaceInfo(15, 7);
		ALL_INPLACES.put(info_15_8, Inplaces.Arity15_8.class);
		ALL_ARITIES.put(Inplaces.Arity15_8.class, info_15_8);
        InplaceInfo info_15_9 = new InplaceInfo(15, 8);
		ALL_INPLACES.put(info_15_9, Inplaces.Arity15_9.class);
		ALL_ARITIES.put(Inplaces.Arity15_9.class, info_15_9);
        InplaceInfo info_15_10 = new InplaceInfo(15, 9);
		ALL_INPLACES.put(info_15_10, Inplaces.Arity15_10.class);
		ALL_ARITIES.put(Inplaces.Arity15_10.class, info_15_10);
        InplaceInfo info_15_11 = new InplaceInfo(15, 10);
		ALL_INPLACES.put(info_15_11, Inplaces.Arity15_11.class);
		ALL_ARITIES.put(Inplaces.Arity15_11.class, info_15_11);
        InplaceInfo info_15_12 = new InplaceInfo(15, 11);
		ALL_INPLACES.put(info_15_12, Inplaces.Arity15_12.class);
		ALL_ARITIES.put(Inplaces.Arity15_12.class, info_15_12);
        InplaceInfo info_15_13 = new InplaceInfo(15, 12);
		ALL_INPLACES.put(info_15_13, Inplaces.Arity15_13.class);
		ALL_ARITIES.put(Inplaces.Arity15_13.class, info_15_13);
        InplaceInfo info_15_14 = new InplaceInfo(15, 13);
		ALL_INPLACES.put(info_15_14, Inplaces.Arity15_14.class);
		ALL_ARITIES.put(Inplaces.Arity15_14.class, info_15_14);
        InplaceInfo info_15_15 = new InplaceInfo(15, 14);
		ALL_INPLACES.put(info_15_15, Inplaces.Arity15_15.class);
		ALL_ARITIES.put(Inplaces.Arity15_15.class, info_15_15);
        InplaceInfo info_16_1 = new InplaceInfo(16, 0);
		ALL_INPLACES.put(info_16_1, Inplaces.Arity16_1.class);
		ALL_ARITIES.put(Inplaces.Arity16_1.class, info_16_1);
        InplaceInfo info_16_2 = new InplaceInfo(16, 1);
		ALL_INPLACES.put(info_16_2, Inplaces.Arity16_2.class);
		ALL_ARITIES.put(Inplaces.Arity16_2.class, info_16_2);
        InplaceInfo info_16_3 = new InplaceInfo(16, 2);
		ALL_INPLACES.put(info_16_3, Inplaces.Arity16_3.class);
		ALL_ARITIES.put(Inplaces.Arity16_3.class, info_16_3);
        InplaceInfo info_16_4 = new InplaceInfo(16, 3);
		ALL_INPLACES.put(info_16_4, Inplaces.Arity16_4.class);
		ALL_ARITIES.put(Inplaces.Arity16_4.class, info_16_4);
        InplaceInfo info_16_5 = new InplaceInfo(16, 4);
		ALL_INPLACES.put(info_16_5, Inplaces.Arity16_5.class);
		ALL_ARITIES.put(Inplaces.Arity16_5.class, info_16_5);
        InplaceInfo info_16_6 = new InplaceInfo(16, 5);
		ALL_INPLACES.put(info_16_6, Inplaces.Arity16_6.class);
		ALL_ARITIES.put(Inplaces.Arity16_6.class, info_16_6);
        InplaceInfo info_16_7 = new InplaceInfo(16, 6);
		ALL_INPLACES.put(info_16_7, Inplaces.Arity16_7.class);
		ALL_ARITIES.put(Inplaces.Arity16_7.class, info_16_7);
        InplaceInfo info_16_8 = new InplaceInfo(16, 7);
		ALL_INPLACES.put(info_16_8, Inplaces.Arity16_8.class);
		ALL_ARITIES.put(Inplaces.Arity16_8.class, info_16_8);
        InplaceInfo info_16_9 = new InplaceInfo(16, 8);
		ALL_INPLACES.put(info_16_9, Inplaces.Arity16_9.class);
		ALL_ARITIES.put(Inplaces.Arity16_9.class, info_16_9);
        InplaceInfo info_16_10 = new InplaceInfo(16, 9);
		ALL_INPLACES.put(info_16_10, Inplaces.Arity16_10.class);
		ALL_ARITIES.put(Inplaces.Arity16_10.class, info_16_10);
        InplaceInfo info_16_11 = new InplaceInfo(16, 10);
		ALL_INPLACES.put(info_16_11, Inplaces.Arity16_11.class);
		ALL_ARITIES.put(Inplaces.Arity16_11.class, info_16_11);
        InplaceInfo info_16_12 = new InplaceInfo(16, 11);
		ALL_INPLACES.put(info_16_12, Inplaces.Arity16_12.class);
		ALL_ARITIES.put(Inplaces.Arity16_12.class, info_16_12);
        InplaceInfo info_16_13 = new InplaceInfo(16, 12);
		ALL_INPLACES.put(info_16_13, Inplaces.Arity16_13.class);
		ALL_ARITIES.put(Inplaces.Arity16_13.class, info_16_13);
        InplaceInfo info_16_14 = new InplaceInfo(16, 13);
		ALL_INPLACES.put(info_16_14, Inplaces.Arity16_14.class);
		ALL_ARITIES.put(Inplaces.Arity16_14.class, info_16_14);
        InplaceInfo info_16_15 = new InplaceInfo(16, 14);
		ALL_INPLACES.put(info_16_15, Inplaces.Arity16_15.class);
		ALL_ARITIES.put(Inplaces.Arity16_15.class, info_16_15);
        InplaceInfo info_16_16 = new InplaceInfo(16, 15);
		ALL_INPLACES.put(info_16_16, Inplaces.Arity16_16.class);
		ALL_ARITIES.put(Inplaces.Arity16_16.class, info_16_16);
	}

	/**
	 * @return {@code true} if the given type is a known
	 *         inplace type, {@code false} otherwise. <br>
	 *         Note that only the type itself and not its type hierarchy is
	 *         considered.
	 * @throws NullPointerException If {@code c} is {@code null}.
	 */
	public static boolean isInplace(Class<?> c) {
		return ALL_ARITIES.containsKey(c);
	}

	/**
	 * @param arity an {@code int} corresponding to a {@code Inplace} of that
	 *          arity.
	 * @param mutableIndex an {@code int} corresponding to a the mutable index of d
	 *          arity.
	 * @return the {@code Inplace} of arity {@code arity}.
	 * @throws IllegalArgumentException iff there is no known {@code Inplace} of
	 *           arity {@code arity}.
	 */
	public static Class<?> inplaceOfArity(int arity, int mutableIndex) {
		InplaceInfo info = new InplaceInfo(arity, mutableIndex);
		if (ALL_INPLACES.containsKey(info)) return ALL_INPLACES.get(info);
		throw new IllegalArgumentException("No Inplace of arity " + arity +
			" and mutable index " + mutableIndex);
	}

	/**
	 * @param c the {@link Class} of unknown arity
	 * @return the arity of {@code c}, or {@code -1} if {@code c} is <b>not</b> a
	 *         {@code Inplace}.
	 */
	public static InplaceInfo arityOf(Class<?> c) {
		return ALL_ARITIES.getOrDefault(c, new InplaceInfo(-1, -1));
	}

	@FunctionalInterface
	public interface Arity1<IO> extends Consumer<IO> {

		void mutate(@Mutable IO io);

		@Override
		default void accept(IO io) {
			mutate(io);
		}
	}

	@FunctionalInterface
	public interface Arity2<IO1, IO2> extends BiConsumer<IO1, IO2>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2)
		{
			mutate(io1, io2);
		}
	}

	@FunctionalInterface
	public interface Arity2_1<IO, I2> extends Arity2<IO, I2>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2);
	}

	@FunctionalInterface
	public interface Arity2_2<I1, IO> extends Arity2<I1, IO>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity3<IO1, IO2, IO3> extends Consumers.Arity3<IO1, IO2, IO3>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3)
		{
			mutate(io1, io2, io3);
		}
	}

	@FunctionalInterface
	public interface Arity3_1<IO, I2, I3> extends Arity3<IO, I2, I3>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3);
	}

	@FunctionalInterface
	public interface Arity3_2<I1, IO, I3> extends Arity3<I1, IO, I3>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3);
	}

	@FunctionalInterface
	public interface Arity3_3<I1, I2, IO> extends Arity3<I1, I2, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity4<IO1, IO2, IO3, IO4> extends Consumers.Arity4<IO1, IO2, IO3, IO4>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4)
		{
			mutate(io1, io2, io3, io4);
		}
	}

	@FunctionalInterface
	public interface Arity4_1<IO, I2, I3, I4> extends Arity4<IO, I2, I3, I4>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4);
	}

	@FunctionalInterface
	public interface Arity4_2<I1, IO, I3, I4> extends Arity4<I1, IO, I3, I4>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4);
	}

	@FunctionalInterface
	public interface Arity4_3<I1, I2, IO, I4> extends Arity4<I1, I2, IO, I4>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4);
	}

	@FunctionalInterface
	public interface Arity4_4<I1, I2, I3, IO> extends Arity4<I1, I2, I3, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity5<IO1, IO2, IO3, IO4, IO5> extends Consumers.Arity5<IO1, IO2, IO3, IO4, IO5>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5)
		{
			mutate(io1, io2, io3, io4, io5);
		}
	}

	@FunctionalInterface
	public interface Arity5_1<IO, I2, I3, I4, I5> extends Arity5<IO, I2, I3, I4, I5>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5);
	}

	@FunctionalInterface
	public interface Arity5_2<I1, IO, I3, I4, I5> extends Arity5<I1, IO, I3, I4, I5>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5);
	}

	@FunctionalInterface
	public interface Arity5_3<I1, I2, IO, I4, I5> extends Arity5<I1, I2, IO, I4, I5>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5);
	}

	@FunctionalInterface
	public interface Arity5_4<I1, I2, I3, IO, I5> extends Arity5<I1, I2, I3, IO, I5>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5);
	}

	@FunctionalInterface
	public interface Arity5_5<I1, I2, I3, I4, IO> extends Arity5<I1, I2, I3, I4, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity6<IO1, IO2, IO3, IO4, IO5, IO6> extends Consumers.Arity6<IO1, IO2, IO3, IO4, IO5, IO6>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6)
		{
			mutate(io1, io2, io3, io4, io5, io6);
		}
	}

	@FunctionalInterface
	public interface Arity6_1<IO, I2, I3, I4, I5, I6> extends Arity6<IO, I2, I3, I4, I5, I6>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6);
	}

	@FunctionalInterface
	public interface Arity6_2<I1, IO, I3, I4, I5, I6> extends Arity6<I1, IO, I3, I4, I5, I6>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6);
	}

	@FunctionalInterface
	public interface Arity6_3<I1, I2, IO, I4, I5, I6> extends Arity6<I1, I2, IO, I4, I5, I6>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6);
	}

	@FunctionalInterface
	public interface Arity6_4<I1, I2, I3, IO, I5, I6> extends Arity6<I1, I2, I3, IO, I5, I6>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6);
	}

	@FunctionalInterface
	public interface Arity6_5<I1, I2, I3, I4, IO, I6> extends Arity6<I1, I2, I3, I4, IO, I6>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6);
	}

	@FunctionalInterface
	public interface Arity6_6<I1, I2, I3, I4, I5, IO> extends Arity6<I1, I2, I3, I4, I5, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity7<IO1, IO2, IO3, IO4, IO5, IO6, IO7> extends Consumers.Arity7<IO1, IO2, IO3, IO4, IO5, IO6, IO7>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7);
		}
	}

	@FunctionalInterface
	public interface Arity7_1<IO, I2, I3, I4, I5, I6, I7> extends Arity7<IO, I2, I3, I4, I5, I6, I7>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7);
	}

	@FunctionalInterface
	public interface Arity7_2<I1, IO, I3, I4, I5, I6, I7> extends Arity7<I1, IO, I3, I4, I5, I6, I7>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7);
	}

	@FunctionalInterface
	public interface Arity7_3<I1, I2, IO, I4, I5, I6, I7> extends Arity7<I1, I2, IO, I4, I5, I6, I7>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7);
	}

	@FunctionalInterface
	public interface Arity7_4<I1, I2, I3, IO, I5, I6, I7> extends Arity7<I1, I2, I3, IO, I5, I6, I7>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7);
	}

	@FunctionalInterface
	public interface Arity7_5<I1, I2, I3, I4, IO, I6, I7> extends Arity7<I1, I2, I3, I4, IO, I6, I7>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7);
	}

	@FunctionalInterface
	public interface Arity7_6<I1, I2, I3, I4, I5, IO, I7> extends Arity7<I1, I2, I3, I4, I5, IO, I7>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7);
	}

	@FunctionalInterface
	public interface Arity7_7<I1, I2, I3, I4, I5, I6, IO> extends Arity7<I1, I2, I3, I4, I5, I6, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity8<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8> extends Consumers.Arity8<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8);
		}
	}

	@FunctionalInterface
	public interface Arity8_1<IO, I2, I3, I4, I5, I6, I7, I8> extends Arity8<IO, I2, I3, I4, I5, I6, I7, I8>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8);
	}

	@FunctionalInterface
	public interface Arity8_2<I1, IO, I3, I4, I5, I6, I7, I8> extends Arity8<I1, IO, I3, I4, I5, I6, I7, I8>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8);
	}

	@FunctionalInterface
	public interface Arity8_3<I1, I2, IO, I4, I5, I6, I7, I8> extends Arity8<I1, I2, IO, I4, I5, I6, I7, I8>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8);
	}

	@FunctionalInterface
	public interface Arity8_4<I1, I2, I3, IO, I5, I6, I7, I8> extends Arity8<I1, I2, I3, IO, I5, I6, I7, I8>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8);
	}

	@FunctionalInterface
	public interface Arity8_5<I1, I2, I3, I4, IO, I6, I7, I8> extends Arity8<I1, I2, I3, I4, IO, I6, I7, I8>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8);
	}

	@FunctionalInterface
	public interface Arity8_6<I1, I2, I3, I4, I5, IO, I7, I8> extends Arity8<I1, I2, I3, I4, I5, IO, I7, I8>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8);
	}

	@FunctionalInterface
	public interface Arity8_7<I1, I2, I3, I4, I5, I6, IO, I8> extends Arity8<I1, I2, I3, I4, I5, I6, IO, I8>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8);
	}

	@FunctionalInterface
	public interface Arity8_8<I1, I2, I3, I4, I5, I6, I7, IO> extends Arity8<I1, I2, I3, I4, I5, I6, I7, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity9<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9> extends Consumers.Arity9<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8, io9);
		}
	}

	@FunctionalInterface
	public interface Arity9_1<IO, I2, I3, I4, I5, I6, I7, I8, I9> extends Arity9<IO, I2, I3, I4, I5, I6, I7, I8, I9>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9);
	}

	@FunctionalInterface
	public interface Arity9_2<I1, IO, I3, I4, I5, I6, I7, I8, I9> extends Arity9<I1, IO, I3, I4, I5, I6, I7, I8, I9>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9);
	}

	@FunctionalInterface
	public interface Arity9_3<I1, I2, IO, I4, I5, I6, I7, I8, I9> extends Arity9<I1, I2, IO, I4, I5, I6, I7, I8, I9>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9);
	}

	@FunctionalInterface
	public interface Arity9_4<I1, I2, I3, IO, I5, I6, I7, I8, I9> extends Arity9<I1, I2, I3, IO, I5, I6, I7, I8, I9>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9);
	}

	@FunctionalInterface
	public interface Arity9_5<I1, I2, I3, I4, IO, I6, I7, I8, I9> extends Arity9<I1, I2, I3, I4, IO, I6, I7, I8, I9>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8, I9 in9);
	}

	@FunctionalInterface
	public interface Arity9_6<I1, I2, I3, I4, I5, IO, I7, I8, I9> extends Arity9<I1, I2, I3, I4, I5, IO, I7, I8, I9>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8, I9 in9);
	}

	@FunctionalInterface
	public interface Arity9_7<I1, I2, I3, I4, I5, I6, IO, I8, I9> extends Arity9<I1, I2, I3, I4, I5, I6, IO, I8, I9>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8, I9 in9);
	}

	@FunctionalInterface
	public interface Arity9_8<I1, I2, I3, I4, I5, I6, I7, IO, I9> extends Arity9<I1, I2, I3, I4, I5, I6, I7, IO, I9>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io, I9 in9);
	}

	@FunctionalInterface
	public interface Arity9_9<I1, I2, I3, I4, I5, I6, I7, I8, IO> extends Arity9<I1, I2, I3, I4, I5, I6, I7, I8, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity10<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10> extends Consumers.Arity10<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8, io9, io10);
		}
	}

	@FunctionalInterface
	public interface Arity10_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10> extends Arity10<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10> extends Arity10<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10> extends Arity10<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10> extends Arity10<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10> extends Arity10<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10> extends Arity10<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8, I9 in9, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10> extends Arity10<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8, I9 in9, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10> extends Arity10<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io, I9 in9, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10> extends Arity10<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, @Mutable IO io, I10 in10);
	}

	@FunctionalInterface
	public interface Arity10_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO> extends Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity11<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11> extends Consumers.Arity11<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8, io9, io10, io11);
		}
	}

	@FunctionalInterface
	public interface Arity11_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11> extends Arity11<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11> extends Arity11<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11> extends Arity11<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11> extends Arity11<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11> extends Arity11<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11> extends Arity11<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11> extends Arity11<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8, I9 in9, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11> extends Arity11<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io, I9 in9, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11> extends Arity11<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, @Mutable IO io, I10 in10, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11> extends Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, @Mutable IO io, I11 in11);
	}

	@FunctionalInterface
	public interface Arity11_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO> extends Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity12<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12> extends Consumers.Arity12<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8, io9, io10, io11, io12);
		}
	}

	@FunctionalInterface
	public interface Arity12_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> extends Arity12<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12> extends Arity12<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12> extends Arity12<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12> extends Arity12<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12> extends Arity12<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12> extends Arity12<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12> extends Arity12<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12> extends Arity12<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io, I9 in9, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12> extends Arity12<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, @Mutable IO io, I10 in10, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12> extends Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, @Mutable IO io, I11 in11, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12> extends Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, @Mutable IO io, I12 in12);
	}

	@FunctionalInterface
	public interface Arity12_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO> extends Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity13<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12, IO13> extends Consumers.Arity13<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12, IO13>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12, @Mutable IO13 io13);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12, @Mutable IO13 io13)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8, io9, io10, io11, io12, io13);
		}
	}

	@FunctionalInterface
	public interface Arity13_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> extends Arity13<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> extends Arity13<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13> extends Arity13<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13> extends Arity13<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13> extends Arity13<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13> extends Arity13<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13> extends Arity13<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13> extends Arity13<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13> extends Arity13<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, @Mutable IO io, I10 in10, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13> extends Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, @Mutable IO io, I11 in11, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13> extends Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, @Mutable IO io, I12 in12, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13> extends Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, @Mutable IO io, I13 in13);
	}

	@FunctionalInterface
	public interface Arity13_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO> extends Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity14<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12, IO13, IO14> extends Consumers.Arity14<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12, IO13, IO14>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12, @Mutable IO13 io13, @Mutable IO14 io14);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12, @Mutable IO13 io13, @Mutable IO14 io14)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8, io9, io10, io11, io12, io13, io14);
		}
	}

	@FunctionalInterface
	public interface Arity14_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> extends Arity14<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> extends Arity14<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> extends Arity14<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14> extends Arity14<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14> extends Arity14<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14> extends Arity14<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14> extends Arity14<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14> extends Arity14<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14> extends Arity14<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, @Mutable IO io, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14> extends Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, @Mutable IO io, I11 in11, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14> extends Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, @Mutable IO io, I12 in12, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14> extends Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, @Mutable IO io, I13 in13, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14> extends Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, @Mutable IO io, I14 in14);
	}

	@FunctionalInterface
	public interface Arity14_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO> extends Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity15<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12, IO13, IO14, IO15> extends Consumers.Arity15<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12, IO13, IO14, IO15>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12, @Mutable IO13 io13, @Mutable IO14 io14, @Mutable IO15 io15);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12, @Mutable IO13 io13, @Mutable IO14 io14, @Mutable IO15 io15)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8, io9, io10, io11, io12, io13, io14, io15);
		}
	}

	@FunctionalInterface
	public interface Arity15_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity15<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity15<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity15<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity15<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity15<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity15<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15> extends Arity15<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15> extends Arity15<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15> extends Arity15<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, @Mutable IO io, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15> extends Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, @Mutable IO io, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15> extends Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, @Mutable IO io, I12 in12, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15> extends Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, @Mutable IO io, I13 in13, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15> extends Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, @Mutable IO io, I14 in14, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15> extends Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, @Mutable IO io, I15 in15);
	}

	@FunctionalInterface
	public interface Arity15_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO> extends Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, @Mutable IO io);
	}

	@FunctionalInterface
	public interface Arity16<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12, IO13, IO14, IO15, IO16> extends Consumers.Arity16<IO1, IO2, IO3, IO4, IO5, IO6, IO7, IO8, IO9, IO10, IO11, IO12, IO13, IO14, IO15, IO16>
	{

		void mutate(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12, @Mutable IO13 io13, @Mutable IO14 io14, @Mutable IO15 io15, @Mutable IO16 io16);

		@Override
		default void accept(@Mutable IO1 io1, @Mutable IO2 io2, @Mutable IO3 io3, @Mutable IO4 io4, @Mutable IO5 io5, @Mutable IO6 io6, @Mutable IO7 io7, @Mutable IO8 io8, @Mutable IO9 io9, @Mutable IO10 io10, @Mutable IO11 io11, @Mutable IO12 io12, @Mutable IO13 io13, @Mutable IO14 io14, @Mutable IO15 io15, @Mutable IO16 io16)
		{
			mutate(io1, io2, io3, io4, io5, io6, io7, io8, io9, io10, io11, io12, io13, io14, io15, io16);
		}
	}

	@FunctionalInterface
	public interface Arity16_1<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity16<IO, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(@Mutable IO io, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_2<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity16<I1, IO, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, @Mutable IO io, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_3<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity16<I1, I2, IO, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, @Mutable IO io, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_4<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity16<I1, I2, I3, IO, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, @Mutable IO io, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_5<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity16<I1, I2, I3, I4, IO, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, @Mutable IO io, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_6<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity16<I1, I2, I3, I4, I5, IO, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, @Mutable IO io, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_7<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity16<I1, I2, I3, I4, I5, I6, IO, I8, I9, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, @Mutable IO io, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_8<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15, I16> extends Arity16<I1, I2, I3, I4, I5, I6, I7, IO, I9, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, @Mutable IO io, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_9<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15, I16> extends Arity16<I1, I2, I3, I4, I5, I6, I7, I8, IO, I10, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, @Mutable IO io, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_10<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15, I16> extends Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, IO, I11, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, @Mutable IO io, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15, I16> extends Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, IO, I12, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, @Mutable IO io, I12 in12, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15, I16> extends Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, IO, I13, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, @Mutable IO io, I13 in13, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15, I16> extends Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, IO, I14, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, @Mutable IO io, I14 in14, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15, I16> extends Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, IO, I15, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, @Mutable IO io, I15 in15, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO, I16> extends Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, IO, I16>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, @Mutable IO io, I16 in16);
	}

	@FunctionalInterface
	public interface Arity16_16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, IO> extends Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, IO>
	{

		@Override
		void mutate(I1 in1, I2 in2, I3 in3, I4 in4, I5 in5, I6 in6, I7 in7, I8 in8, I9 in9, I10 in10, I11 in11, I12 in12, I13 in13, I14 in14, I15 in15, @Mutable IO io);
	}

	public static class InplaceInfo {

		private final int arity;
		private final int mutablePosition;

		public InplaceInfo(final int arity, final int mutablePosition) {
			this.arity = arity;
			this.mutablePosition = mutablePosition;
		}

		public int arity() {
			return arity;
		}

		public int mutablePosition() {
			return mutablePosition;
		}

		@Override
		public boolean equals(Object that) {
			if (!(that instanceof InplaceInfo)) return false;
			InplaceInfo other = (InplaceInfo) that;
			return other.arity == arity && other.mutablePosition == mutablePosition;
		}

		@Override
		public int hashCode() {
			return Objects.hash(arity, mutablePosition);
		}
	}
}
