/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.PlexusContainer;
import org.scijava.maven.plugin.SciJavaDependencyChecker;
import org.scijava.maven.plugin.SciJavaDependencyException;

public final class DependencyUtils {
    public static void checkDependencies(MavenProject mavenProject, ArtifactRepository artifactRepository, DependencyTreeBuilder dependencyTreeBuilder, SciJavaDependencyChecker ... checkers) throws SciJavaDependencyException {
        DependencyUtils.checkDependencies(mavenProject, artifactRepository, dependencyTreeBuilder, "runtime", checkers);
    }

    public static void checkDependencies(MavenProject mavenProject, ArtifactRepository artifactRepository, DependencyTreeBuilder dependencyTreeBuilder, String scope, SciJavaDependencyChecker ... checkers) throws SciJavaDependencyException {
        ArtifactFilter artifactFilter = DependencyUtils.createResolvingArtifactFilter(scope);
        try {
            DependencyNode root = dependencyTreeBuilder.buildDependencyTree(mavenProject, artifactRepository, artifactFilter);
            String failureMessage = "";
            for (SciJavaDependencyChecker checker : checkers) {
                if (!root.accept((DependencyNodeVisitor)checker)) continue;
                failureMessage = failureMessage + checker.makeExceptionMessage();
            }
            if (!failureMessage.isEmpty()) {
                throw new SciJavaDependencyException(failureMessage);
            }
        }
        catch (DependencyTreeBuilderException e) {
            throw new SciJavaDependencyException(e.getMessage());
        }
    }

    public static List<MavenProject> findEffectiveReactor(List<MavenProject> defaultReactor, MavenSession session, MavenProject baseProject, MavenProjectBuilder projectBuilder, ArtifactRepository localRepository) throws ProjectBuildingException {
        HashSet<MavenProject> reactor = new HashSet<MavenProject>();
        HashSet<MavenProject> visited = new HashSet<MavenProject>();
        ProfileManager profileManager = DependencyUtils.getProfileManager(session);
        DependencyUtils.findEffectiveReactor(reactor, visited, baseProject, baseProject, projectBuilder, localRepository, profileManager);
        if (reactor.size() <= 1 || !reactor.contains(baseProject)) {
            return defaultReactor;
        }
        return new ArrayList<MavenProject>(reactor);
    }

    private static void findEffectiveReactor(Set<MavenProject> reactor, Set<MavenProject> visited, MavenProject currentProject, MavenProject target, MavenProjectBuilder projectBuilder, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        if (!visited.add(currentProject)) {
            return;
        }
        File baseDir = currentProject.getBasedir();
        if (baseDir != null && baseDir.exists()) {
            if (currentProject.getModules().size() > 0) {
                reactor.add(currentProject);
            }
            for (Object o : currentProject.getModules()) {
                File submodule = new File(baseDir.getAbsolutePath() + File.separator + o.toString() + File.separator + "pom.xml");
                MavenProject p = projectBuilder.build(submodule, localRepository, profileManager);
                reactor.add(p);
                DependencyUtils.findEffectiveReactor(reactor, visited, p, target, projectBuilder, localRepository, profileManager);
            }
        }
        if (currentProject.hasParent()) {
            DependencyUtils.findEffectiveReactor(reactor, visited, currentProject.getParent(), target, projectBuilder, localRepository, profileManager);
        }
    }

    private static ProfileManager getProfileManager(MavenSession session) {
        PlexusContainer container = session.getContainer();
        Properties execution = session.getExecutionProperties();
        return new DefaultProfileManager(container, execution);
    }

    private static ArtifactFilter createResolvingArtifactFilter(String scope) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter(scope));
        return filter;
    }
}

