/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.common3.Apps;
import org.scijava.common3.Classes;
import org.scijava.common3.URLs;
import org.scijava.common3.Versioned;
import org.scijava.meta.XML;

public class POM
extends XML
implements Comparable<POM>,
Versioned {
    private volatile String version;
    private static final Comparator<String> STRING_COMPARATOR = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<POM> POM_COMPARATOR = Comparator.comparing(POM::groupId, STRING_COMPARATOR).thenComparing(POM::artifactId, STRING_COMPARATOR).thenComparing(POM::version, POM::compareVersions);
    private static final Map<URL, POM> POMS = new HashMap<URL, POM>();

    public POM(File file) throws IOException {
        super(file);
    }

    public POM(URL url) throws IOException {
        super(url);
    }

    public POM(InputStream in) throws IOException {
        super(in);
    }

    public POM(String s) throws IOException {
        super(s);
    }

    public String parentGroupId() {
        return this.cdata("//project/parent/groupId");
    }

    public String parentArtifactId() {
        return this.cdata("//project/parent/artifactId");
    }

    public String parentVersion() {
        return this.cdata("//project/parent/version");
    }

    public String groupId() {
        String groupId = this.cdata("//project/groupId");
        if (groupId != null) {
            return groupId;
        }
        return this.parentGroupId();
    }

    public String artifactId() {
        return this.cdata("//project/artifactId");
    }

    public String projectName() {
        return this.cdata("//project/name");
    }

    public String projectDescription() {
        return this.cdata("//project/description");
    }

    public String projectURL() {
        return this.cdata("//project/url");
    }

    public String projectInceptionYear() {
        return this.cdata("//project/inceptionYear");
    }

    public String organizationName() {
        return this.cdata("//project/organization/name");
    }

    public String organizationURL() {
        return this.cdata("//project/organization/url");
    }

    public String scmConnection() {
        return this.cdata("//project/scm/connection");
    }

    public String scmDeveloperConnection() {
        return this.cdata("//project/scm/developerConnection");
    }

    public String scmTag() {
        return this.cdata("//project/scm/tag");
    }

    public String scmURL() {
        return this.cdata("//project/scm/url");
    }

    public String issueManagementSystem() {
        return this.cdata("//project/issueManagement/system");
    }

    public String issueManagementURL() {
        return this.cdata("//project/issueManagement/url");
    }

    public String ciManagementSystem() {
        return this.cdata("//project/ciManagement/system");
    }

    public String ciManagementURL() {
        return this.cdata("//project/ciManagement/url");
    }

    @Override
    public int compareTo(POM pom) {
        return POM_COMPARATOR.compare(this, pom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String version() {
        if (this.version == null) {
            POM pOM = this;
            synchronized (pOM) {
                if (this.version == null) {
                    this.version = this.cdata("//project/version");
                    if (this.version == null) {
                        this.version = this.parentVersion();
                    }
                }
            }
        }
        return this.version;
    }

    public static POM pom(Class<?> c) {
        return POM.pom(c, null, null);
    }

    public static POM pom(Class<?> c, String groupId, String artifactId) {
        URL location = Classes.location(c);
        return POMS.computeIfAbsent(location, l -> POM.findPOM(l, groupId, artifactId));
    }

    private static POM findPOM(URL location, String groupId, String artifactId) {
        try {
            if (!location.getProtocol().equals("file") || location.toString().endsWith(".jar")) {
                if (groupId == null || artifactId == null) {
                    URL pomBase = new URL("jar:" + location + "!/META-INF/maven");
                    for (URL url : URLs.listContents((URL)pomBase, (boolean)true, (boolean)true)) {
                        if (!url.toExternalForm().endsWith("/pom.xml")) continue;
                        return new POM(url);
                    }
                } else {
                    String pomPath = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml";
                    URL pomURL = new URL("jar:" + location + "!/" + pomPath);
                    return new POM(pomURL);
                }
            }
            File file = URLs.toFile((URL)location);
            File baseDir = Apps.baseDirectory((File)file, null);
            File pomFile = new File(baseDir, "pom.xml");
            return new POM(pomFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<POM> allPOMs() {
        Enumeration<URL> resources;
        String pomPrefix = "META-INF/maven/";
        ClassLoader classLoader = Classes.classLoader();
        try {
            resources = classLoader.getResources("META-INF/maven/");
        }
        catch (IOException exc) {
            return null;
        }
        ArrayList<POM> poms = new ArrayList<POM>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            for (URL url : URLs.listContents((URL)resource)) {
                if (!url.getPath().endsWith("/pom.xml")) continue;
                try {
                    poms.add(new POM(url));
                }
                catch (IOException iOException) {}
            }
        }
        return poms;
    }

    public static int compareVersions(String v1, String v2) {
        String[] t1 = v1.split("[^\\w]");
        String[] t2 = v2.split("[^\\w]");
        int size = Math.min(t1.length, t2.length);
        for (int i = 0; i < size; ++i) {
            try {
                long n1 = Long.parseLong(t1[i]);
                long n2 = Long.parseLong(t2[i]);
                if (n1 < n2) {
                    return -1;
                }
                if (n1 <= n2) continue;
                return 1;
            }
            catch (NumberFormatException exc) {
                int result = t1[i].compareTo(t2[i]);
                if (result == 0) continue;
                return result;
            }
        }
        if (t1.length == t2.length) {
            return 0;
        }
        if (v1.startsWith(v2) && v1.charAt(v2.length()) == '-') {
            return -1;
        }
        if (v2.startsWith(v1) && v2.charAt(v1.length()) == '-') {
            return 1;
        }
        return t1.length < t2.length ? -1 : 1;
    }
}

