/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlMetaType;

class SqlMetaConst
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Code caseConversion;
    private boolean not;
    private List<String> elements;
    private SqlType sqlType;
    Map<String, String> values = new HashMap<String, String>();

    SqlMetaConst(SqlInputValue.Code caseConversion) {
        this(caseConversion, false);
    }

    SqlMetaConst(SqlInputValue.Code caseConversion, boolean not) {
        this(caseConversion, false, new SqlType());
    }

    SqlMetaConst(SqlInputValue.Code caseConversion, boolean not, SqlType type) {
        this.elements = new ArrayList<String>();
        this.caseConversion = caseConversion;
        this.not = not;
        this.sqlType = type;
    }

    void addConst(String name) {
        String[] names = name.split("=");
        this.elements.add(names[0]);
    }

    void setMetaType(SqlMetaType metaType) {
        this.sqlType = new SqlType(metaType);
    }

    public void setValues(String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            this.sqlType.setValue(value);
        } else {
            this.values.put(value, value2);
        }
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public void setElements(List<String> elements) {
        this.elements = elements;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        String defaultInputValue;
        Object obj;
        SqlProcessResult result;
        block20: {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(">>> process : inputValues=" + this.getInputValues(ctx) + ", class=" + (this.getInputValues(ctx) != null ? this.getInputValues(ctx).getClass() : null) + ", sqlType=" + this.sqlType);
            }
            result = new SqlProcessResult();
            obj = null;
            Object parentObj = null;
            String attributeName = null;
            if (this.getInputValues(ctx) != null) {
                obj = this.getInputValues(ctx);
                Class<?> attributeType = obj != null ? obj.getClass() : null;
                Iterator<String> i$ = this.elements.iterator();
                while (i$.hasNext()) {
                    String item;
                    attributeName = item = i$.next();
                    if (attributeType != null) {
                        Class<?> origAttributeType = attributeType;
                        if ((attributeType = this.getFieldType(ctx, attributeType, attributeName)) == null) {
                            if (SqlProcessContext.isFeature("IGNORE_INPROPER_IN")) {
                                this.logger.error("There's no attribute '" + attributeName + "' for " + origAttributeType);
                            } else {
                                throw new SqlRuntimeException("There's no attribute '" + attributeName + "' for " + origAttributeType);
                            }
                        }
                    }
                    if (obj == null) continue;
                    parentObj = obj;
                    obj = this.getProperty(ctx, obj, item);
                }
            }
            defaultInputValue = obj == null ? this.getDefaultData() : null;
            try {
                if (defaultInputValue != null) {
                    result.add(true);
                    break block20;
                }
                result.add(SqlProcessContext.getPluginFactory().getIsEmptyPlugin().isNotEmpty(attributeName, obj, parentObj, this.sqlType == null ? null : this.sqlType.getMetaType(), this.sqlType == null ? null : this.sqlType.getValue(), ctx.inSqlSetOrInsert, this.values, ctx.getFeatures()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Input value " + attributeName + ", failed reason" + e.getMessage());
            }
        }
        if (obj != null) {
            if (obj instanceof Collection) {
                boolean notEmpty;
                boolean bl = notEmpty = !((Collection)obj).isEmpty();
                if (!notEmpty && this.sqlType != null && this.sqlType.getValue() != null && this.sqlType.getValue().toLowerCase().equals("anyset")) {
                    result.setSql(new StringBuilder("(null)"));
                } else {
                    StringBuilder s = new StringBuilder(notEmpty ? "(" : "");
                    Iterator i = ((Collection)obj).iterator();
                    while (i.hasNext()) {
                        Object objItem = i.next();
                        if (objItem != null) {
                            s.append(this.getData(objItem));
                        } else {
                            s.append("null");
                        }
                        if (!i.hasNext()) continue;
                        s.append(',');
                    }
                    if (notEmpty) {
                        s.append(')');
                    }
                    result.setSql(s);
                }
            } else {
                result.setSql(new StringBuilder(this.getData(obj)));
            }
        } else {
            result.setSql(new StringBuilder(defaultInputValue != null ? defaultInputValue : ""));
        }
        return result;
    }

    String getData(Object obj) {
        if (obj instanceof String) {
            if (this.caseConversion == SqlInputValue.Code.UPPER) {
                return "'" + obj.toString().toUpperCase() + "'";
            }
            if (this.caseConversion == SqlInputValue.Code.LOWER) {
                return "'" + obj.toString().toLowerCase() + "'";
            }
            return "'" + obj.toString() + "'";
        }
        if (obj.getClass().isEnum() && this.sqlType != null) {
            if (this.sqlType.getMetaType() == SqlProcessContext.getTypeFactory().getEnumStringType()) {
                Object o = SqlUtils.getEnumToValue(obj);
                if (o != null && o instanceof String) {
                    return "'" + (String)o + "'";
                }
                return "'" + obj.toString() + "'";
            }
            if (this.sqlType.getMetaType() == SqlProcessContext.getTypeFactory().getEnumIntegerType()) {
                Object o = SqlUtils.getEnumToValue(obj);
                if (o != null) {
                    return o.toString();
                }
                return obj.toString();
            }
            if (this.sqlType.getMetaType() == SqlProcessContext.getTypeFactory().getDefaultType()) {
                Object o = SqlUtils.getEnumToValue(obj);
                if (o != null && o instanceof Integer) {
                    return o.toString();
                }
                if (o != null && o instanceof String) {
                    return "'" + o + "'";
                }
                return obj.toString();
            }
            return obj.toString();
        }
        return obj.toString();
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> processExpression : inputValues=" + this.getInputValues(ctx) + ", class=" + (this.getInputValues(ctx) != null ? this.getInputValues(ctx).getClass() : null) + ", sqlType=" + this.sqlType);
        }
        Object parentObj = null;
        Object obj = null;
        String attributeName = null;
        if (this.getInputValues(ctx) != null) {
            obj = this.getInputValues(ctx);
            Iterator<String> i$ = this.elements.iterator();
            while (i$.hasNext()) {
                String item;
                attributeName = item = i$.next();
                if (obj == null) continue;
                parentObj = obj;
                obj = BeanUtils.getProperty(obj, item);
            }
        }
        boolean result = SqlProcessContext.getPluginFactory().getIsTruePlugin().isTrue(attributeName, obj, parentObj, this.sqlType == null ? null : this.sqlType.getMetaType(), this.sqlType == null ? null : this.sqlType.getValue(), this.values, SqlProcessContext.getFeatures());
        return this.not ? !result : result;
    }

    Object getInputValues(SqlProcessContext ctx) {
        return ctx.staticInputValues;
    }

    String getDefaultData() {
        return null;
    }

    Class<?> getFieldType(SqlProcessContext ctx, Class<?> attributeType, String attributeName) {
        return BeanUtils.getFieldType(attributeType, attributeName);
    }

    Object getProperty(SqlProcessContext ctx, Object obj, String item) {
        return BeanUtils.getProperty(obj, item);
    }
}

