/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlClobType;

public class JdbcClobType
extends SqlClobType
implements JdbcSqlType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Clob.class};
    }

    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return 2005;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return rs.getClob(Integer.parseInt(columnLabel));
        }
        return rs.getClob(columnLabel);
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        Clob clob = (Clob)value;
        st.setClob(index, clob);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Clob result = cs.getClob(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

