/*
 * Decompiled with CFR 0.152.
 */
package co.dapi.types;

import co.dapi.types.Currency;
import java.util.Optional;

public class CategorizedTransaction {
    private final float amount;
    private final String date;
    private final TransactionType type;
    private final String description;
    private final String details;
    private final Currency currency;
    private final Float beforeAmount;
    private final Float afterAmount;
    private final String reference;
    private final String category;

    public CategorizedTransaction(float amount, String date, TransactionType type, String description, String details, Currency currency, Float beforeAmount, Float afterAmount, String reference, String category) {
        this.amount = amount;
        this.date = date;
        this.type = type;
        this.description = description;
        this.details = details;
        this.currency = currency;
        this.beforeAmount = beforeAmount;
        this.afterAmount = afterAmount;
        this.reference = reference;
        this.category = category;
    }

    public float getAmount() {
        return this.amount;
    }

    public String getDate() {
        return this.date;
    }

    public TransactionType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetails() {
        return this.details;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Optional<Float> getBeforeAmount() {
        return Optional.ofNullable(this.beforeAmount);
    }

    public Optional<Float> getAfterAmount() {
        return Optional.ofNullable(this.afterAmount);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public Optional<String> getCategory() {
        return Optional.ofNullable(this.category);
    }

    public static enum TransactionType {
        credit,
        debit;

    }
}

