/*
 * Decompiled with CFR 0.152.
 */
package com.algorithmia.development;

import com.algorithmia.development.AbstractAlgorithm;
import com.algorithmia.development.FindApply;
import com.algorithmia.development.RequestHandler;
import com.algorithmia.development.ResponseHandler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;

public class Handler<INPUT, OUTPUT> {
    private AbstractAlgorithm<INPUT, OUTPUT> implementation;
    private RequestHandler<INPUT> in;
    private ResponseHandler out = new ResponseHandler();

    public Handler(AbstractAlgorithm<INPUT, OUTPUT> abstractAlgorithm) {
        this.implementation = abstractAlgorithm;
        Class<INPUT> clazz = this.getInputClass(abstractAlgorithm);
        this.in = new RequestHandler<INPUT>(clazz);
    }

    private void load() {
        this.implementation.load();
        System.out.println("PIPE_INIT_COMPLETE");
        System.out.flush();
    }

    private void execute() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Stream<String> stream = bufferedReader.lines();
        this.load();
        stream.forEach(string -> {
            INPUT INPUT = this.in.processRequest((String)string);
            OUTPUT OUTPUT = this.implementation.apply(INPUT);
            this.out.writeToPipe(OUTPUT);
        });
    }

    private Class<INPUT> getInputClass(AbstractAlgorithm<INPUT, OUTPUT> abstractAlgorithm) {
        Method[] methodArray = abstractAlgorithm.getClass().getMethods();
        Class<?> clazz = null;
        for (Method method : methodArray) {
            if (AnnotationUtils.findAnnotation((Method)method, FindApply.class) == null) continue;
            clazz = method.getParameterTypes()[0];
            if (method.getReturnType() == Object.class) continue;
            return clazz;
        }
        if (clazz != null) {
            return clazz;
        }
        throw new RuntimeException("Unable to find the 'public' method reference called 'apply' in the provided class.");
    }

    public void serve() {
        try {
            this.execute();
        }
        catch (RuntimeException runtimeException) {
            this.out.writeErrorToPipe(runtimeException);
        }
    }
}

