/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.local;

import com.browserstack.local.LocalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

class LocalBinary {
    private static final String BIN_URL = "https://bstack-local-prod.s3.amazonaws.com/";
    private String httpPath;
    private String binaryPath;
    private boolean isOSWindows;
    private final String[] orderedPaths = new String[]{System.getProperty("user.home") + "/.browserstack", System.getProperty("user.dir"), System.getProperty("java.io.tmpdir")};

    LocalBinary() throws LocalException {
        this.initialize();
        this.getBinary();
        this.checkBinary();
    }

    private void initialize() throws LocalException {
        String binFileName;
        String osname = System.getProperty("os.name").toLowerCase();
        this.isOSWindows = osname.contains("windows");
        if (this.isOSWindows) {
            binFileName = "BrowserStackLocal.exe";
        } else if (osname.contains("mac") || osname.contains("darwin")) {
            binFileName = "BrowserStackLocal-darwin-x64";
        } else if (osname.contains("linux")) {
            if (this.isAlpine()) {
                binFileName = "BrowserStackLocal-alpine";
            } else {
                String arch = System.getProperty("os.arch");
                binFileName = "BrowserStackLocal-linux-" + (arch.contains("64") ? "x64" : "ia32");
            }
        } else {
            throw new LocalException("Failed to detect OS type");
        }
        this.httpPath = BIN_URL + binFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlpine() {
        String[] cmd = new String[]{"/bin/sh", "-c", "grep -w \"NAME\" /etc/os-release"};
        boolean flag = false;
        try {
            Process os = Runtime.getRuntime().exec(cmd);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(os.getInputStream()));
            flag = stdout.readLine().contains("Alpine");
            return flag;
        }
        finally {
            return flag;
        }
    }

    private void checkBinary() throws LocalException {
        boolean binaryWorking = this.validateBinary();
        if (!binaryWorking) {
            File binary_file = new File(this.binaryPath);
            if (binary_file.exists()) {
                binary_file.delete();
            }
            this.getBinary();
            if (!this.validateBinary()) {
                throw new LocalException("BrowserStackLocal binary is corrupt");
            }
        }
    }

    private boolean validateBinary() throws LocalException {
        try {
            Process process = new ProcessBuilder(this.binaryPath, "--version").start();
            BufferedReader stdoutbr = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String stdout = "";
            String line = "";
            while ((line = stdoutbr.readLine()) != null) {
                stdout = stdout + line;
            }
            process.waitFor();
            boolean validBinary = Pattern.matches("BrowserStack Local version \\d+\\.\\d+", stdout);
            return validBinary;
        }
        catch (IOException ex) {
            throw new LocalException(ex.toString());
        }
        catch (InterruptedException ex) {
            throw new LocalException(ex.toString());
        }
    }

    private void getBinary() throws LocalException {
        String destParentDir = this.getAvailableDirectory();
        this.binaryPath = destParentDir + "/BrowserStackLocal";
        if (this.isOSWindows) {
            this.binaryPath = this.binaryPath + ".exe";
        }
        if (!new File(this.binaryPath).exists()) {
            this.downloadBinary(destParentDir);
        }
    }

    private String getAvailableDirectory() throws LocalException {
        for (int i = 0; i < this.orderedPaths.length; ++i) {
            String path = this.orderedPaths[i];
            if (!this.makePath(path)) continue;
            return path;
        }
        throw new LocalException("Error trying to download BrowserStackLocal binary");
    }

    private boolean makePath(String path) {
        try {
            if (!new File(path).exists()) {
                new File(path).mkdirs();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void downloadBinary(String destParentDir) throws LocalException {
        try {
            if (!new File(destParentDir).exists()) {
                new File(destParentDir).mkdirs();
            }
            URL url = new URL(this.httpPath);
            String source = destParentDir + "/BrowserStackLocal";
            if (this.isOSWindows) {
                source = source + ".exe";
            }
            File f = new File(source);
            FileUtils.copyURLToFile((URL)url, (File)f);
            this.changePermissions(this.binaryPath);
        }
        catch (Exception e) {
            throw new LocalException("Error trying to download BrowserStackLocal binary");
        }
    }

    private void changePermissions(String path) {
        File f = new File(path);
        f.setExecutable(true, true);
        f.setReadable(true, true);
        f.setWritable(true, true);
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }
}

