/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.local;

import com.browserstack.local.LocalBinary;
import com.browserstack.local.LocalException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Local {
    private static final List<String> IGNORE_KEYS = Arrays.asList("key", "binarypath");
    List<String> command;
    Map<String, String> startOptions;
    String binaryPath;
    int pid = 0;
    private LocalProcess proc = null;
    private final String packageVersion = "1.0.9";
    private final Map<String, String> parameters;
    private final Map<String, String> avoidValueParameters = new HashMap<String, String>();

    public Local() {
        this.avoidValueParameters.put("v", "-vvv");
        this.avoidValueParameters.put("force", "-force");
        this.avoidValueParameters.put("forcelocal", "-forcelocal");
        this.avoidValueParameters.put("onlyAutomate", "-onlyAutomate");
        this.avoidValueParameters.put("forceproxy", "-forceproxy");
        this.parameters = new HashMap<String, String>();
        this.parameters.put("f", "-f");
        this.parameters.put("only", "-only");
        this.parameters.put("localIdentifier", "-localIdentifier");
        this.parameters.put("proxyHost", "-proxyHost");
        this.parameters.put("proxyPort", "-proxyPort");
        this.parameters.put("proxyUser", "-proxyUser");
        this.parameters.put("proxyPass", "-proxyPass");
    }

    public void start(Map<String, String> options) throws Exception {
        this.startOptions = options;
        if (options.get("binarypath") != null) {
            this.binaryPath = options.get("binarypath");
        } else {
            LocalBinary lb = new LocalBinary();
            this.binaryPath = lb.getBinaryPath();
        }
        this.makeCommand(options, "start");
        if (options.get("onlyCommand") != null) {
            return;
        }
        if (this.proc == null) {
            String line;
            this.proc = this.runCommand(this.command);
            BufferedReader stdoutbr = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            BufferedReader stderrbr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
            String stdout = "";
            String stderr = "";
            while ((line = stdoutbr.readLine()) != null) {
                stdout = stdout + line;
            }
            while ((line = stderrbr.readLine()) != null) {
                stderr = stderr + line;
            }
            int r = this.proc.waitFor();
            JSONObject obj = new JSONObject(!stdout.equals("") ? stdout : stderr);
            if (!obj.getString("state").equals("connected")) {
                throw new LocalException(obj.getJSONObject("message").getString("message"));
            }
            this.pid = obj.getInt("pid");
        }
    }

    public void stop() throws Exception {
        if (this.pid != 0) {
            this.makeCommand(this.startOptions, "stop");
            this.proc = this.runCommand(this.command);
            this.proc.waitFor();
            this.pid = 0;
        }
    }

    public void stop(Map<String, String> options) throws Exception {
        if (options.get("binarypath") != null) {
            this.binaryPath = options.get("binarypath");
        } else {
            LocalBinary lb = new LocalBinary();
            this.binaryPath = lb.getBinaryPath();
        }
        this.makeCommand(options, "stop");
        this.proc = this.runCommand(this.command);
        this.proc.waitFor();
        this.pid = 0;
    }

    public boolean isRunning() throws Exception {
        if (this.pid == 0) {
            return false;
        }
        return this.isProcessRunning(this.pid);
    }

    private void makeCommand(Map<String, String> options, String opCode) {
        this.command = new ArrayList<String>();
        this.command.add(this.binaryPath);
        this.command.add("-d");
        this.command.add(opCode);
        this.command.add("--key");
        this.command.add(options.get("key"));
        this.command.add("--source");
        this.command.add("java-1.0.9");
        for (Map.Entry<String, String> opt : options.entrySet()) {
            String parameter = opt.getKey().trim();
            if (IGNORE_KEYS.contains(parameter)) continue;
            if (this.avoidValueParameters.get(parameter) != null && opt.getValue().trim().toLowerCase() != "false") {
                this.command.add(this.avoidValueParameters.get(parameter));
                continue;
            }
            if (this.parameters.get(parameter) != null) {
                this.command.add(this.parameters.get(parameter));
            } else {
                this.command.add("-" + parameter);
            }
            if (opt.getValue() == null) continue;
            this.command.add(opt.getValue().trim());
        }
    }

    private boolean isProcessRunning(int pid) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add("\"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"");
        } else {
            cmd.add("/bin/sh");
            cmd.add("-c");
            cmd.add("ps");
            cmd.add("-o");
            cmd.add("pid=");
            cmd.add("|");
            cmd.add("grep");
            cmd.add("-w");
            cmd.add(String.valueOf(pid));
        }
        this.proc = this.runCommand(cmd);
        int exitValue = this.proc.waitFor();
        return exitValue == 0;
    }

    protected LocalProcess runCommand(List<String> command) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        final Process process = processBuilder.start();
        return new LocalProcess(){

            @Override
            public InputStream getInputStream() {
                return process.getInputStream();
            }

            @Override
            public InputStream getErrorStream() {
                return process.getErrorStream();
            }

            @Override
            public int waitFor() throws Exception {
                return process.waitFor();
            }
        };
    }

    public static interface LocalProcess {
        public InputStream getInputStream();

        public InputStream getErrorStream();

        public int waitFor() throws Exception;
    }
}

