/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.local;

import com.browserstack.local.Local;
import com.browserstack.local.LocalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

class LocalBinary {
    private String binaryFileName;
    private String sourceUrl;
    private String binaryPath;
    private Boolean fallbackEnabled = false;
    private Throwable downloadFailureThrowable = null;
    private String key;
    private boolean isOSWindows;
    private final String[] orderedPaths = new String[]{System.getProperty("user.home") + "/.browserstack", System.getProperty("user.dir"), System.getProperty("java.io.tmpdir")};

    LocalBinary(String path, String key) throws LocalException {
        this.key = key;
        this.initialize();
        this.downloadAndVerifyBinary(path);
    }

    private void downloadAndVerifyBinary(String path) throws LocalException {
        try {
            if (path != "") {
                this.getBinaryOnPath(path);
            } else {
                this.getBinary();
            }
            this.checkBinary();
        }
        catch (Throwable e) {
            if (this.fallbackEnabled.booleanValue()) {
                throw e;
            }
            File binary_file = new File(this.binaryPath);
            if (binary_file.exists()) {
                binary_file.delete();
            }
            this.fallbackEnabled = true;
            this.downloadFailureThrowable = e;
            this.downloadAndVerifyBinary(path);
        }
    }

    private void initialize() throws LocalException {
        String binFileName;
        String osname = System.getProperty("os.name").toLowerCase();
        this.isOSWindows = osname.contains("windows");
        if (this.isOSWindows) {
            binFileName = "BrowserStackLocal.exe";
        } else if (osname.contains("mac") || osname.contains("darwin")) {
            binFileName = "BrowserStackLocal-darwin-x64";
        } else if (osname.contains("linux")) {
            String arch = System.getProperty("os.arch");
            binFileName = arch.contains("64") ? (this.isAlpine() ? "BrowserStackLocal-alpine" : "BrowserStackLocal-linux-x64") : "BrowserStackLocal-linux-ia32";
        } else {
            throw new LocalException("Failed to detect OS type");
        }
        this.binaryFileName = binFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlpine() {
        String[] cmd = new String[]{"/bin/sh", "-c", "grep -w \"NAME\" /etc/os-release"};
        boolean flag = false;
        try {
            Process os = Runtime.getRuntime().exec(cmd);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(os.getInputStream()));
            flag = stdout.readLine().contains("Alpine");
            return flag;
        }
        finally {
            return flag;
        }
    }

    private void checkBinary() throws LocalException {
        boolean binaryWorking = this.validateBinary();
        if (!binaryWorking) {
            File binary_file = new File(this.binaryPath);
            if (binary_file.exists()) {
                binary_file.delete();
            }
            this.getBinary();
            if (!this.validateBinary()) {
                throw new LocalException("BrowserStackLocal binary is corrupt");
            }
        }
    }

    private boolean validateBinary() throws LocalException {
        try {
            Process process = new ProcessBuilder(this.binaryPath, "--version").start();
            BufferedReader stdoutbr = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String stdout = "";
            String line = "";
            while ((line = stdoutbr.readLine()) != null) {
                stdout = stdout + line;
            }
            process.waitFor();
            boolean validBinary = Pattern.matches("BrowserStack Local version \\d+\\.\\d+", stdout);
            return validBinary;
        }
        catch (IOException ex) {
            throw new LocalException(ex.toString());
        }
        catch (InterruptedException ex) {
            throw new LocalException(ex.toString());
        }
    }

    private void getBinaryOnPath(String path) throws LocalException {
        this.binaryPath = path;
        if (!new File(this.binaryPath).exists()) {
            this.downloadBinary(this.binaryPath, true);
        }
    }

    private void getBinary() throws LocalException {
        String destParentDir = this.getAvailableDirectory();
        this.binaryPath = destParentDir + "/BrowserStackLocal";
        if (this.isOSWindows) {
            this.binaryPath = this.binaryPath + ".exe";
        }
        if (!new File(this.binaryPath).exists()) {
            this.downloadBinary(destParentDir, false);
        }
    }

    private String getAvailableDirectory() throws LocalException {
        for (int i = 0; i < this.orderedPaths.length; ++i) {
            String path = this.orderedPaths[i];
            if (!this.makePath(path)) continue;
            return path;
        }
        throw new LocalException("Error trying to download BrowserStackLocal binary");
    }

    private boolean makePath(String path) {
        try {
            if (!new File(path).exists()) {
                new File(path).mkdirs();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void fetchSourceUrl() throws LocalException {
        if (!this.fallbackEnabled.booleanValue() && this.sourceUrl != null || this.fallbackEnabled.booleanValue() && this.downloadFailureThrowable == null) {
            return;
        }
        try {
            URL url = new URL("https://local.browserstack.com/binary/api/v1/endpoint");
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "browserstack-local-java/" + Local.getPackageVersion());
            connection.setRequestProperty("Accept", "application/json");
            JSONObject inputParams = new JSONObject();
            inputParams.put("auth_token", (Object)this.key);
            if (this.fallbackEnabled.booleanValue()) {
                connection.setRequestProperty("X-Local-Fallback-Cloudflare", "true");
                inputParams.put("error_message", (Object)this.downloadFailureThrowable.getMessage());
            }
            String jsonInputParams = inputParams.toString();
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonInputParams.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            var6_7 = null;
            try (InputStream is = connection.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line.trim());
                }
                String responseBody = response.toString();
                JSONObject json = new JSONObject(responseBody);
                if (json.has("error")) {
                    throw new Exception(json.getString("error"));
                }
                this.sourceUrl = json.getJSONObject("data").getString("endpoint");
                if (this.fallbackEnabled.booleanValue()) {
                    this.downloadFailureThrowable = null;
                }
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new LocalException("Error trying to fetch the source URL: " + e.getMessage());
        }
    }

    private void downloadBinary(String destParentDir, Boolean custom) throws LocalException {
        try {
            this.fetchSourceUrl();
            String source = destParentDir;
            if (!custom.booleanValue()) {
                if (!new File(destParentDir).exists()) {
                    new File(destParentDir).mkdirs();
                }
                source = destParentDir + "/BrowserStackLocal";
                if (this.isOSWindows) {
                    source = source + ".exe";
                }
            }
            URL url = new URL(this.sourceUrl + '/' + this.binaryFileName);
            File f = new File(source);
            LocalBinary.newCopyToFile(url, f);
            this.changePermissions(this.binaryPath);
        }
        catch (Throwable e) {
            throw new LocalException("Error trying to download BrowserStackLocal binary: " + e.getMessage());
        }
    }

    private void changePermissions(String path) {
        File f = new File(path);
        f.setExecutable(true, true);
        f.setReadable(true, true);
        f.setWritable(true, true);
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    private static void newCopyToFile(URL url, File f) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("User-Agent", "browserstack-local-java/" + Local.getPackageVersion());
        conn.setRequestProperty("Accept-Encoding", "gzip, *");
        String contentEncoding = conn.getContentEncoding();
        if (contentEncoding == null || !contentEncoding.toLowerCase().contains("gzip")) {
            LocalBinary.customCopyInputStreamToFile(conn.getInputStream(), f, url);
            return;
        }
        try (GZIPInputStream stream = new GZIPInputStream(conn.getInputStream());){
            if (System.getenv().containsKey("BROWSERSTACK_LOCAL_DEBUG_GZIP")) {
                System.out.println("using gzip in " + conn.getRequestProperty("User-Agent"));
            }
            LocalBinary.customCopyInputStreamToFile(stream, f, url);
        }
        catch (ZipException e) {
            FileUtils.copyURLToFile((URL)url, (File)f);
        }
    }

    private static void customCopyInputStreamToFile(InputStream stream, File file, URL url) throws IOException {
        try {
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
        }
        catch (Throwable e) {
            try (FileOutputStream fos = new FileOutputStream(file);){
                IOUtils.copy((InputStream)stream, (OutputStream)fos);
            }
            catch (Throwable th) {
                FileUtils.copyURLToFile((URL)url, (File)file);
            }
        }
    }
}

