/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;
import com.codedx.client.model.FileMapping;
import com.codedx.client.model.MappingsRequest;
import com.codedx.client.model.Project;
import com.codedx.client.model.ProjectFile;
import com.codedx.client.model.ProjectQuery;
import com.codedx.client.model.ProjectQueryResponse;
import com.codedx.client.model.Projects;
import com.codedx.client.model.Roles;
import com.codedx.client.model.Status;
import com.codedx.client.model.UpdateProject;
import com.codedx.client.model.UserRole;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectsApi {
    private ApiClient apiClient;

    public ProjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createProjectCall(Project project, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Project project2 = project;
        String string = "/api/projects";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "PUT", arrayList, arrayList2, project2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createProjectValidateBeforeCall(Project project, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (project == null) {
            throw new ApiException("Missing the required parameter 'project' when calling createProject(Async)");
        }
        Call call = this.createProjectCall(project, progressListener, progressRequestListener);
        return call;
    }

    public void createProject(Project project) throws ApiException {
        this.createProjectWithHttpInfo(project);
    }

    public ApiResponse<Void> createProjectWithHttpInfo(Project project) throws ApiException {
        Call call = this.createProjectValidateBeforeCall(project, null, null);
        return this.apiClient.execute(call);
    }

    public Call createProjectAsync(Project project, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createProjectValidateBeforeCall(project, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call deleteProjectCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/projects/{project-id}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "DELETE", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deleteProjectValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling deleteProject(Async)");
        }
        Call call = this.deleteProjectCall(n, progressListener, progressRequestListener);
        return call;
    }

    public void deleteProject(Integer n) throws ApiException {
        this.deleteProjectWithHttpInfo(n);
    }

    public ApiResponse<Void> deleteProjectWithHttpInfo(Integer n) throws ApiException {
        Call call = this.deleteProjectValidateBeforeCall(n, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteProjectAsync(Integer n, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deleteProjectValidateBeforeCall(n, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call getAllUserRolesCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/projects/{project-id}/user-roles".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getAllUserRolesValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getAllUserRoles(Async)");
        }
        Call call = this.getAllUserRolesCall(n, progressListener, progressRequestListener);
        return call;
    }

    public List<UserRole> getAllUserRoles(Integer n) throws ApiException {
        ApiResponse<List<UserRole>> apiResponse = this.getAllUserRolesWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<List<UserRole>> getAllUserRolesWithHttpInfo(Integer n) throws ApiException {
        Call call = this.getAllUserRolesValidateBeforeCall(n, null, null);
        Type type = new TypeToken<List<UserRole>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getAllUserRolesAsync(Integer n, final ApiCallback<List<UserRole>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getAllUserRolesValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<List<UserRole>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getMappingsCall(Integer n, MappingsRequest mappingsRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MappingsRequest mappingsRequest2 = mappingsRequest;
        String string = "/api/projects/{project-id}/files/mappings".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, mappingsRequest2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getMappingsValidateBeforeCall(Integer n, MappingsRequest mappingsRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getMappings(Async)");
        }
        if (mappingsRequest == null) {
            throw new ApiException("Missing the required parameter 'request' when calling getMappings(Async)");
        }
        Call call = this.getMappingsCall(n, mappingsRequest, progressListener, progressRequestListener);
        return call;
    }

    public Map<String, FileMapping> getMappings(Integer n, MappingsRequest mappingsRequest) throws ApiException {
        ApiResponse<Map<String, FileMapping>> apiResponse = this.getMappingsWithHttpInfo(n, mappingsRequest);
        return apiResponse.getData();
    }

    public ApiResponse<Map<String, FileMapping>> getMappingsWithHttpInfo(Integer n, MappingsRequest mappingsRequest) throws ApiException {
        Call call = this.getMappingsValidateBeforeCall(n, mappingsRequest, null, null);
        Type type = new TypeToken<Map<String, FileMapping>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getMappingsAsync(Integer n, MappingsRequest mappingsRequest, final ApiCallback<Map<String, FileMapping>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getMappingsValidateBeforeCall(n, mappingsRequest, progressListener, progressRequestListener);
        Type type = new TypeToken<Map<String, FileMapping>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getProjectFilesCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/projects/{project-id}/files".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getProjectFilesValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProjectFiles(Async)");
        }
        Call call = this.getProjectFilesCall(n, progressListener, progressRequestListener);
        return call;
    }

    public List<ProjectFile> getProjectFiles(Integer n) throws ApiException {
        ApiResponse<List<ProjectFile>> apiResponse = this.getProjectFilesWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<List<ProjectFile>> getProjectFilesWithHttpInfo(Integer n) throws ApiException {
        Call call = this.getProjectFilesValidateBeforeCall(n, null, null);
        Type type = new TypeToken<List<ProjectFile>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getProjectFilesAsync(Integer n, final ApiCallback<List<ProjectFile>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getProjectFilesValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<List<ProjectFile>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getProjectsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/projects";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getProjectsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getProjectsCall(progressListener, progressRequestListener);
        return call;
    }

    public Projects getProjects() throws ApiException {
        ApiResponse<Projects> apiResponse = this.getProjectsWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<Projects> getProjectsWithHttpInfo() throws ApiException {
        Call call = this.getProjectsValidateBeforeCall(null, null);
        Type type = new TypeToken<Projects>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getProjectsAsync(final ApiCallback<Projects> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getProjectsValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<Projects>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getStatusesCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/projects/{project-id}/statuses".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getStatusesValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getStatuses(Async)");
        }
        Call call = this.getStatusesCall(n, progressListener, progressRequestListener);
        return call;
    }

    public Map<String, Status> getStatuses(Integer n) throws ApiException {
        ApiResponse<Map<String, Status>> apiResponse = this.getStatusesWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<Map<String, Status>> getStatusesWithHttpInfo(Integer n) throws ApiException {
        Call call = this.getStatusesValidateBeforeCall(n, null, null);
        Type type = new TypeToken<Map<String, Status>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getStatusesAsync(Integer n, final ApiCallback<Map<String, Status>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getStatusesValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<Map<String, Status>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getUserRoleCall(Integer n, Integer n2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string = "/api/projects/{project-id}/user-roles/user/{user-id}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{user-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getUserRoleValidateBeforeCall(Integer n, Integer n2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getUserRole(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUserRole(Async)");
        }
        Call call = this.getUserRoleCall(n, n2, progressListener, progressRequestListener);
        return call;
    }

    public UserRole getUserRole(Integer n, Integer n2) throws ApiException {
        ApiResponse<UserRole> apiResponse = this.getUserRoleWithHttpInfo(n, n2);
        return apiResponse.getData();
    }

    public ApiResponse<UserRole> getUserRoleWithHttpInfo(Integer n, Integer n2) throws ApiException {
        Call call = this.getUserRoleValidateBeforeCall(n, n2, null, null);
        Type type = new TypeToken<UserRole>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getUserRoleAsync(Integer n, Integer n2, final ApiCallback<UserRole> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getUserRoleValidateBeforeCall(n, n2, progressListener, progressRequestListener);
        Type type = new TypeToken<UserRole>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call queryProjectsCall(ProjectQuery projectQuery, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ProjectQuery projectQuery2 = projectQuery;
        String string = "/api/projects/query";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, projectQuery2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call queryProjectsValidateBeforeCall(ProjectQuery projectQuery, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectQuery == null) {
            throw new ApiException("Missing the required parameter 'query' when calling queryProjects(Async)");
        }
        Call call = this.queryProjectsCall(projectQuery, progressListener, progressRequestListener);
        return call;
    }

    public List<ProjectQueryResponse> queryProjects(ProjectQuery projectQuery) throws ApiException {
        ApiResponse<List<ProjectQueryResponse>> apiResponse = this.queryProjectsWithHttpInfo(projectQuery);
        return apiResponse.getData();
    }

    public ApiResponse<List<ProjectQueryResponse>> queryProjectsWithHttpInfo(ProjectQuery projectQuery) throws ApiException {
        Call call = this.queryProjectsValidateBeforeCall(projectQuery, null, null);
        Type type = new TypeToken<List<ProjectQueryResponse>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call queryProjectsAsync(ProjectQuery projectQuery, final ApiCallback<List<ProjectQueryResponse>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.queryProjectsValidateBeforeCall(projectQuery, progressListener, progressRequestListener);
        Type type = new TypeToken<List<ProjectQueryResponse>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call queryProjectsCountCall(ProjectQuery projectQuery, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ProjectQuery projectQuery2 = projectQuery;
        String string = "/api/projects/query/count";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, projectQuery2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call queryProjectsCountValidateBeforeCall(ProjectQuery projectQuery, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectQuery == null) {
            throw new ApiException("Missing the required parameter 'query' when calling queryProjectsCount(Async)");
        }
        Call call = this.queryProjectsCountCall(projectQuery, progressListener, progressRequestListener);
        return call;
    }

    public void queryProjectsCount(ProjectQuery projectQuery) throws ApiException {
        this.queryProjectsCountWithHttpInfo(projectQuery);
    }

    public ApiResponse<Void> queryProjectsCountWithHttpInfo(ProjectQuery projectQuery) throws ApiException {
        Call call = this.queryProjectsCountValidateBeforeCall(projectQuery, null, null);
        return this.apiClient.execute(call);
    }

    public Call queryProjectsCountAsync(ProjectQuery projectQuery, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.queryProjectsCountValidateBeforeCall(projectQuery, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call updateProjectCall(Integer n, UpdateProject updateProject, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateProject updateProject2 = updateProject;
        String string = "/api/projects/{project-id}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "PUT", arrayList, arrayList2, updateProject2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call updateProjectValidateBeforeCall(Integer n, UpdateProject updateProject, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling updateProject(Async)");
        }
        if (updateProject == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateProject(Async)");
        }
        Call call = this.updateProjectCall(n, updateProject, progressListener, progressRequestListener);
        return call;
    }

    public void updateProject(Integer n, UpdateProject updateProject) throws ApiException {
        this.updateProjectWithHttpInfo(n, updateProject);
    }

    public ApiResponse<Void> updateProjectWithHttpInfo(Integer n, UpdateProject updateProject) throws ApiException {
        Call call = this.updateProjectValidateBeforeCall(n, updateProject, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateProjectAsync(Integer n, UpdateProject updateProject, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.updateProjectValidateBeforeCall(n, updateProject, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call updateUserRoleCall(Integer n, Integer n2, Roles roles, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Roles roles2 = roles;
        String string = "/api/projects/{project-id}/user-roles/user/{user-id}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{user-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "PUT", arrayList, arrayList2, roles2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call updateUserRoleValidateBeforeCall(Integer n, Integer n2, Roles roles, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling updateUserRole(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling updateUserRole(Async)");
        }
        if (roles == null) {
            throw new ApiException("Missing the required parameter 'request' when calling updateUserRole(Async)");
        }
        Call call = this.updateUserRoleCall(n, n2, roles, progressListener, progressRequestListener);
        return call;
    }

    public void updateUserRole(Integer n, Integer n2, Roles roles) throws ApiException {
        this.updateUserRoleWithHttpInfo(n, n2, roles);
    }

    public ApiResponse<Void> updateUserRoleWithHttpInfo(Integer n, Integer n2, Roles roles) throws ApiException {
        Call call = this.updateUserRoleValidateBeforeCall(n, n2, roles, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateUserRoleAsync(Integer n, Integer n2, Roles roles, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.updateUserRoleValidateBeforeCall(n, n2, roles, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }
}

