/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.service;

import com.codeupsoft.component.security.handler.SecurityAuthenticateAfterHandler;
import com.codeupsoft.component.security.handler.SecurityOauthAuthenticateHandler;
import com.codeupsoft.component.security.service.model.LoginUser;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.authentication.AuthenticationServiceException;

public class SecurityOauthAuthenticateService
implements InitializingBean,
ApplicationContextAware {
    private final Map<String, SecurityOauthAuthenticateHandler> handlers = new HashMap<String, SecurityOauthAuthenticateHandler>();
    private ApplicationContext applicationContext;

    public LoginUser authenticate(String grantType, HttpServletRequest request) {
        if (!this.handlers.containsKey(grantType)) {
            throw new AuthenticationServiceException(String.format("Unsupported grant type: %s", grantType));
        }
        LoginUser authenticate = this.handlers.get(grantType).authenticate(request);
        authenticate.setGrantType(grantType);
        this.applicationContext.getBeansOfType(SecurityAuthenticateAfterHandler.class).forEach((k, v) -> v.handler(authenticate));
        return authenticate;
    }

    public void afterPropertiesSet() throws Exception {
        Map handlerMap = this.applicationContext.getBeansOfType(SecurityOauthAuthenticateHandler.class);
        handlerMap.values().forEach(h -> this.handlers.put(h.getGrantType(), (SecurityOauthAuthenticateHandler)h));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Generated
    public SecurityOauthAuthenticateService() {
    }
}

