/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.filter;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.codeupsoft.base.common.response.R;
import com.codeupsoft.component.security.properties.ComponentSecurityProperties;
import com.codeupsoft.component.security.service.SecurityAuthenticateService;
import com.codeupsoft.component.security.service.SecurityAuthenticateUserService;
import com.codeupsoft.component.security.service.model.LoginUser;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.HtmlUtils;

public class SecurityControllerFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityControllerFilter.class);
    private final ComponentSecurityProperties componentSecurityProperties;
    private final SecurityAuthenticateService securityAuthenticateService;
    private final SecurityAuthenticateUserService securityAuthenticateUserService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (Objects.equals(this.componentSecurityProperties.getLoginUrl(), HtmlUtils.htmlEscape((String)request.getRequestURI()))) {
            Map requestParams;
            try {
                String read = IoUtil.read((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
                requestParams = (Map)JSONObject.parseObject((String)read, Map.class);
            }
            catch (Exception e) {
                log.error("[ Login ] {} ", (Object)e.getMessage(), (Object)e);
                R error = R.error((int)HttpStatus.BAD_REQUEST.value(), (String)HttpStatus.BAD_REQUEST.getReasonPhrase());
                response.setContentType("application/json;charset=UTF-8");
                response.getWriter().write(JSONObject.toJSONString((Object)error, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
                return;
            }
            LoginUser loginUser = this.securityAuthenticateService.authenticate(requestParams);
            String token = this.securityAuthenticateUserService.createToken(loginUser);
            response.setContentType("application/json;charset=UTF-8");
            response.setStatus(HttpStatus.OK.value());
            response.getWriter().write(JSONObject.toJSONString((Object)R.success((Object)token), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public SecurityControllerFilter(ComponentSecurityProperties componentSecurityProperties, SecurityAuthenticateService securityAuthenticateService, SecurityAuthenticateUserService securityAuthenticateUserService) {
        this.componentSecurityProperties = componentSecurityProperties;
        this.securityAuthenticateService = securityAuthenticateService;
        this.securityAuthenticateUserService = securityAuthenticateUserService;
    }
}

