/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.service;

import com.codeupsoft.component.security.properties.ComponentSecurityProperties;
import com.codeupsoft.component.security.service.model.LoginUser;
import com.codeupsoft.component.security.utils.SecurityUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class PermissionService {
    private final ComponentSecurityProperties componentSecurityProperties;

    private boolean isAdmin(LoginUser loginUser) {
        if (Objects.isNull(loginUser)) {
            return false;
        }
        return loginUser.getRoles().contains(this.componentSecurityProperties.getSuperRole());
    }

    public boolean isAdmin() {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (Objects.isNull(loginUser)) {
            return false;
        }
        return this.isAdmin(loginUser);
    }

    public boolean hasAdminRole(Set<String> roles) {
        return roles.contains(this.componentSecurityProperties.getSuperRole());
    }

    private boolean hasAllPermission(LoginUser loginUser) {
        if (Objects.isNull(loginUser)) {
            return false;
        }
        return loginUser.getPermissions().contains(this.componentSecurityProperties.getSuperPermission());
    }

    public boolean hasPermission(String permission) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (Objects.isNull(loginUser)) {
            return false;
        }
        if (this.isAdmin(loginUser) || this.hasAllPermission(loginUser)) {
            return true;
        }
        return loginUser.getPermissions().contains(permission);
    }

    public boolean hasAnyPermission(String ... permissions) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (Objects.isNull(loginUser)) {
            return false;
        }
        if (Objects.isNull(permissions) || permissions.length == 0) {
            return false;
        }
        if (this.isAdmin(loginUser) || this.hasAllPermission(loginUser)) {
            return true;
        }
        return Arrays.stream(permissions).anyMatch(loginUser.getPermissions()::contains);
    }

    public boolean hasRole(String role) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (Objects.isNull(loginUser)) {
            return false;
        }
        if (this.isAdmin(loginUser)) {
            return true;
        }
        return loginUser.getRoles().contains(role);
    }

    public boolean hasAnyRole(String ... roles) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (Objects.isNull(loginUser)) {
            return false;
        }
        if (Objects.isNull(roles) || roles.length == 0) {
            return false;
        }
        if (this.isAdmin(loginUser)) {
            return true;
        }
        return Arrays.stream(roles).anyMatch(loginUser.getRoles()::contains);
    }

    public String getAllPermissionCode() {
        return this.componentSecurityProperties.getSuperPermission();
    }

    @Generated
    public PermissionService(ComponentSecurityProperties componentSecurityProperties) {
        this.componentSecurityProperties = componentSecurityProperties;
    }
}

