/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test;

import com.codingapi.test.config.TestConfig;
import com.codingapi.test.runner.DefaultMongoRunner;
import com.codingapi.test.runner.DefaultRelationalDbRunner;
import com.codingapi.test.runner.DefaultTestCheck;
import com.codingapi.test.runner.DefaultTestClear;
import com.codingapi.test.runner.DefaultTestPrepare;
import com.codingapi.test.runner.IMongoRunner;
import com.codingapi.test.runner.IRelationalDbRunner;
import com.codingapi.test.runner.ITestCheck;
import com.codingapi.test.runner.ITestClear;
import com.codingapi.test.runner.ITestPrepare;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@ComponentScan
@Configuration
public class TestConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TestConfig testConfig() {
        return new TestConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public ITestPrepare testPrepare() {
        return new DefaultTestPrepare();
    }

    @Bean
    @ConditionalOnMissingBean
    public ITestClear testClear() {
        return new DefaultTestClear();
    }

    @Bean
    @ConditionalOnMissingBean
    public ITestCheck testCheck() {
        return new DefaultTestCheck();
    }

    @Configuration
    @ConditionalOnClass(name={"javax.sql.DataSource"})
    class RelationalDbRunnerAutoConfiguration {
        RelationalDbRunnerAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public IRelationalDbRunner relationalDbRunner() {
            return new DefaultRelationalDbRunner();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.data.mongodb.core.MongoTemplate"})
    class MongoRunnerAutoConfiguration {
        MongoRunnerAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public IMongoRunner mongoRunner() {
            return new DefaultMongoRunner();
        }
    }
}

