/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test.listener;

import com.codingapi.test.annotation.TestMethod;
import com.codingapi.test.runner.ITestCheck;
import com.codingapi.test.runner.ITestClear;
import com.codingapi.test.runner.ITestPrepare;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class JunitMethodListener
extends AbstractTestExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(JunitMethodListener.class);

    public void beforeTestMethod(TestContext testContext) throws Exception {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        Method jdkMethod = testContext.getTestMethod();
        if (jdkMethod == null) {
            return;
        }
        TestMethod testMethod = jdkMethod.getAnnotation(TestMethod.class);
        if (testMethod == null) {
            return;
        }
        if (testMethod.enablePrepare()) {
            ITestPrepare testPrepare = (ITestPrepare)applicationContext.getBean(ITestPrepare.class);
            testPrepare.prepare(testMethod, testContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestMethod(TestContext testContext) throws Exception {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        boolean hasException = testContext.getTestException() != null;
        Method jdkMethod = testContext.getTestMethod();
        if (jdkMethod == null) {
            return;
        }
        TestMethod testMethod = jdkMethod.getAnnotation(TestMethod.class);
        if (testMethod == null) {
            return;
        }
        try {
            if (testMethod.enableCheck() && !hasException) {
                ITestCheck testCheck = (ITestCheck)applicationContext.getBean(ITestCheck.class);
                testCheck.check(testMethod, testContext);
            }
        }
        finally {
            if (testMethod.enableClear()) {
                ITestClear testClear = (ITestClear)applicationContext.getBean(ITestClear.class);
                testClear.clean(testMethod, testContext);
            }
        }
    }
}

