/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.persistence;

import com.codingapi.springboot.framework.handler.IHandler;
import com.codingapi.springboot.framework.persistence.IPersistence;
import com.codingapi.springboot.framework.persistence.IPersistenceRepository;
import com.codingapi.springboot.framework.persistence.PersistenceEvent;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceHandler
implements IHandler<PersistenceEvent> {
    private static final Logger log = LoggerFactory.getLogger(PersistenceHandler.class);
    private List<IPersistenceRepository> persistenceList;

    public PersistenceHandler(List<IPersistenceRepository> persistenceList) {
        this.persistenceList = persistenceList == null ? new ArrayList<IPersistenceRepository>() : persistenceList;
    }

    private Class<?> persistenceType(Class<?> persistenceClazz) {
        Type[] types;
        for (Type type : types = persistenceClazz.getGenericInterfaces()) {
            Class clazz;
            if (type instanceof Class) {
                return this.persistenceType((Class)type);
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments == null || !IPersistence.class.isAssignableFrom(clazz = (Class)actualTypeArguments[0])) continue;
            return clazz;
        }
        return null;
    }

    private void eachPersistence(Object obj) {
        for (IPersistenceRepository persistence : this.persistenceList) {
            Class<?> clazz = this.persistenceType(persistence.getClass());
            if (clazz == null || !clazz.equals(obj.getClass())) continue;
            persistence.persistenceHandler(obj);
        }
    }

    @Override
    public void handler(PersistenceEvent event) {
        Object obj = event.getVal();
        log.debug("handler persistence event obj:{}", obj);
        this.eachPersistence(obj);
    }
}

