/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.security.configurer;

import com.codingapi.springboot.security.filter.AuthenticationTokenFilter;
import com.codingapi.springboot.security.filter.MyAuthenticationFilter;
import com.codingapi.springboot.security.filter.MyLoginFilter;
import com.codingapi.springboot.security.filter.SecurityLoginHandler;
import com.codingapi.springboot.security.gateway.TokenGateway;
import com.codingapi.springboot.security.properties.CodingApiSecurityProperties;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.DefaultSecurityFilterChain;

public class HttpSecurityConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final TokenGateway tokenGateway;
    private final SecurityLoginHandler securityLoginHandler;
    private final CodingApiSecurityProperties securityJwtProperties;
    private final AuthenticationTokenFilter authenticationTokenFilter;

    public void configure(HttpSecurity security) throws Exception {
        AuthenticationManager manager = (AuthenticationManager)security.getSharedObject(AuthenticationManager.class);
        security.addFilter((Filter)new MyLoginFilter(manager, this.tokenGateway, this.securityLoginHandler, this.securityJwtProperties));
        security.addFilter((Filter)new MyAuthenticationFilter(manager, this.securityJwtProperties, this.tokenGateway, this.authenticationTokenFilter));
    }

    @Generated
    public HttpSecurityConfigurer(TokenGateway tokenGateway, SecurityLoginHandler securityLoginHandler, CodingApiSecurityProperties securityJwtProperties, AuthenticationTokenFilter authenticationTokenFilter) {
        this.tokenGateway = tokenGateway;
        this.securityLoginHandler = securityLoginHandler;
        this.securityJwtProperties = securityJwtProperties;
        this.authenticationTokenFilter = authenticationTokenFilter;
    }
}

