/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.security.redis;

import com.alibaba.fastjson2.JSONObject;
import com.codingapi.springboot.security.gateway.Token;
import com.codingapi.springboot.security.redis.SecurityRedisProperties;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisTokenGateway {
    private final RedisTemplate<String, String> redisTemplate;
    private final int validTime;
    private final int restTime;

    public RedisTokenGateway(RedisTemplate<String, String> redisTemplate, SecurityRedisProperties properties) {
        this.redisTemplate = redisTemplate;
        this.validTime = properties.getValidTime();
        this.restTime = properties.getRestTime();
    }

    public Token create(String username, String iv, List<String> authorities, String extra) {
        Token token = new Token(username, iv, extra, authorities, this.validTime, this.restTime);
        String key = String.format("%s:%s", username, UUID.randomUUID().toString().replaceAll("-", ""));
        token.setToken(key);
        this.redisTemplate.opsForValue().set((Object)key, (Object)token.toJson(), (long)this.validTime, TimeUnit.MILLISECONDS);
        return token;
    }

    public Token parser(String sign) {
        String json = (String)this.redisTemplate.opsForValue().get((Object)sign);
        if (json == null) {
            return null;
        }
        return (Token)JSONObject.parseObject((String)json, Token.class);
    }

    public void removeToken(String token) {
        this.redisTemplate.delete((Object)token);
    }

    public void removeUsername(String username) {
        Set keys = this.redisTemplate.keys((Object)(username + ":*"));
        if (keys != null && !keys.isEmpty()) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public void removeUsername(String username, Predicate<Token> predicate) {
        Set keys = this.redisTemplate.keys((Object)(username + ":*"));
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                Token token = this.parser(key);
                if (token == null || !predicate.test(token)) continue;
                this.redisTemplate.delete((Object)key);
            }
        }
    }
}

