/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.framework.dto.request.Filter;
import com.codingapi.springboot.framework.dto.request.PageRequest;
import com.codingapi.springboot.framework.dto.request.Relation;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SearchRequest {
    private int current;
    private int pageSize;
    private final HttpServletRequest request;
    private final List<String> removeKeys = new ArrayList<String>();
    private final PageRequest pageRequest;

    public SearchRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        this.request = attributes.getRequest();
        this.pageRequest = new PageRequest();
    }

    public void setCurrent(int current) {
        this.current = current - 1;
        this.removeKeys.add("current");
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.removeKeys.add("pageSize");
    }

    public void addSort(Sort sort) {
        this.pageRequest.addSort(sort);
    }

    public void removeFilter(String key) {
        this.pageRequest.removeFilter(key);
        this.removeKeys.add(key);
    }

    public String getParameter(String key) {
        return this.request.getParameter(key);
    }

    public String[] getParameterValues(String key) {
        return this.request.getParameterValues(key);
    }

    public List<String> getParameterNames() {
        Enumeration enumeration = this.request.getParameterNames();
        ArrayList<String> list = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            list.add((String)enumeration.nextElement());
        }
        return list;
    }

    public PageRequest addFilter(String key, Relation relation, Object ... value) {
        return this.pageRequest.addFilter(key, relation, value);
    }

    public PageRequest addFilter(String key, Object ... value) {
        return this.pageRequest.addFilter(key, value);
    }

    public PageRequest andFilter(Filter ... filters) {
        return this.pageRequest.andFilter(filters);
    }

    public PageRequest orFilters(Filter ... filters) {
        return this.pageRequest.orFilters(filters);
    }

    private String decode(String value) {
        return new String(Base64.getDecoder().decode(value));
    }

    private List<ParamOperation> loadParamOperations() {
        String params = this.request.getParameter("params");
        if (StringUtils.hasLength((String)params) && JSON.isValid((String)(params = this.decode(params)))) {
            this.removeKeys.add("params");
            return JSON.parseArray((String)params, ParamOperation.class);
        }
        return null;
    }

    public PageRequest toPageRequest(Class<?> clazz) {
        String filter;
        this.pageRequest.setCurrent(this.current);
        this.pageRequest.setPageSize(this.pageSize);
        ClassContent content = new ClassContent(clazz, this.pageRequest);
        List<ParamOperation> loadParams = this.loadParamOperations();
        String sort = this.request.getParameter("sort");
        if (StringUtils.hasLength((String)sort) && JSON.isValid((String)(sort = this.decode(sort)))) {
            this.removeKeys.add("sort");
            JSONObject jsonObject = JSON.parseObject((String)sort);
            for (String key2 : jsonObject.keySet()) {
                String value = jsonObject.getString(key2);
                if ("ascend".equals(value)) {
                    this.pageRequest.addSort(Sort.by((String[])new String[]{key2}).ascending());
                    continue;
                }
                this.pageRequest.addSort(Sort.by((String[])new String[]{key2}).descending());
            }
        }
        if (StringUtils.hasLength((String)(filter = this.request.getParameter("filter"))) && JSON.isValid((String)(filter = this.decode(filter)))) {
            this.removeKeys.add("filter");
            JSONObject jsonObject = JSON.parseObject((String)filter);
            for (String key3 : jsonObject.keySet()) {
                JSONArray value = jsonObject.getJSONArray(key3);
                if (value == null || value.isEmpty()) continue;
                List<String> values = value.stream().map(Object::toString).toList();
                content.addFilter(key3, values);
            }
        }
        this.request.getParameterNames().asIterator().forEachRemaining(key -> {
            String value;
            if (!this.removeKeys.contains(key) && StringUtils.hasLength((String)(value = this.request.getParameter(key)))) {
                if (loadParams != null) {
                    ParamOperation operation = loadParams.stream().filter(paramOperation -> paramOperation.getKey().equals(key)).findFirst().orElse(null);
                    if (operation != null) {
                        content.addFilter((String)key, operation.getOperation(), value);
                    } else {
                        content.addFilter((String)key, value);
                    }
                } else {
                    content.addFilter((String)key, value);
                }
            }
        });
        return this.pageRequest;
    }

    @Generated
    public int getCurrent() {
        return this.current;
    }

    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    static class ParamOperation {
        private String key;
        private String type;

        ParamOperation() {
        }

        public Relation getOperation() {
            return Relation.valueOf(this.type);
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getType() {
            return this.type;
        }
    }

    static class ClassContent {
        private final Class<?> clazz;
        private final PageRequest pageRequest;

        public ClassContent(Class<?> clazz, PageRequest pageRequest) {
            this.clazz = clazz;
            this.pageRequest = pageRequest;
        }

        public void addFilter(String key, Relation relation, String value) {
            Class<?> keyClass = this.getKeyType(key);
            Object v = this.parseObject(value, keyClass);
            this.pageRequest.addFilter(key, relation, v);
        }

        public void addFilter(String key, String value) {
            Class<?> keyClass = this.getKeyType(key);
            Object v = this.parseObject(value, keyClass);
            this.pageRequest.addFilter(key, Relation.EQUAL, v);
        }

        private Object parseObject(String value, Class<?> keyClass) {
            if (value.getClass().equals(keyClass)) {
                return value;
            }
            return JSON.parseObject((String)value, keyClass);
        }

        public void addFilter(String key, List<String> value) {
            Class<?> keyClass = this.getKeyType(key);
            this.pageRequest.addFilter(key, Relation.IN, value.stream().map(v -> this.parseObject((String)v, keyClass)).toArray());
        }

        private Class<?> getKeyType(String key) {
            String[] keys = key.split("\\.");
            Class<?> keyClass = this.clazz;
            for (String k : keys) {
                if ((keyClass = this.findFieldInHierarchy(keyClass, k)) != null) continue;
                throw new IllegalArgumentException("Field " + k + " not found in class hierarchy.");
            }
            return keyClass;
        }

        private Class<?> findFieldInHierarchy(Class<?> clazz, String fieldName) {
            for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = currentClass.getDeclaredFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    return field.getType();
                }
            }
            return null;
        }
    }
}

