/*
 * Decompiled with CFR 0.152.
 */
package com.compdfkit.client;

import com.compdfkit.client.CPDFHttpClient;
import com.compdfkit.enums.CPDFConversionEnum;
import com.compdfkit.enums.CPDFDocumentAIEnum;
import com.compdfkit.enums.CPDFDocumentEditorEnum;
import com.compdfkit.param.CPDFFileParameter;
import com.compdfkit.pojo.comPdfKit.CPDFCreateTaskResult;
import com.compdfkit.pojo.comPdfKit.CPDFFileInfo;
import com.compdfkit.pojo.comPdfKit.CPDFOauthResult;
import com.compdfkit.pojo.comPdfKit.CPDFTaskInfoResult;
import com.compdfkit.pojo.comPdfKit.CPDFTaskRecordsResult;
import com.compdfkit.pojo.comPdfKit.CPDFTenantAssetResult;
import com.compdfkit.pojo.comPdfKit.CPDFTool;
import com.compdfkit.pojo.comPdfKit.CPDFUploadFileResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

public class CPDFClient {
    private final CPDFHttpClient httpClient;

    public CPDFClient(String publicKey, String secretKey) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        restTemplateBuilder.setReadTimeout(Duration.ofSeconds(300L));
        restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(300L));
        restTemplateBuilder.setBufferRequestBody(false);
        RestTemplate restTemplate = restTemplateBuilder.build();
        this.httpClient = new CPDFHttpClient(restTemplate, publicKey, secretKey);
    }

    public CPDFClient(String publicKey, String secretKey, Long readTimeout, Long connectTimeout) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        restTemplateBuilder.setReadTimeout(Duration.ofSeconds(readTimeout));
        restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(connectTimeout));
        restTemplateBuilder.setBufferRequestBody(false);
        RestTemplate restTemplate = restTemplateBuilder.build();
        this.httpClient = new CPDFHttpClient(restTemplate, publicKey, secretKey);
        this.httpClient.refreshAccessToken();
    }

    private CPDFOauthResult getComPdfKitAuth(String publicKey, String secretKey) {
        return this.httpClient.getComPdfKitAuth(publicKey, secretKey);
    }

    public List<CPDFTool> getTools() {
        return this.httpClient.getTools();
    }

    public CPDFFileInfo getFileInfo(String fileKey) {
        return this.httpClient.getFileInfo(fileKey, null);
    }

    public CPDFFileInfo getFileInfo(String fileKey, Integer language) {
        return this.httpClient.getFileInfo(fileKey, language);
    }

    public CPDFTenantAssetResult getAssetInfo() {
        return this.httpClient.getAssetInfo();
    }

    public CPDFTaskRecordsResult getTaskList(String page, String size) {
        return this.httpClient.getTaskList(page, size);
    }

    public CPDFCreateTaskResult createTask(String executeTypeUrl) {
        return this.httpClient.createTask(executeTypeUrl, null);
    }

    public CPDFCreateTaskResult createTask(String executeTypeUrl, Integer language) {
        return this.httpClient.createTask(executeTypeUrl, language);
    }

    public CPDFCreateTaskResult createTask(CPDFConversionEnum conversionEnum) {
        return this.createTask(conversionEnum.getValue());
    }

    public CPDFCreateTaskResult createTask(CPDFConversionEnum conversionEnum, Integer language) {
        return this.createTask(conversionEnum.getValue(), language);
    }

    public CPDFCreateTaskResult createTask(CPDFDocumentEditorEnum documentEditorEnum) {
        return this.createTask(documentEditorEnum.getValue());
    }

    public CPDFCreateTaskResult createTask(CPDFDocumentEditorEnum documentEditorEnum, Integer language) {
        return this.createTask(documentEditorEnum.getValue(), language);
    }

    public CPDFCreateTaskResult createTask(CPDFDocumentAIEnum documentAIEnum) {
        return this.createTask(documentAIEnum.getValue());
    }

    public CPDFCreateTaskResult createTask(CPDFDocumentAIEnum documentAIEnum, Integer language) {
        return this.createTask(documentAIEnum.getValue(), language);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, String password) {
        return this.getUploadFileResult(file, taskId, password, null);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, String password, Integer language) {
        return this.getUploadFileResult(file, taskId, password, null, language);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String password, String fileName) {
        return this.getUploadFileResult(file, taskId, password, null, fileName);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String password, String fileName, Integer language) {
        return this.getUploadFileResult(file, taskId, password, null, fileName, language);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String password, String fileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, null, fileName);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String password, String fileName, Integer language) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, null, fileName, language);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, String password) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, null, file.getOriginalFilename());
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, String password, Integer language) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, null, file.getOriginalFilename(), language);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId) {
        return this.getUploadFileResult(file, taskId, null, null);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, Integer language) {
        return this.getUploadFileResult(file, taskId, null, null, language);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String fileName) {
        return this.getUploadFileResult(file, taskId, null, null, fileName);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String fileName, Integer language) {
        return this.getUploadFileResult(file, taskId, null, null, fileName, language);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String fileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, null, fileName);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String fileName, Integer language) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, null, fileName, language);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, null, file.getOriginalFilename());
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, Integer language) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, null, file.getOriginalFilename(), language);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, String password, CPDFFileParameter fileParameter) {
        return this.getUploadFileResult(file, taskId, password, fileParameter);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, String password, CPDFFileParameter fileParameter, Integer language) {
        return this.getUploadFileResult(file, taskId, password, fileParameter, language);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, String password, CPDFFileParameter fileParameter, File imageFile) throws FileNotFoundException {
        return this.getUploadFileResult(file, taskId, password, fileParameter, new FileInputStream(imageFile), imageFile.getName());
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, String password, CPDFFileParameter fileParameter, File imageFile, Integer language) throws FileNotFoundException {
        return this.getUploadFileResult(file, taskId, password, fileParameter, new FileInputStream(imageFile), imageFile.getName(), language);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, String password, CPDFFileParameter fileParameter, URL imageFile, String imageFileName) throws IOException {
        return this.getUploadFileResult(file, taskId, password, fileParameter, imageFile.openConnection().getInputStream(), imageFileName);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, String password, CPDFFileParameter fileParameter, URL imageFile, String imageFileName, Integer language) throws IOException {
        return this.getUploadFileResult(file, taskId, password, fileParameter, imageFile.openConnection().getInputStream(), imageFileName, language);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName) {
        return this.getUploadFileResult(file, taskId, password, fileParameter, fileName);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, Integer language) {
        return this.getUploadFileResult(file, taskId, password, fileParameter, fileName, language);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, File imageFile) throws FileNotFoundException {
        return this.getUploadFileResult(file, taskId, password, fileParameter, fileName, new FileInputStream(imageFile), imageFile.getName());
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, File imageFile, Integer language) throws FileNotFoundException {
        return this.getUploadFileResult(file, taskId, password, fileParameter, fileName, new FileInputStream(imageFile), imageFile.getName(), language);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, URL imageFile, String imageFileName) throws IOException {
        return this.getUploadFileResult(file, taskId, password, fileParameter, fileName, imageFile.openConnection().getInputStream(), imageFileName);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, URL imageFile, String imageFileName, Integer language) throws IOException {
        return this.getUploadFileResult(file, taskId, password, fileParameter, fileName, imageFile.openConnection().getInputStream(), imageFileName, language);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String password, CPDFFileParameter fileParameter, String fileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, fileParameter, fileName);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, Integer language) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, fileParameter, fileName, language);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, File imageFile) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, fileParameter, fileName, new FileInputStream(imageFile), imageFile.getName());
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, File imageFile, Integer language) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, fileParameter, fileName, new FileInputStream(imageFile), imageFile.getName(), language);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, URL imageFile, String imageFileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, fileParameter, fileName, imageFile.openConnection().getInputStream(), imageFileName);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, URL imageFile, String imageFileName, Integer language) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, password, fileParameter, fileName, imageFile.openConnection().getInputStream(), imageFileName, language);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, String password, CPDFFileParameter fileParameter) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, fileParameter, file.getOriginalFilename());
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, String password, CPDFFileParameter fileParameter, Integer language) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, fileParameter, file.getOriginalFilename(), language);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, String password, CPDFFileParameter fileParameter, File imageFile) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, fileParameter, file.getOriginalFilename(), new FileInputStream(imageFile), imageFile.getName());
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, String password, CPDFFileParameter fileParameter, File imageFile, Integer language) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, fileParameter, file.getOriginalFilename(), new FileInputStream(imageFile), imageFile.getName(), language);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, String password, CPDFFileParameter fileParameter, URL imageFile, String imageFileName) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, fileParameter, file.getOriginalFilename(), imageFile.openConnection().getInputStream(), imageFileName);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, String password, CPDFFileParameter fileParameter, URL imageFile, String imageFileName, Integer language) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, password, fileParameter, file.getOriginalFilename(), imageFile.openConnection().getInputStream(), imageFileName, language);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, CPDFFileParameter fileParameter) {
        return this.getUploadFileResult(file, taskId, null, fileParameter);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, CPDFFileParameter fileParameter, Integer language) {
        return this.getUploadFileResult(file, taskId, null, fileParameter, language);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, CPDFFileParameter fileParameter, File imageFile) throws IOException {
        return this.getUploadFileResult(file, taskId, null, fileParameter, new FileInputStream(imageFile), imageFile.getName());
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, CPDFFileParameter fileParameter, File imageFile, Integer language) throws IOException {
        return this.getUploadFileResult(file, taskId, null, fileParameter, new FileInputStream(imageFile), imageFile.getName(), language);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, CPDFFileParameter fileParameter, URL imageFile, String imageFileName) throws IOException {
        return this.getUploadFileResult(file, taskId, null, fileParameter, imageFile.openConnection().getInputStream(), imageFileName);
    }

    public CPDFUploadFileResult uploadFile(File file, String taskId, CPDFFileParameter fileParameter, URL imageFile, String imageFileName, Integer language) throws IOException {
        return this.getUploadFileResult(file, taskId, null, fileParameter, imageFile.openConnection().getInputStream(), imageFileName, language);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, CPDFFileParameter fileParameter, String fileName) {
        return this.getUploadFileResult(file, taskId, null, fileParameter, fileName);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, CPDFFileParameter fileParameter, String fileName, Integer language) {
        return this.getUploadFileResult(file, taskId, null, fileParameter, fileName, language);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, CPDFFileParameter fileParameter, String fileName, File imageFile) throws IOException {
        return this.getUploadFileResult(file, taskId, null, fileParameter, fileName, new FileInputStream(imageFile), imageFile.getName());
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, CPDFFileParameter fileParameter, String fileName, File imageFile, Integer language) throws IOException {
        return this.getUploadFileResult(file, taskId, null, fileParameter, fileName, new FileInputStream(imageFile), imageFile.getName(), language);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, CPDFFileParameter fileParameter, String fileName, URL imageFile, String imageFileName) throws IOException {
        return this.getUploadFileResult(file, taskId, null, fileParameter, fileName, imageFile.openConnection().getInputStream(), imageFileName);
    }

    public CPDFUploadFileResult uploadFile(InputStream file, String taskId, CPDFFileParameter fileParameter, String fileName, URL imageFile, String imageFileName, Integer language) throws IOException {
        return this.getUploadFileResult(file, taskId, null, fileParameter, fileName, imageFile.openConnection().getInputStream(), imageFileName, language);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, CPDFFileParameter fileParameter, String fileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, fileParameter, fileName);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, CPDFFileParameter fileParameter, String fileName, Integer language) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, fileParameter, fileName, language);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, CPDFFileParameter fileParameter, String fileName, File imageFile) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, fileParameter, fileName, new FileInputStream(imageFile), imageFile.getName());
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, CPDFFileParameter fileParameter, String fileName, File imageFile, Integer language) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, fileParameter, fileName, new FileInputStream(imageFile), imageFile.getName(), language);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, CPDFFileParameter fileParameter, String fileName, URL imageFile, String imageFileName) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, fileParameter, fileName, imageFile.openConnection().getInputStream(), imageFileName);
    }

    public CPDFUploadFileResult uploadFile(URL file, String taskId, CPDFFileParameter fileParameter, String fileName, URL imageFile, String imageFileName, Integer language) throws IOException {
        return this.getUploadFileResult(file.openConnection().getInputStream(), taskId, null, fileParameter, fileName, imageFile.openConnection().getInputStream(), imageFileName, language);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, CPDFFileParameter fileParameter) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, fileParameter, file.getOriginalFilename());
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, CPDFFileParameter fileParameter, Integer language) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, fileParameter, file.getOriginalFilename(), language);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, CPDFFileParameter fileParameter, File imageFile) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, fileParameter, file.getOriginalFilename(), new FileInputStream(imageFile), imageFile.getName());
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, CPDFFileParameter fileParameter, File imageFile, Integer language) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, fileParameter, file.getOriginalFilename(), new FileInputStream(imageFile), imageFile.getName(), language);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, CPDFFileParameter fileParameter, URL imageFile, String imageFileName) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, fileParameter, file.getOriginalFilename(), imageFile.openConnection().getInputStream(), imageFileName);
    }

    public CPDFUploadFileResult uploadFile(MultipartFile file, String taskId, CPDFFileParameter fileParameter, URL imageFile, String imageFileName, Integer language) throws IOException {
        return this.getUploadFileResult(file.getInputStream(), taskId, null, fileParameter, file.getOriginalFilename(), imageFile.openConnection().getInputStream(), imageFileName, language);
    }

    private CPDFUploadFileResult getUploadFileResult(File file, String taskId, String password, CPDFFileParameter fileParameter) {
        return this.httpClient.getUploadFileResult(file, taskId, password, fileParameter, null);
    }

    private CPDFUploadFileResult getUploadFileResult(File file, String taskId, String password, CPDFFileParameter fileParameter, Integer language) {
        return this.httpClient.getUploadFileResult(file, taskId, password, fileParameter, language);
    }

    private CPDFUploadFileResult getUploadFileResult(File file, String taskId, String password, CPDFFileParameter fileParameter, InputStream imageInputStream, String imageFileName) throws FileNotFoundException {
        return this.httpClient.getUploadFileResult(new FileInputStream(file), taskId, password, fileParameter, file.getName(), imageInputStream, imageFileName, null);
    }

    private CPDFUploadFileResult getUploadFileResult(File file, String taskId, String password, CPDFFileParameter fileParameter, InputStream imageInputStream, String imageFileName, Integer language) throws FileNotFoundException {
        return this.httpClient.getUploadFileResult(new FileInputStream(file), taskId, password, fileParameter, file.getName(), imageInputStream, imageFileName, language);
    }

    private CPDFUploadFileResult getUploadFileResult(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName) {
        return this.httpClient.getUploadFileResult(file, taskId, password, fileParameter, fileName, null, null, null);
    }

    private CPDFUploadFileResult getUploadFileResult(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, Integer language) {
        return this.httpClient.getUploadFileResult(file, taskId, password, fileParameter, fileName, null, null, language);
    }

    private CPDFUploadFileResult getUploadFileResult(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, InputStream imageInputStream, String imageFileName) {
        return this.httpClient.getUploadFileResult(file, taskId, password, fileParameter, fileName, imageInputStream, imageFileName, null);
    }

    private CPDFUploadFileResult getUploadFileResult(InputStream file, String taskId, String password, CPDFFileParameter fileParameter, String fileName, InputStream imageInputStream, String imageFileName, Integer language) {
        return this.httpClient.getUploadFileResult(file, taskId, password, fileParameter, fileName, imageInputStream, imageFileName, language);
    }

    public CPDFCreateTaskResult executeTask(String taskId) {
        return this.httpClient.executeTask(taskId, null);
    }

    public CPDFCreateTaskResult executeTask(String taskId, Integer language) {
        return this.httpClient.executeTask(taskId, language);
    }

    public CPDFTaskInfoResult getTaskInfo(String taskId) {
        return this.httpClient.getTaskInfo(taskId, null);
    }

    public CPDFTaskInfoResult getTaskInfo(String taskId, Integer language) {
        return this.httpClient.getTaskInfo(taskId, language);
    }
}

