/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.basic.common.api.reflect;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class Devon4jPackage {
    public static final String LAYER_COMMON = "common";
    public static final String LAYER_DATA_ACCESS = "dataaccess";
    public static final String LAYER_LOGIC = "logic";
    public static final String LAYER_SERVICE = "service";
    public static final String LAYER_BATCH = "batch";
    public static final String LAYER_CLIENT = "client";
    public static final String SCOPE_API = "api";
    public static final String SCOPE_BASE = "base";
    public static final String SCOPE_IMPL = "impl";
    private static final Set<String> LAYERS = new HashSet<String>(Arrays.asList("batch", "client", "common", "dataaccess", "logic", "service"));
    private static final Set<String> SCOPES = new HashSet<String>(Arrays.asList("api", "base", "impl"));
    private static final String REGEX_PKG_SEPARATOR = "\\.";
    private final String[] segments;
    private final int scopeIndex;
    private Boolean valid;
    private transient String root;
    private transient String detail;
    private transient String pkg;

    private Devon4jPackage(String pkg, String[] segments, String root, String detail, int scope) {
        Objects.requireNonNull(segments, "segments");
        this.pkg = pkg;
        for (int i = 0; i < segments.length; ++i) {
            if (Devon4jPackage.isValidSegment(segments[i])) continue;
            throw new IllegalArgumentException("segments[" + i + "] = " + segments[i]);
        }
        this.root = root;
        this.detail = detail;
        this.segments = segments;
        this.scopeIndex = scope;
    }

    private static boolean isValidSegment(String segment) {
        if (segment == null) {
            return false;
        }
        if (segment.isEmpty()) {
            return false;
        }
        return segment.indexOf(46) < 0;
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public String getSegment(int index) {
        if (index >= 0 && index < this.segments.length) {
            return this.segments[index];
        }
        return null;
    }

    public boolean isValid() {
        if (this.valid == null) {
            this.valid = this.isValidInternal();
        }
        return this.valid;
    }

    private boolean isValidInternal() {
        if (this.segments.length < 4) {
            return false;
        }
        if (!this.isValidLayer()) {
            return false;
        }
        return this.isValidScope();
    }

    public boolean isValidScope() {
        return SCOPES.contains(this.getScope());
    }

    public boolean isValidLayer() {
        return LAYERS.contains(this.getLayer());
    }

    public String getRoot() {
        if (this.root == null) {
            if (this.scopeIndex == -1) {
                return this.pkg;
            }
            int appIndex = this.scopeIndex - 3;
            if (appIndex <= 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < appIndex; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(this.segments[i]);
            }
            this.root = sb.toString();
        }
        return this.root;
    }

    public String getApplication() {
        return this.getSegment(this.scopeIndex - 3);
    }

    public String getComponent() {
        return this.getSegment(this.scopeIndex - 2);
    }

    public String getLayer() {
        return this.getSegment(this.scopeIndex - 1);
    }

    public boolean isLayerCommon() {
        return LAYER_COMMON.equals(this.getLayer());
    }

    public boolean isLayerDataAccess() {
        return LAYER_DATA_ACCESS.equals(this.getLayer());
    }

    public boolean isLayerLogic() {
        return LAYER_LOGIC.equals(this.getLayer());
    }

    public boolean isLayerService() {
        return LAYER_SERVICE.equals(this.getLayer());
    }

    public boolean isLayerBatch() {
        return LAYER_BATCH.equals(this.getLayer());
    }

    public boolean isLayerClient() {
        return LAYER_CLIENT.equals(this.getLayer());
    }

    public String getScope() {
        return this.getSegment(this.scopeIndex);
    }

    public boolean isScopeApi() {
        return SCOPE_API.equals(this.getScope());
    }

    public boolean isScopeBase() {
        return SCOPE_BASE.equals(this.getScope());
    }

    public boolean isScopeImpl() {
        return SCOPE_IMPL.equals(this.getScope());
    }

    public String getDetail() {
        if (this.detail == null) {
            if (this.scopeIndex < 3) {
                return null;
            }
            this.detail = this.joinPackage(this.scopeIndex + 1);
        }
        return this.detail;
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.scopeIndex);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != Devon4jPackage.class) {
            return false;
        }
        Devon4jPackage other = (Devon4jPackage)obj;
        if (!Arrays.deepEquals(this.segments, other.segments)) {
            return false;
        }
        return this.scopeIndex == other.scopeIndex;
    }

    public String toString() {
        if (this.pkg == null) {
            this.pkg = this.joinPackage(0);
        }
        return this.pkg;
    }

    private String joinPackage(int start) {
        return this.joinPackage(start, this.segments.length);
    }

    private String joinPackage(int start, int end) {
        if (start >= end) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (i > start) {
                sb.append('.');
            }
            sb.append(this.segments[i]);
        }
        return sb.toString();
    }

    public static Devon4jPackage of(String root, String application, String component, String layer, String scope, String detail) {
        String[] roots = root == null ? new String[]{} : root.split(REGEX_PKG_SEPARATOR);
        String[] details = detail == null ? new String[]{} : detail.split(REGEX_PKG_SEPARATOR);
        String[] segments = new String[roots.length + details.length + 4];
        System.arraycopy(roots, 0, segments, 0, roots.length);
        int i = roots.length;
        segments[i++] = application;
        segments[i++] = component;
        segments[i++] = layer;
        segments[i++] = scope;
        System.arraycopy(details, 0, segments, i, details.length);
        return new Devon4jPackage(null, segments, root, detail, i - 1);
    }

    public static Devon4jPackage of(String packageName) {
        String[] segments = packageName.split(REGEX_PKG_SEPARATOR);
        int scopeIndex = -1;
        for (int i = 2; i < segments.length; ++i) {
            if (SCOPES.contains(segments[i])) {
                scopeIndex = i;
                break;
            }
            if (!LAYERS.contains(segments[i])) continue;
            scopeIndex = i + 1;
        }
        return new Devon4jPackage(packageName, segments, null, null, scopeIndex);
    }

    public static Devon4jPackage of(Package javaPackage) {
        return Devon4jPackage.of(javaPackage.getName());
    }

    public static Devon4jPackage of(Class<?> type) {
        return Devon4jPackage.of(type.getPackage());
    }
}

