/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.call;

import com.exsoloscript.challonge.handler.call.ChallongeApiCall;
import com.exsoloscript.challonge.handler.call.RetrofitChallongeApiCallFactory;
import com.exsoloscript.challonge.handler.retrofit.RetrofitAttachmentHandler;
import com.exsoloscript.challonge.handler.retrofit.RetrofitServiceProvider;
import com.exsoloscript.challonge.model.Attachment;
import com.exsoloscript.challonge.model.query.AttachmentQuery;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Singleton
public class AttachmentHandler {
    private final RetrofitAttachmentHandler attachmentHandler;
    private final RetrofitChallongeApiCallFactory factory;

    @Inject
    AttachmentHandler(RetrofitServiceProvider provider, RetrofitChallongeApiCallFactory factory) {
        this.attachmentHandler = provider.createService(RetrofitAttachmentHandler.class);
        this.factory = factory;
    }

    public ChallongeApiCall<List<Attachment>> getAttachments(String tournament, int matchId) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tournament), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.attachmentHandler.getAttachments(tournament, matchId));
    }

    public ChallongeApiCall<Attachment> getAttachment(String tournament, int matchId, int attachmentId) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tournament), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.attachmentHandler.getAttachment(tournament, matchId, attachmentId));
    }

    public ChallongeApiCall<Attachment> createAttachment(String tournament, int matchId, AttachmentQuery attachment) throws IOException {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tournament), (String)"Tournament string is required", (Object[])new Object[0]);
        MultipartBody.Part asset = attachment.asset() != null ? MultipartBody.Part.createFormData((String)"match_attachment[asset]", (String)attachment.asset().getName(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)attachment.getMimeType()), (File)attachment.asset())) : null;
        MultipartBody.Part url = attachment.url() != null ? MultipartBody.Part.createFormData((String)"match_attachment[url]", (String)attachment.url()) : null;
        MultipartBody.Part desc = attachment.description() != null ? MultipartBody.Part.createFormData((String)"match_attachment[description]", (String)attachment.description()) : null;
        return this.factory.createApiCall(this.attachmentHandler.createAttachment(tournament, matchId, asset, desc, url));
    }

    public ChallongeApiCall<Attachment> updateAttachment(String tournament, int matchId, int attachmentId, AttachmentQuery attachment) throws IOException {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tournament), (String)"Tournament string is required", (Object[])new Object[0]);
        MultipartBody.Part asset = attachment.asset() != null ? MultipartBody.Part.createFormData((String)"match_attachment[asset]", (String)attachment.asset().getName(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)attachment.getMimeType()), (File)attachment.asset())) : null;
        MultipartBody.Part url = attachment.url() != null ? MultipartBody.Part.createFormData((String)"match_attachment[url]", (String)attachment.url()) : null;
        MultipartBody.Part desc = attachment.description() != null ? MultipartBody.Part.createFormData((String)"match_attachment[description]", (String)attachment.description()) : null;
        return this.factory.createApiCall(this.attachmentHandler.updateAttachment(tournament, matchId, attachmentId, asset, url, desc));
    }

    public ChallongeApiCall<Attachment> deleteAttachment(String tournament, int matchId, int attachmentId) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)tournament), (String)"Tournament string is required", (Object[])new Object[0]);
        return this.factory.createApiCall(this.attachmentHandler.deleteAttachment(tournament, matchId, attachmentId));
    }
}

