/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.gson;

import com.exsoloscript.challonge.gson.GsonAdapter;
import com.exsoloscript.challonge.library.google.gson.JsonDeserializationContext;
import com.exsoloscript.challonge.library.google.gson.JsonDeserializer;
import com.exsoloscript.challonge.library.google.gson.JsonElement;
import com.exsoloscript.challonge.library.google.gson.JsonParseException;
import com.exsoloscript.challonge.library.google.gson.JsonPrimitive;
import com.exsoloscript.challonge.library.google.gson.JsonSerializationContext;
import com.exsoloscript.challonge.library.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class OffsetDateTimeAdapter
implements GsonAdapter,
JsonSerializer<OffsetDateTime>,
JsonDeserializer<OffsetDateTime> {
    @Override
    public OffsetDateTime deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
        if (jsonPrimitive.isString()) {
            return OffsetDateTime.parse(jsonPrimitive.getAsString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        throw new JsonParseException("Unable to parse OffsetDateTime. DateTime was not provided as string.");
    }

    @Override
    public JsonElement serialize(OffsetDateTime offsetDateTime, Type type, JsonSerializationContext jsonSerializationContext) {
        String s = offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return new JsonPrimitive(s);
    }
}

