/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.call;

import com.exsoloscript.challonge.handler.call.ChallongeApiCall;
import com.exsoloscript.challonge.handler.call.RetrofitChallongeApiCallFactory;
import com.exsoloscript.challonge.handler.retrofit.RetrofitAttachmentHandler;
import com.exsoloscript.challonge.handler.retrofit.RetrofitServiceProvider;
import com.exsoloscript.challonge.library.commons.lang3.StringUtils;
import com.exsoloscript.challonge.library.commons.lang3.Validate;
import com.exsoloscript.challonge.library.google.inject.Inject;
import com.exsoloscript.challonge.library.google.inject.Singleton;
import com.exsoloscript.challonge.model.Attachment;
import com.exsoloscript.challonge.model.exception.ChallongeException;
import com.exsoloscript.challonge.model.query.AttachmentQuery;
import java.io.IOException;
import java.util.List;

@Singleton
public class AttachmentHandler {
    private RetrofitAttachmentHandler attachmentHandler;
    private RetrofitChallongeApiCallFactory factory;

    @Inject
    AttachmentHandler(RetrofitServiceProvider provider, RetrofitChallongeApiCallFactory factory) {
        this.attachmentHandler = provider.createService(RetrofitAttachmentHandler.class);
        this.factory = factory;
    }

    public ChallongeApiCall<List<Attachment>> getAttachments(String tournament, int matchId) throws IOException, ChallongeException {
        Validate.isTrue(StringUtils.isNotBlank(tournament), "Tournament string is required", new Object[0]);
        Validate.notNull(matchId, "Match id is required", new Object[0]);
        return this.factory.createApiCall(this.attachmentHandler.getAttachments(tournament, matchId));
    }

    public ChallongeApiCall<Attachment> getAttachment(String tournament, int matchId, int attachmentId) throws IOException, ChallongeException {
        Validate.isTrue(StringUtils.isNotBlank(tournament), "Tournament string is required", new Object[0]);
        Validate.notNull(matchId, "Match id is required", new Object[0]);
        Validate.notNull(attachmentId, "Attachment id is required", new Object[0]);
        return this.factory.createApiCall(this.attachmentHandler.getAttachment(tournament, matchId, attachmentId));
    }

    public ChallongeApiCall<Attachment> createAttachment(String tournament, int matchId, AttachmentQuery attachment) throws IOException, ChallongeException {
        Validate.isTrue(StringUtils.isNotBlank(tournament), "Tournament string is required", new Object[0]);
        Validate.notNull(matchId, "Match id is required", new Object[0]);
        return this.factory.createApiCall(this.attachmentHandler.createAttachment(tournament, matchId, attachment));
    }

    public ChallongeApiCall<Attachment> updateAttachment(String tournament, int matchId, int attachmentId, AttachmentQuery attachment) throws IOException, ChallongeException {
        Validate.isTrue(StringUtils.isNotBlank(tournament), "Tournament string is required", new Object[0]);
        Validate.notNull(matchId, "Match id is required", new Object[0]);
        Validate.notNull(attachmentId, "Attachment id is required", new Object[0]);
        return this.factory.createApiCall(this.attachmentHandler.updateAttachment(tournament, matchId, attachmentId, attachment));
    }

    public ChallongeApiCall<Attachment> deleteAttachment(String tournament, int matchId, int attachmentId) throws IOException, ChallongeException {
        Validate.isTrue(StringUtils.isNotBlank(tournament), "Tournament string is required", new Object[0]);
        Validate.notNull(matchId, "Match id is required", new Object[0]);
        Validate.notNull(attachmentId, "Attachment id is required", new Object[0]);
        return this.factory.createApiCall(this.attachmentHandler.deleteAttachment(tournament, matchId, attachmentId));
    }
}

